/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.spi.ImageReaderSpi;
import org.geotoolkit.coverage.grid.ImageGeometry;
import org.geotoolkit.image.io.mosaic.GridTileManager;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.image.io.mosaic.TreeTileManager;
import org.geotoolkit.util.Utilities;

final class ComparedTileManager
extends TileManager {
    private static final long serialVersionUID = -6028433158360279586L;
    final TileManager first;
    final TileManager second;

    ComparedTileManager(Tile[] tileArray) throws IOException {
        this.second = new GridTileManager(tileArray);
        this.first = new TreeTileManager(tileArray);
    }

    ComparedTileManager(TileManager tileManager, TileManager tileManager2) {
        this.first = tileManager;
        this.second = tileManager2;
    }

    private <T> T assertEqual(T t, T t2) throws AssertionError {
        if (!Utilities.equals(t, t2)) {
            throw new AssertionError((Object)(this.first.getClass().getSimpleName() + '=' + t + ", " + this.second.getClass().getSimpleName() + '=' + t2));
        }
        return t;
    }

    private boolean equal(Collection<Tile> collection, Collection<Tile> collection2) {
        return ComparedTileManager.equals(this.first, collection, collection2) & ComparedTileManager.equals(this.second, collection2, collection);
    }

    private static boolean equals(TileManager tileManager, Collection<Tile> collection, Collection<Tile> collection2) {
        LinkedHashSet<Tile> linkedHashSet = new LinkedHashSet<Tile>(collection);
        for (Tile tile : collection2) {
            linkedHashSet.remove(tile);
        }
        if (linkedHashSet.isEmpty()) {
            return true;
        }
        PrintStream printStream = System.err;
        printStream.print("Additional tiles from ");
        printStream.print(tileManager.getClass().getSimpleName());
        printStream.println(':');
        printStream.println(Tile.toString(linkedHashSet, 100));
        return false;
    }

    @Override
    public void setGridToCRS(AffineTransform affineTransform) throws IllegalStateException, IOException {
        this.first.setGridToCRS(affineTransform);
        this.second.setGridToCRS(affineTransform);
    }

    @Override
    void setGridGeometry(ImageGeometry imageGeometry) {
        this.first.setGridGeometry(imageGeometry);
        this.second.setGridGeometry(imageGeometry);
    }

    @Override
    public ImageGeometry getGridGeometry() throws IOException {
        return this.assertEqual(this.first.getGridGeometry(), this.second.getGridGeometry());
    }

    @Override
    Rectangle getRegion() throws IOException {
        return this.assertEqual(this.first.getRegion(), this.second.getRegion());
    }

    @Override
    Dimension getTileSize() throws IOException {
        return this.assertEqual(this.first.getTileSize(), this.second.getTileSize());
    }

    @Override
    boolean isImageTiled() throws IOException {
        return this.assertEqual(this.first.isImageTiled(), this.second.isImageTiled());
    }

    @Override
    public Set<ImageReaderSpi> getImageReaderSpis() throws IOException {
        return this.assertEqual(this.first.getImageReaderSpis(), this.second.getImageReaderSpis());
    }

    @Override
    public Tile createGlobalTile(ImageReaderSpi imageReaderSpi, Object object, int n) throws NoSuchElementException, IOException {
        return this.assertEqual(this.first.createGlobalTile(imageReaderSpi, object, n), this.second.createGlobalTile(imageReaderSpi, object, n));
    }

    @Override
    public Collection<Tile> getTiles() throws IOException {
        Collection<Tile> collection = this.first.getTiles();
        if (!this.equal(collection, this.second.getTiles())) {
            throw new AssertionError();
        }
        return collection;
    }

    @Override
    public Collection<Tile> getTiles(Rectangle rectangle, Dimension dimension, boolean bl) throws IOException {
        Dimension dimension2 = new Dimension(dimension);
        Collection<Tile> collection = this.first.getTiles(rectangle, dimension, bl);
        if (this.equal(collection, this.second.getTiles(rectangle, dimension2, bl))) {
            this.assertEqual(dimension, dimension2);
        }
        return collection;
    }

    @Override
    public boolean intersects(Rectangle rectangle, Dimension dimension) throws IOException {
        return this.assertEqual(this.first.intersects(rectangle, dimension), this.second.intersects(rectangle, dimension));
    }

    public int hashCode() {
        return 0x83BFD5DE ^ this.first.hashCode() + 31 * this.second.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ComparedTileManager) {
            ComparedTileManager comparedTileManager = (ComparedTileManager)object;
            return Utilities.equals((Object)this.first, (Object)comparedTileManager.first) && Utilities.equals((Object)this.second, (Object)comparedTileManager.second);
        }
        return false;
    }
}

