/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.image.io.metadata.SampleDimension;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.internal.CodeLists;
import org.geotoolkit.lang.Builder;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.TypeValuePolicy;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.metadata.ValueRestriction;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.annotation.Obligation;
import org.opengis.coverage.grid.GridCell;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridPoint;
import org.opengis.coverage.grid.RectifiedGrid;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.primitive.Point;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.acquisition.Requirement;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.lineage.ProcessStepReport;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.Scope;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.RecordType;

public class SpatialMetadataFormatBuilder
extends Builder<SpatialMetadataFormat> {
    private final SpatialMetadataFormat metadata;
    private boolean done;
    private Map<Class<?>, Class<?>> substitutions;
    private final Set<Class<?>> excludes = new HashSet();
    private Set<Class<?>> incompletes = Collections.emptySet();
    private final Map<String, Class<?>> existings = new HashMap();

    public SpatialMetadataFormatBuilder(String string) {
        this.metadata = new SpatialMetadataFormat(string);
    }

    public SpatialMetadataFormatBuilder(Class<? extends SpatialMetadataFormat> clazz) throws InstantiationException, IllegalAccessException {
        this.metadata = clazz.newInstance();
    }

    public Map<Class<?>, Class<?>> substitutions() {
        if (this.substitutions == null) {
            this.substitutions = new HashMap();
        }
        return this.substitutions;
    }

    private void ensureModifiable() {
        if (this.done) {
            throw new UnmodifiableMetadataException(Errors.format((int)231, this.metadata.getClass()));
        }
    }

    public void addTree(MetadataStandard metadataStandard, Class<?> clazz) {
        ArgumentChecks.ensureNonNull((String)"standard", (Object)metadataStandard);
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        this.addTree(metadataStandard, clazz, clazz.getSimpleName(), this.metadata.getRootName(), false);
    }

    public void addTree(MetadataStandard metadataStandard, Class<?> clazz, String string, String string2, boolean bl) {
        Map.Entry<Class<?>, Class<?>> entry2;
        ArgumentChecks.ensureNonNull((String)"standard", (Object)metadataStandard);
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"elementName", (Object)string);
        ArgumentChecks.ensureNonNull((String)"parentName", (Object)string2);
        this.ensureModifiable();
        this.excludes.clear();
        if (this.substitutions != null) {
            for (Map.Entry<Class<?>, Class<?>> entry2 : this.substitutions.entrySet()) {
                if (entry2.getValue() != null) continue;
                this.excludes.add((Class<?>)entry2.getKey());
            }
        }
        int n = 1;
        entry2 = null;
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
            n = Integer.MAX_VALUE;
            try {
                entry2 = metadataStandard.getInterface(clazz).getSimpleName();
            }
            catch (ClassCastException classCastException) {
                entry2 = string;
            }
        }
        this.existings.clear();
        this.addTreeRecursively(metadataStandard, clazz, (String)((Object)entry2), string, string2, bl ? 1 : 0, n, null);
        this.incompletes = Collections.emptySet();
    }

    private String addTreeRecursively(MetadataStandard metadataStandard, Class<?> clazz, String string, String string2, String string3, int n, int n2, ValueRestriction valueRestriction) {
        int n3;
        Object object;
        if (n2 == 0) {
            return null;
        }
        if (CodeList.class.isAssignableFrom(clazz)) {
            Class<?> clazz2 = clazz;
            this.metadata.addEnumeration(string3, string2, n != 0, SpatialMetadataFormatBuilder.getCodeList(clazz2));
            return string2;
        }
        if (!metadataStandard.isMetadata(clazz)) {
            String string4 = string2;
            if (n2 != 1) {
                Class<?> clazz3 = clazz.getComponentType();
                if (clazz3 != null) {
                    string4 = string2 = SpatialMetadataFormat.toElementName(string2);
                    String string5 = SpatialMetadataFormatBuilder.toComponentName(string2, string, true);
                    this.metadata.addListWrapper(metadataStandard, string3, string2, string5, clazz3, n, n2);
                    string3 = string5;
                    string2 = "values";
                    clazz = clazz3;
                }
                this.metadata.addAttribute(string3, string2, SpatialMetadataFormatBuilder.typeOf(clazz), n, n2, null);
            } else {
                this.metadata.addAttribute(string3, string2, SpatialMetadataFormatBuilder.typeOf(clazz), n, n2, valueRestriction != null ? valueRestriction.range : null);
            }
            return string4;
        }
        String string6 = string2 = SpatialMetadataFormat.toElementName(string2);
        if (n2 != 1) {
            Class<?> clazz4 = this.existings.get(string2);
            if (clazz4 != null) {
                if (!clazz4.equals(clazz)) {
                    throw new IllegalArgumentException(string2);
                }
                this.metadata.addExistingElement(string2, string3);
                return null;
            }
            this.metadata.addElement(metadataStandard, null, string2, string3, 5, n, n2);
            this.existings.put(string2, clazz);
            string3 = string2;
            string = SpatialMetadataFormat.toElementName(string);
            string2 = SpatialMetadataFormatBuilder.toComponentName(string2, string, false);
        }
        boolean bl = false;
        Obligation obligation = Obligation.FORBIDDEN;
        Map map = metadataStandard.asNameMap(clazz, KeyNamePolicy.METHOD_NAME, SpatialMetadataFormat.NAME_POLICY);
        Map map2 = metadataStandard.asNameMap(clazz, KeyNamePolicy.UML_IDENTIFIER, SpatialMetadataFormat.NAME_POLICY);
        Map map3 = metadataStandard.asTypeMap(clazz, TypeValuePolicy.PROPERTY_TYPE, SpatialMetadataFormat.NAME_POLICY);
        Map map4 = metadataStandard.asTypeMap(clazz, TypeValuePolicy.ELEMENT_TYPE, SpatialMetadataFormat.NAME_POLICY);
        Map map5 = metadataStandard.asRestrictionMap(clazz, NullValuePolicy.NON_NULL, SpatialMetadataFormat.NAME_POLICY);
        boolean bl2 = this.incompletes != null && !this.incompletes.contains(clazz);
        for (Map.Entry object22 : map4.entrySet()) {
            Class clazz2 = (Class)object22.getValue();
            if (bl2 && this.excludes.contains(clazz2) || !metadataStandard.isMetadata(clazz2) || CodeList.class.isAssignableFrom(clazz2)) continue;
            ValueRestriction valueRestriction2 = (ValueRestriction)map5.get(object22.getKey());
            if (valueRestriction2 != null && (object = valueRestriction2.obligation) != null) {
                if (!bl) {
                    bl = true;
                    obligation = object;
                    continue;
                }
                if (object == obligation) continue;
            }
            obligation = null;
            bl = true;
            break;
        }
        if (obligation == null) {
            obligation = Obligation.OPTIONAL;
        }
        switch (obligation) {
            case MANDATORY: {
                n3 = 1;
                break;
            }
            case CONDITIONAL: {
                n3 = 3;
                break;
            }
            case FORBIDDEN: {
                n3 = 0;
                break;
            }
            default: {
                n3 = 2;
            }
        }
        Class<?> clazz3 = this.existings.get(string2);
        if (clazz3 != null) {
            if (!clazz3.equals(clazz)) {
                throw new IllegalArgumentException(string2);
            }
            this.metadata.addExistingElement(string2, string3);
            return null;
        }
        this.metadata.addElement(metadataStandard, clazz, string2, string3, n3, 0, 1);
        for (Map.Entry entry : map3.entrySet()) {
            Class clazz4;
            object = (String)entry.getKey();
            ValueRestriction valueRestriction3 = (ValueRestriction)map5.get(object);
            int n4 = 0;
            int n5 = 1;
            if (valueRestriction3 != null && valueRestriction3.obligation != null) {
                switch (valueRestriction3.obligation) {
                    case MANDATORY: {
                        n4 = 1;
                        break;
                    }
                    case FORBIDDEN: {
                        n5 = 0;
                    }
                }
            }
            if (Collection.class.isAssignableFrom(clazz4 = (Class)entry.getValue())) {
                clazz4 = (Class)map4.get(object);
                if (clazz4 == null) continue;
                n5 = Integer.MAX_VALUE;
            }
            if (this.substitutions != null) {
                Class clazz5 = null;
                if (n5 > 1 && (clazz5 = this.substitutions.get(Classes.changeArrayDimension((Class)clazz4, (int)1))) != null) {
                    clazz4 = clazz5;
                    object = (String)map2.get(object);
                    n5 = 1;
                }
                if ((clazz5 = this.substitutions.get(clazz4)) != null && (clazz5 = (clazz4 = clazz5).getComponentType()) != null) {
                    n5 = Integer.MAX_VALUE;
                    clazz4 = clazz5;
                }
            }
            if (!this.excludes.add(clazz4)) continue;
            object = this.addTreeRecursively(metadataStandard, clazz4, (String)map2.get(object), (String)object, string2, n4, n5, valueRestriction3);
            if (!this.excludes.remove(clazz4)) {
                throw new AssertionError(clazz4);
            }
            if (object == null) continue;
            this.metadata.mapName(string2, (String)map.get(entry.getKey()), (String)object);
        }
        return string6;
    }

    private static int typeOf(Class<?> clazz) {
        if (Number.class.isAssignableFrom(clazz = Numbers.primitiveToWrapper(clazz))) {
            if (Numbers.isInteger((Class)clazz)) {
                return 2;
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return 3;
            }
            return 4;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return 1;
        }
        return 0;
    }

    private static String[] getCodeList(Class<? extends CodeList<?>> clazz) {
        String[] stringArray = CodeLists.identifiers(clazz);
        if (clazz == AxisDirection.class) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith("Other")) continue;
                stringArray[i] = "other";
            }
        }
        return stringArray;
    }

    private static String toComponentName(String string, String string2, boolean bl) {
        if (string2 != null && !string2.equalsIgnoreCase(string)) {
            return string2;
        }
        if (bl && string.endsWith("s")) {
            return string.substring(0, string.length() - 1);
        }
        return (string2 != null ? string2 : string) + "Entry";
    }

    protected void addTreeForISO19115(String string) {
        this.ensureModifiable();
        if (string == null) {
            string = this.metadata.getRootName();
        }
        Map<Class<?>, Class<?>> map = this.substitutions();
        map.put(ProcessStepReport.class, null);
        map.put(Source.class, null);
        this.addTree(MetadataStandard.ISO_19115, Metadata.class, "Metadata", string, false);
    }

    public void addTreeForStream(String string) {
        this.ensureModifiable();
        if (string == null) {
            string = this.metadata.getRootName();
        }
        Map<Class<?>, Class<?>> map = this.substitutions();
        map.put(Format.class, null);
        map.put(Locale.class, null);
        map.put(CharacterSet.class, null);
        map.put(BrowseGraphic.class, null);
        map.put(SpatialRepresentationType.class, null);
        map.put(Usage.class, null);
        map.put(ResponsibleParty.class, null);
        map.put(Constraints.class, null);
        map.put(MaintenanceInformation.class, null);
        map.put(AggregateInformation.class, null);
        map.put(Plan.class, null);
        map.put(Objective.class, null);
        map.put(Operation.class, null);
        map.put(Requirement.class, null);
        map.put(Scope.class, null);
        map.put(Lineage.class, null);
        map.put(Result.class, null);
        map.put(TemporalExtent.class, null);
        map.put(Citation.class, String.class);
        map.put(Citation[].class, String.class);
        map.put(Identifier.class, String.class);
        map.put(Instrument.class, null);
        map.put(Extent[].class, Extent.class);
        map.put(GeographicExtent[].class, GeographicExtent.class);
        map.put(VerticalExtent[].class, VerticalExtent.class);
        map.put(Resolution[].class, Resolution.class);
        map.put(Platform[].class, Platform.class);
        map.put(Element[].class, Element.class);
        map.put(Date[].class, Date.class);
        map.put(Identification.class, DataIdentification.class);
        map.put(SpatialRepresentation.class, GridSpatialRepresentation.class);
        map.put(GeographicExtent.class, GeographicBoundingBox.class);
        MetadataStandard metadataStandard = MetadataStandard.ISO_19115;
        this.addTree(metadataStandard, DataIdentification.class, "DiscoveryMetadata", string, false);
        this.addTree(metadataStandard, AcquisitionInformation.class, "AcquisitionMetadata", string, false);
        this.addTree(metadataStandard, DataQuality.class, "QualityMetadata", string, false);
        this.metadata.removeAttribute("EquivalentScale", "doubleValue");
        map.put(Platform.class, null);
        map.remove(Identifier.class);
        this.addTree(metadataStandard, Instrument[].class, "Instruments", "Platform", false);
        this.metadata.mapName("Instruments", "getCitations", "citation");
    }

    public void addTreeForImage(String string) {
        this.ensureModifiable();
        if (string == null) {
            string = this.metadata.getRootName();
        }
        Map<Class<?>, Class<?>> map = this.substitutions();
        map.put(Citation.class, String.class);
        map.put(RecordType.class, null);
        map.put(RangeDimension.class, Band.class);
        MetadataStandard metadataStandard = MetadataStandard.ISO_19115;
        this.addTree(metadataStandard, ImageDescription.class, "ImageDescription", string, false);
        this.metadata.addAttribute("Dimension", "validSampleValues", 0, 0, 1, null);
        this.metadata.addAttribute("Dimension", "fillSampleValues", 4, 0, Integer.MAX_VALUE, null);
        this.metadata.addObjectValue("Dimension", SampleDimension.class);
        map.put(Dimension.class, null);
        map.put(Point.class, double[].class);
        map.put(GCP.class, null);
        map.put(Boolean.TYPE, null);
        map.put(InternationalString.class, null);
        this.addTree(metadataStandard, Georectified.class, "SpatialRepresentation", string, false);
        this.metadata.removeAttribute("SpatialRepresentation", "cornerPoints");
        map.put(String.class, null);
        map.put(GridCell.class, null);
        map.put(GridPoint.class, null);
        map.put(GridEnvelope.class, null);
        map.put(GridCoordinates.class, int[].class);
        map.put(DirectPosition.class, double[].class);
        metadataStandard = MetadataStandard.ISO_19123;
        this.incompletes = null;
        this.addTree(metadataStandard, RectifiedGrid.class, "RectifiedGridDomain", string, false);
        this.addTree(metadataStandard, GridEnvelope.class, "Limits", "RectifiedGridDomain", false);
        this.metadata.removeAttribute("Limits", "dimension");
        this.metadata.removeAttribute("RectifiedGridDomain", "dimension");
        this.metadata.mapName("RectifiedGridDomain", "getExtent", "Limits");
    }

    protected void addTreeForCRS(String string) {
        this.ensureModifiable();
        if (string == null) {
            string = this.metadata.getRootName();
        }
        Map<Class<?>, Class<?>> map = this.substitutions();
        map.put(ReferenceIdentifier.class, null);
        map.put(GenericName.class, null);
        map.put(String.class, null);
        map.put(Extent.class, null);
        map.put(InternationalString.class, null);
        map.put(Date.class, null);
        map.put(Boolean.TYPE, null);
        map.put(Datum.class, GeodeticDatum.class);
        MetadataStandard metadataStandard = MetadataStandard.ISO_19111;
        this.incompletes = new HashSet(4);
        this.incompletes.add(CoordinateReferenceSystem.class);
        this.incompletes.add(CoordinateSystem.class);
        this.incompletes.add(GeodeticDatum.class);
        this.addTree(metadataStandard, SingleCRS.class, "CoordinateReferenceSystem", string, false);
        this.metadata.addObjectValue("CoordinateReferenceSystem", CoordinateReferenceSystem.class);
        this.metadata.addObjectValue("Datum", Datum.class);
        this.addTree(metadataStandard, CoordinateSystemAxis[].class, "Axes", "CoordinateSystem", true);
        map.put(MathTransform.class, null);
        map.put(OperationMethod.class, null);
        map.put(PositionalAccuracy.class, null);
        map.put(CoordinateReferenceSystem.class, null);
        map.put(ParameterValueGroup.class, null);
        this.incompletes = null;
        this.addTree(metadataStandard, Conversion.class, "Conversion", "CoordinateReferenceSystem", false);
        this.metadata.addAttribute("Conversion", "method", 0, 1, 1, null);
        this.metadata.addElement(null, ParameterValueGroup.class, "Parameters", "Conversion", 5, 0, Integer.MAX_VALUE);
        this.metadata.addElement(null, ParameterValue.class, "ParameterValue", "Parameters", 0, 0, 0);
        this.metadata.addAttribute("ParameterValue", "name", 0, 1, 1, null);
        this.metadata.addAttribute("ParameterValue", "value", 4, 1, 1, null);
    }

    public SpatialMetadataFormat build() {
        this.done = true;
        return this.metadata;
    }
}

