/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import javax.swing.tree.TreeNode;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.gui.swing.tree.TreeTableNode;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.image.io.metadata.MetadataDescriptions;
import org.geotoolkit.image.io.metadata.MetadataTreeTable;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormatBuilder;
import org.geotoolkit.internal.image.io.DataTypes;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.referencing.crs.DefaultGeocentricCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultEngineeringDatum;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.referencing.datum.DefaultVerticalDatum;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;

public class SpatialMetadataFormat
extends IIOMetadataFormatImpl {
    public static final String GEOTK_FORMAT_NAME = "geotk-coverageio_3.07";
    public static final String ISO_FORMAT_NAME = "ISO-19115_3.0";
    static final KeyNamePolicy NAME_POLICY = KeyNamePolicy.JAVABEANS_PROPERTY;
    private final Map<String, MetadataStandard> standards = new HashMap<String, MetadataStandard>();
    private final Map<String, Map<String, String>> namesMapping = new HashMap<String, Map<String, String>>();
    private volatile transient MetadataDescriptions descriptions;

    public static SpatialMetadataFormat getStreamInstance(String string) {
        if (string.equalsIgnoreCase(GEOTK_FORMAT_NAME)) {
            return Geotk.STREAM;
        }
        if (string.equalsIgnoreCase(ISO_FORMAT_NAME)) {
            return ISO.INSTANCE;
        }
        throw new IllegalArgumentException(Errors.format((int)73, (Object)"name", (Object)string));
    }

    public static SpatialMetadataFormat getImageInstance(String string) {
        if (string.equalsIgnoreCase(GEOTK_FORMAT_NAME)) {
            return Geotk.IMAGE;
        }
        throw new IllegalArgumentException(Errors.format((int)73, (Object)"name", (Object)string));
    }

    protected SpatialMetadataFormat(String string) {
        super(string, 2);
    }

    final <T> void addElement(MetadataStandard metadataStandard, Class<T> clazz, String string, String string2, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                n = 0;
            }
            case 1: {
                this.addElement(string, string2, n);
                break;
            }
            default: {
                this.addElement(string, string2, n2, n3);
            }
        }
        if (metadataStandard != null) {
            this.standards.put(string, metadataStandard);
        }
        if (clazz != null) {
            this.addObjectValue(string, clazz);
            this.addCustomAttributes(string, clazz);
        }
    }

    final void addExistingElement(String string, String string2) {
        this.addChildElement(string, string2);
    }

    final <T> void addObjectValue(String string, Class<T> clazz) {
        this.addObjectValue(string, clazz, false, this.getDefaultValue(clazz));
    }

    final void addListWrapper(MetadataStandard metadataStandard, String string, String string2, String string3, Class<?> clazz, int n, int n2) {
        this.addElement(string2, string, n, n2);
        this.standards.put(string2, metadataStandard);
        this.addElement(string3, string2, 0);
        this.addObjectValue(string3, clazz, 0, Integer.MAX_VALUE);
        this.standards.put(string3, metadataStandard);
    }

    final void addEnumeration(String string, String string2, boolean bl, String ... stringArray) {
        this.addAttribute(string, string2, 0, bl, null, Arrays.asList(stringArray));
    }

    final void addAttribute(String string, String string2, int n, int n2, int n3, NumberRange<?> numberRange) {
        if (n == 1) {
            this.addBooleanAttribute(string, string2, n2 == 0, false);
        } else if (numberRange != null) {
            this.addAttribute(string, string2, n, n2 != 0, null, SpatialMetadataFormat.toString(numberRange.getMinValue()), SpatialMetadataFormat.toString(numberRange.getMaxValue()), numberRange.isMinIncluded(), numberRange.isMaxIncluded());
        } else if (n3 == 1) {
            this.addAttribute(string, string2, n, n2 != 0, null);
        } else {
            this.addAttribute(string, string2, n, n2 != 0, n2, n3);
        }
    }

    final void addCustomAttributes(String string, Class<?> clazz) {
        List<String> list;
        if (IdentifiedObject.class.isAssignableFrom(clazz)) {
            this.addAttribute(string, "name", 0, true, null);
        }
        if (CoordinateSystemAxis.class.isAssignableFrom(clazz)) {
            this.addAttribute(string, "axisAbbrev", 0, true, null);
        }
        if (CoordinateReferenceSystem.class.isAssignableFrom(clazz)) {
            list = DataTypes.CRS_TYPES;
        } else if (CoordinateSystem.class.isAssignableFrom(clazz)) {
            list = DataTypes.CS_TYPES;
        } else if (Datum.class.isAssignableFrom(clazz)) {
            list = DataTypes.DATUM_TYPES;
        } else {
            return;
        }
        this.addAttribute(string, "type", 0, true, null, list);
    }

    final void mapName(String string, String string2, String string3) throws IllegalArgumentException {
        String string4;
        ArgumentChecks.ensureNonNull((String)"parentName", (Object)string);
        ArgumentChecks.ensureNonNull((String)"methodName", (Object)string2);
        ArgumentChecks.ensureNonNull((String)"elementName", (Object)string3);
        Map<String, String> map = this.namesMapping.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            this.namesMapping.put(string, map);
        }
        if ((string4 = map.put(string2, string3)) != null && !string4.equals(string3)) {
            map.put(string2, string4);
            throw new IllegalArgumentException(Errors.format((int)55, (Object)string2));
        }
    }

    static String toElementName(String string) {
        char c;
        char c2;
        if (string != null && !(string = string.trim()).isEmpty() && (c2 = string.charAt(0)) != (c = Character.toUpperCase(c2))) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(0, c);
            string = stringBuilder.toString();
        }
        return string;
    }

    private static String toString(Comparable<?> comparable) {
        return comparable != null ? comparable.toString() : null;
    }

    @Override
    protected void removeAttribute(String string, String string2) {
        super.removeAttribute(string, string2);
    }

    @Override
    protected void removeElement(String string) {
        super.removeElement(string);
        this.standards.remove(string);
        this.namesMapping.remove(string);
    }

    @Override
    public boolean canNodeAppear(String string, ImageTypeSpecifier imageTypeSpecifier) {
        return true;
    }

    public String getElementParent(String string) {
        ArgumentChecks.ensureNonNull((String)"elementName", (Object)string);
        return this.getElementParent(this.getRootName(), string, null);
    }

    private String getElementParent(String string, String string2, StringBuilder stringBuilder) {
        String[] stringArray = this.getChildNames(string);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                if (!string3.equals(string2)) continue;
                return string;
            }
            for (String string3 : stringArray) {
                String string4 = this.getElementParent(string3, string2, stringBuilder);
                if (string4 == null) continue;
                if (stringBuilder != null) {
                    stringBuilder.insert(0, '/').insert(0, string3);
                }
                return string4;
            }
        }
        return null;
    }

    public String getElementPath(String string) {
        ArgumentChecks.ensureNonNull((String)"elementName", (Object)string);
        StringBuilder stringBuilder = new StringBuilder(64);
        String string2 = this.getElementParent(this.getRootName(), string, stringBuilder);
        if (string2 != null) {
            return stringBuilder.append(string).toString();
        }
        return null;
    }

    public MetadataStandard getElementStandard(String string) {
        return this.standards.get(string);
    }

    final Map<String, String> getElementNames(String string) {
        return this.namesMapping.get(string);
    }

    @Override
    public String getElementDescription(String string, Locale locale) {
        ArgumentChecks.ensureNonNull((String)"elementName", (Object)string);
        String string2 = this.getDescription(string, null, locale);
        if (string2 == null) {
            string2 = super.getElementDescription(string, locale);
        }
        return string2;
    }

    @Override
    public String getAttributeDescription(String string, String string2, Locale locale) {
        ArgumentChecks.ensureNonNull((String)"elementName", (Object)string);
        ArgumentChecks.ensureNonNull((String)"attrName", (Object)string2);
        String string3 = this.getDescription(string, string2, locale);
        if (string3 == null) {
            string3 = super.getAttributeDescription(string, string2, locale);
        }
        return string3;
    }

    private String getDescription(String string, String string2, Locale locale) {
        MetadataDescriptions metadataDescriptions;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (string2 == null) {
            string2 = string;
            if ((string = this.getElementParent(string)) == null) {
                return null;
            }
        }
        if ((metadataDescriptions = this.descriptions) == null || !locale.equals(metadataDescriptions.locale) || !string.equals(metadataDescriptions.elementName)) {
            MetadataStandard metadataStandard;
            Class<?> clazz = null;
            try {
                clazz = this.getObjectClass(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Map map = Collections.emptyMap();
            if (clazz != null && (metadataStandard = this.getElementStandard(string)) != null) {
                try {
                    map = metadataStandard.asDescriptionMap(clazz, locale, NAME_POLICY);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.descriptions = metadataDescriptions = new MetadataDescriptions(map, string, locale);
        }
        return metadataDescriptions.descriptions.get(string2);
    }

    public <T> T getDefaultValue(Class<T> clazz) {
        Object object = PrimeMeridian.class.isAssignableFrom(clazz) ? DefaultPrimeMeridian.GREENWICH : (Ellipsoid.class.isAssignableFrom(clazz) ? DefaultEllipsoid.WGS84 : (GeodeticDatum.class.isAssignableFrom(clazz) ? DefaultGeodeticDatum.WGS84 : (VerticalDatum.class.isAssignableFrom(clazz) ? DefaultVerticalDatum.GEOIDAL : (EngineeringDatum.class.isAssignableFrom(clazz) ? DefaultEngineeringDatum.UNKNOWN : (EllipsoidalCS.class.isAssignableFrom(clazz) ? DefaultEllipsoidalCS.GEODETIC_2D : (CartesianCS.class.isAssignableFrom(clazz) ? DefaultCartesianCS.GENERIC_2D : (GeographicCRS.class.isAssignableFrom(clazz) ? DefaultGeographicCRS.WGS84 : (GeocentricCRS.class.isAssignableFrom(clazz) ? DefaultGeocentricCRS.CARTESIAN : null))))))));
        return clazz.cast(object);
    }

    public TreeTableNode toTreeTable(Locale locale) {
        MetadataTreeTable metadataTreeTable = new MetadataTreeTable(this);
        if (locale != null) {
            metadataTreeTable.setLocale(locale);
        }
        return metadataTreeTable.getRootNode();
    }

    public String toString() {
        return Trees.toString((TreeNode)this.toTreeTable(null));
    }

    private static final class Geotk {
        static final SpatialMetadataFormat STREAM;
        static final SpatialMetadataFormat IMAGE;

        private Geotk() {
        }

        static {
            SpatialMetadataFormatBuilder spatialMetadataFormatBuilder = new SpatialMetadataFormatBuilder(SpatialMetadataFormat.GEOTK_FORMAT_NAME);
            spatialMetadataFormatBuilder.addTreeForStream(null);
            STREAM = spatialMetadataFormatBuilder.build();
            spatialMetadataFormatBuilder = new SpatialMetadataFormatBuilder(SpatialMetadataFormat.GEOTK_FORMAT_NAME);
            spatialMetadataFormatBuilder.addTreeForImage(null);
            spatialMetadataFormatBuilder.addTreeForCRS("RectifiedGridDomain");
            IMAGE = spatialMetadataFormatBuilder.build();
        }
    }

    private static final class ISO {
        static final SpatialMetadataFormat INSTANCE;

        private ISO() {
        }

        static {
            SpatialMetadataFormatBuilder spatialMetadataFormatBuilder = new SpatialMetadataFormatBuilder(SpatialMetadataFormat.ISO_FORMAT_NAME);
            spatialMetadataFormatBuilder.addTreeForISO19115(null);
            INSTANCE = spatialMetadataFormatBuilder.build();
        }
    }
}

