/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.image.io.metadata.MetadataTreeNode;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.converter.AnyConverter;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.logging.Logging;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataTreeTable
implements Localized {
    public static final int COLUMN_COUNT = 7;
    public static final int VALUE_COLUMN = 4;
    final IIOMetadataFormat format;
    private IIOMetadata metadata;
    private Locale locale;
    private boolean simplificationAllowed;
    final AnyConverter converters;
    private transient MetadataTreeNode tree;

    public MetadataTreeTable(IIOMetadataFormat iIOMetadataFormat) {
        ArgumentChecks.ensureNonNull((String)"format", (Object)iIOMetadataFormat);
        this.format = iIOMetadataFormat;
        this.locale = Locale.getDefault();
        this.converters = new AnyConverter(){

            protected void conversionFailed(NonconvertibleObjectException nonconvertibleObjectException) {
                Logging.recoverableException(MetadataTreeNode.class, (String)"getValue", (Throwable)nonconvertibleObjectException);
            }
        };
    }

    public IIOMetadataFormat getMetadataFormat() {
        return this.format;
    }

    public IIOMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IIOMetadata iIOMetadata) throws IllegalArgumentException {
        this.metadata = iIOMetadata;
        this.tree = null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            this.tree = null;
        }
    }

    public boolean getSimplificationAllowed() {
        return this.simplificationAllowed;
    }

    public void setSimplificationAllowed(boolean bl) {
        if (bl != this.simplificationAllowed) {
            this.simplificationAllowed = bl;
            this.tree = null;
        }
    }

    public MetadataTreeNode getRootNode() {
        if (this.tree == null) {
            boolean bl = this.metadata != null;
            Node node = bl ? this.metadata.getAsTree(this.format.getRootName()) : null;
            MetadataTreeNode metadataTreeNode = new MetadataTreeNode(this, this.format.getRootName(), node, bl);
            this.addChilds(metadataTreeNode, new HashMap<String, Object>());
            this.tree = metadataTreeNode;
        }
        return this.tree;
    }

    private boolean addChilds(MetadataTreeNode metadataTreeNode, Map<String, Object> map) {
        boolean bl = false;
        boolean bl2 = !metadataTreeNode.hasValue || !this.simplificationAllowed;
        String string = metadataTreeNode.getName();
        String[] stringArray = this.format.getAttributeNames(string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                MetadataTreeNode metadataTreeNode2 = new MetadataTreeNode(metadataTreeNode, string2);
                if (!bl2 && metadataTreeNode2.getUserObject() == null) continue;
                bl = true;
                if (this.simplificationAllowed && stringArray.length == 1 && metadataTreeNode2.copyToParent(metadataTreeNode)) break;
                metadataTreeNode.add((MutableTreeNode)((Object)metadataTreeNode2));
            }
        }
        if ((stringArray = this.format.getChildNames(string)) != null) {
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                int n = 1;
                NodeList nodeList = null;
                if (metadataTreeNode.xmlNode instanceof Element && (nodeList = ((Element)metadataTreeNode.xmlNode).getElementsByTagName(string2)) != null) {
                    n = nodeList.getLength();
                }
                for (int i = 0; i < n; ++i) {
                    MetadataTreeNode metadataTreeNode3;
                    Object object;
                    Node node = nodeList != null ? nodeList.item(i) : null;
                    Object object2 = node != null ? node : Void.TYPE;
                    if (object2 != (object = map.put(string2, object2)) && (this.addChilds(metadataTreeNode3 = new MetadataTreeNode(this, string2, node, metadataTreeNode.hasValue), map) || bl2 || metadataTreeNode3.getUserObject() != null)) {
                        metadataTreeNode.add((MutableTreeNode)((Object)metadataTreeNode3));
                        bl = true;
                    }
                    if ((object != null ? map.put(string2, object) : map.remove(string2)) != object2) {
                        throw new AssertionError((Object)string2);
                    }
                }
            }
        }
        return bl;
    }

    public String toString() {
        return Trees.toString((TreeNode)((Object)this.getRootNode()));
    }
}

