/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.RandomAccess;
import java.util.logging.Level;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.geotoolkit.image.io.metadata.MetadataNodeParser;
import org.geotoolkit.image.io.metadata.MetadataProxy;
import org.geotoolkit.util.collection.CheckedCollection;

final class MetadataProxyList<T>
extends AbstractList<T>
implements CheckedCollection<T>,
CheckedContainer<T>,
RandomAccess {
    private final MetadataProxy<T> parent;
    private T[] elements;

    static <T> MetadataProxyList<T> create(Class<T> clazz, MetadataNodeParser metadataNodeParser) {
        return new MetadataProxyList<T>(clazz, metadataNodeParser);
    }

    private MetadataProxyList(Class<T> clazz, MetadataNodeParser metadataNodeParser) {
        this.parent = new MetadataProxy<T>(clazz, metadataNodeParser);
    }

    final void setWarningLevel(Level level) {
        if (!level.equals(this.parent.accessor.setWarningLevel(level))) {
            MetadataProxy.setWarningLevel(Arrays.asList(this.elements), level);
        }
    }

    public Class<T> getElementType() {
        return this.parent.interfaceType;
    }

    @Override
    public int size() {
        return this.parent.accessor.childCount();
    }

    @Override
    public T get(int n) {
        Object object;
        ArgumentChecks.ensureValidIndex((int)this.size(), (int)n);
        Object[] objectArray = this.elements;
        if (objectArray == null) {
            object = new Object[Math.max(4, n + 1)];
            objectArray = object;
            this.elements = object;
        } else {
            int n2 = objectArray.length;
            if (n >= n2) {
                this.elements = objectArray = Arrays.copyOf(objectArray, Math.max(n, n2 * 2));
            }
        }
        object = objectArray[n];
        if (object == null) {
            Class clazz = this.parent.interfaceType;
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 == null) {
                object = this.parent.newProxyInstance(n);
            } else {
                MetadataNodeParser metadataNodeParser = this.parent.accessor;
                metadataNodeParser.selectChild(n);
                Object[] objectArray2 = clazz2.equals(Double.TYPE) ? metadataNodeParser.getAttributeAsDoubles("values", false) : (clazz2.equals(Integer.TYPE) ? (Object[])metadataNodeParser.getAttributeAsIntegers("values", false) : (Object[])metadataNodeParser.getAttributeAsStrings("values", false));
                object = clazz.cast(objectArray2);
            }
            objectArray[n] = object;
        }
        return (T)object;
    }
}

