/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.metadata;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOParam;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.math.MathFunctions;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.display.shape.DoubleDimension2D;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.image.io.ImageMetadataException;
import org.geotoolkit.image.io.metadata.SampleDimension;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.MeasurementRange;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Range;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.coverage.grid.RectifiedGrid;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class MetadataHelper
implements Localized {
    public static final MetadataHelper INSTANCE = new MetadataHelper(null);
    private static final double EPS = 1.0E-10;
    private final org.apache.sis.util.Localized owner;
    private transient MathTransformFactory mtFactory;
    private transient MathTransform exponential;

    public MetadataHelper(org.apache.sis.util.Localized localized) {
        this.owner = localized;
    }

    public Locale getLocale() {
        return this.owner != null ? this.owner.getLocale() : null;
    }

    private MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            this.mtFactory = FactoryFinder.getMathTransformFactory(null);
        }
        return this.mtFactory;
    }

    private String error(int n, Object ... objectArray) {
        return Errors.getResources((Locale)this.getLocale()).getString(n, (Object)objectArray);
    }

    private void ensureVectorsExist(List<?> list) throws ImageMetadataException {
        this.ensureMetadataExists("OffsetVectors", -1, list);
        if (list.isEmpty()) {
            throw new ImageMetadataException(this.error(120, "OffsetVectors"));
        }
    }

    private void ensureMetadataExists(String string, int n, Object object) throws ImageMetadataException {
        if (object == null) {
            if (n >= 0) {
                string = string + '[' + n + ']';
            }
            throw new ImageMetadataException(this.error(119, string));
        }
    }

    private void ensureDimensionMatch(String string, int n, int n2, int n3) throws ImageMetadataException {
        if (n2 != n3) {
            if (n >= 0) {
                string = string + '[' + n + ']';
            }
            throw new ImageMetadataException(this.error(113, string, n2, n3));
        }
    }

    public NumberRange<?> getValidValues(SampleDimension sampleDimension) {
        if (sampleDimension == null) {
            return null;
        }
        return this.getSampleValues(sampleDimension, sampleDimension.getFillSampleValues(), true);
    }

    public NumberRange<?> getValidSampleValues(SampleDimension sampleDimension) {
        NumberRange<?> numberRange = null;
        if (sampleDimension != null && (numberRange = sampleDimension.getValidSampleValues()) == null) {
            numberRange = this.getSampleValues(sampleDimension, sampleDimension.getFillSampleValues(), false);
        }
        return numberRange;
    }

    public NumberRange<?> getValidSampleValues(int n, SampleDimension sampleDimension, double[] dArray) {
        NumberRange<?> numberRange = null;
        if (sampleDimension != null && (numberRange = sampleDimension.getValidSampleValues()) == null) {
            numberRange = this.getSampleValues(sampleDimension, dArray, false);
        }
        return numberRange;
    }

    private NumberRange<?> getSampleValues(SampleDimension sampleDimension, double[] dArray, boolean bl) {
        Object object;
        Unit<?> unit = sampleDimension.getMinValue();
        Double d = sampleDimension.getMaxValue();
        boolean bl2 = true;
        boolean bl3 = true;
        if (!bl || dArray != null) {
            double d2;
            object = unit;
            Double d3 = d;
            Double d4 = sampleDimension.getScaleFactor();
            double d5 = d4 != null ? d4 : 1.0;
            d4 = sampleDimension.getOffset();
            double d6 = d2 = d4 != null ? d4 : 0.0;
            if (d5 != 1.0 || d2 != 0.0) {
                if (object != null) {
                    object = (object.doubleValue() - d2) / d5;
                }
                if (d3 != null) {
                    d3 = (d3 - d2) / d5;
                }
            }
            if (dArray != null) {
                bl2 = MetadataHelper.inclusive(object, dArray);
                bl3 = MetadataHelper.inclusive(d3, dArray);
            }
            if (!bl) {
                unit = object;
                d = d3;
            }
        }
        if (bl && (object = sampleDimension.getUnits()) != null) {
            return MeasurementRange.createBestFit(unit, (boolean)bl2, (Number)d, (boolean)bl3, object);
        }
        return NumberRange.createBestFit(unit, (boolean)bl2, (Number)d, (boolean)bl3);
    }

    private static boolean inclusive(Number number, double[] dArray) {
        if (number != null) {
            double d = number.doubleValue();
            for (double d2 : dArray) {
                if (d2 != d) continue;
                return false;
            }
        }
        return true;
    }

    public MathTransform getGridToCRS(RectifiedGrid rectifiedGrid) throws ImageMetadataException {
        int n;
        DirectPosition directPosition = rectifiedGrid.getOrigin();
        this.ensureMetadataExists("origin", -1, directPosition);
        List list = rectifiedGrid.getOffsetVectors();
        this.ensureVectorsExist(list);
        int n2 = list.size();
        int n3 = directPosition.getDimension();
        XMatrix xMatrix = Matrices.create((int)(n3 + 1), (int)(n2 + 1));
        if (n3 < n2) {
            xMatrix.setElement(n3, n3, 0.0);
        }
        xMatrix.setElement(n3, n2, 1.0);
        for (n = 0; n < n2; ++n) {
            double[] dArray = (double[])list.get(n);
            this.ensureMetadataExists("OffsetVector", n, dArray);
            this.ensureDimensionMatch("OffsetVector", n, dArray.length, n3);
            for (int i = 0; i < n3; ++i) {
                xMatrix.setElement(i, n, dArray[i]);
            }
        }
        for (n = 0; n < n3; ++n) {
            xMatrix.setElement(n, n2, directPosition.getOrdinate(n));
        }
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        try {
            return mathTransformFactory.createAffineTransform((Matrix)xMatrix);
        }
        catch (FactoryException factoryException) {
            throw new ImageMetadataException(factoryException);
        }
    }

    public AffineTransform getAffineTransform(RectifiedGrid rectifiedGrid, IIOParam iIOParam) throws ImageMetadataException {
        Object object;
        int n;
        List list = rectifiedGrid.getOffsetVectors();
        this.ensureVectorsExist(list);
        int n2 = list.size();
        if (n2 < 2) {
            this.ensureDimensionMatch("OffsetVectors", -1, n2, 2);
        }
        DirectPosition directPosition = rectifiedGrid.getOrigin();
        this.ensureMetadataExists("origin", -1, directPosition);
        int n3 = directPosition.getDimension();
        if (n3 < 2 || !MetadataHelper.isSeparable(list)) {
            this.ensureDimensionMatch("origin", -1, n3, 2);
        }
        double[] dArray = new double[6];
        for (n = 0; n <= 1; ++n) {
            object = (double[])list.get(n);
            this.ensureMetadataExists("OffsetVector", n, object);
            this.ensureDimensionMatch("OffsetVector", n, ((double[])object).length, n3);
            System.arraycopy(object, 0, dArray, n * 2, 2);
            dArray[n + 4] = directPosition.getOrdinate(n);
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = this.adjustForRoundingError(dArray[n]);
        }
        AffineTransform affineTransform = new AffineTransform(dArray);
        if (iIOParam != null) {
            object = iIOParam.getSourceRegion();
            Point point = iIOParam.getDestinationOffset();
            if (point != null) {
                affineTransform.translate(-point.x, -point.y);
            }
            affineTransform.scale(iIOParam.getSourceXSubsampling(), iIOParam.getSourceYSubsampling());
            if (object != null) {
                affineTransform.translate(object.x + iIOParam.getSubsamplingXOffset(), object.y + iIOParam.getSubsamplingYOffset());
            }
        }
        return affineTransform;
    }

    private static boolean isSeparable(List<double[]> list) {
        int n = list.size();
        while (--n >= 0) {
            int n2;
            int n3;
            double[] dArray = list.get(n);
            if (dArray == null) continue;
            if (n >= 2) {
                n3 = 0;
                n2 = 2;
            } else {
                n3 = 2;
                n2 = dArray.length;
            }
            while (n3 < n2) {
                if (dArray[n3++] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public double getCellSize(AffineTransform affineTransform) throws ImageMetadataException {
        double d = affineTransform.getScaleX();
        if (d > 0.0) {
            double d2 = d * 1.0E-10;
            if (Math.abs(affineTransform.getScaleY() + d) <= d2 && Math.abs(affineTransform.getShearX()) <= d2 && Math.abs(affineTransform.getShearY()) <= d2) {
                return d;
            }
        }
        throw new ImageMetadataException(this.error(184, new Object[0]));
    }

    public Dimension2D getCellDimension(AffineTransform affineTransform) {
        double d = affineTransform.getScaleX();
        double d2 = -affineTransform.getScaleY();
        double d3 = Math.max(Math.abs(d), Math.abs(d2)) * 1.0E-10;
        if (Math.abs(affineTransform.getShearX()) <= d3 && Math.abs(affineTransform.getShearY()) <= d3) {
            return new DoubleDimension2D(d, d2);
        }
        return null;
    }

    public String formatCellDimension(RectifiedGrid rectifiedGrid, CoordinateSystem coordinateSystem) {
        UnitFormat unitFormat;
        NumberFormat numberFormat;
        int n;
        int n2;
        List list = rectifiedGrid.getOffsetVectors();
        if (list == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double[] dArray = new double[list.size()];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = this.adjustForRoundingError(MathFunctions.magnitude((double[])((double[])list.get(n2))));
            double d2 = Math.abs(dArray[n2]);
            if (!(d2 < d)) continue;
            d = d2;
        }
        n2 = 1;
        for (n = 1; n < dArray.length; ++n) {
            if (dArray[n - 1] == dArray[n]) continue;
            n2 = 0;
            break;
        }
        n = 1;
        Unit[] unitArray = null;
        if (coordinateSystem != null) {
            int n3;
            unitArray = new Unit[Math.min(dArray.length, coordinateSystem.getDimension())];
            for (n3 = 0; n3 < unitArray.length; ++n3) {
                unitArray[n3] = coordinateSystem.getAxis(n3).getUnit();
            }
            for (n3 = 1; n3 < unitArray.length; ++n3) {
                if (Utilities.equals((Object)unitArray[n3 - 1], (Object)unitArray[n3])) continue;
                n = 0;
                break;
            }
        }
        Unit unit = n != 0 && unitArray != null && unitArray.length != 0 ? unitArray[0] : null;
        StringBuffer stringBuffer = new StringBuffer(24);
        Locale locale = this.getLocale();
        FieldPosition fieldPosition = new FieldPosition(0);
        if (locale != null) {
            numberFormat = NumberFormat.getInstance(locale);
            unitFormat = UnitFormat.getInstance((Locale)locale);
        } else {
            numberFormat = NumberFormat.getInstance();
            unitFormat = UnitFormat.getInstance();
        }
        InternalUtilities.configure((NumberFormat)numberFormat, (double)d, (int)9);
        if (n2 != 0 && n != 0) {
            if (dArray.length != 0) {
                numberFormat.format(dArray[0], stringBuffer, fieldPosition);
            }
        } else {
            if (unit != null) {
                stringBuffer.append('(');
            }
            boolean bl = false;
            for (int i = 0; i < dArray.length; ++i) {
                Unit unit2;
                if (bl) {
                    stringBuffer.append(" \u00d7 ");
                }
                bl = true;
                numberFormat.format(dArray[i], stringBuffer, fieldPosition);
                if (n != 0 || unitArray == null || i >= unitArray.length || (unit2 = unitArray[i]) == null) continue;
                unitFormat.format((Object)unit2, stringBuffer.append(' '), fieldPosition);
            }
        }
        if (unit != null) {
            if (n2 == 0) {
                stringBuffer.append(')');
            }
            unitFormat.format((Object)unit, stringBuffer.append(' '), fieldPosition);
        }
        return stringBuffer.toString();
    }

    public List<GridSampleDimension> getGridSampleDimensions(List<? extends SampleDimension> list) throws ImageMetadataException {
        int n;
        if (XCollections.isNullOrEmpty(list)) {
            return null;
        }
        int n2 = 1;
        InternationalString internationalString = null;
        ArrayList<Category> arrayList = new ArrayList<Category>();
        Object[] objectArray = new GridSampleDimension[list.size()];
        boolean bl = false;
        for (n = 0; n < objectArray.length; ++n) {
            GridSampleDimension gridSampleDimension;
            Object object;
            Category category;
            NumberRange<?> numberRange;
            SampleDimension sampleDimension = list.get(n);
            if (sampleDimension == null) continue;
            InternationalString internationalString2 = sampleDimension.getDescriptor();
            if (internationalString2 == null) {
                if (internationalString == null) {
                    internationalString = Vocabulary.formatInternational((int)311);
                }
                internationalString2 = internationalString;
            } else {
                bl = true;
            }
            double[] dArray = sampleDimension.getFillSampleValues();
            if (dArray != null) {
                numberRange = Category.NODATA.getName();
                for (double d : dArray) {
                    int n3 = (int)d;
                    category = (double)n3 == d ? new Category(numberRange, null, n3) : new Category(numberRange, null, d);
                    arrayList.add(category);
                }
            }
            if ((numberRange = this.getValidSampleValues(n, sampleDimension, dArray)) != null) {
                int n4;
                object = sampleDimension.getScaleFactor();
                Double d = sampleDimension.getOffset();
                int n5 = n4 = object == null && d == null ? 1 : 0;
                if (n4 == 0 || !MetadataHelper.overlap(arrayList, numberRange)) {
                    MathTransform mathTransform;
                    block20: {
                        TransferFunctionType transferFunctionType = sampleDimension.getTransferFunctionType();
                        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
                        try {
                            mathTransform = mathTransformFactory.createAffineTransform((Matrix)new Matrix2(object != null ? this.adjustForRoundingError((Double)object) : 1.0, d != null ? this.adjustForRoundingError(d) : 0.0, 0.0, 1.0));
                            if (transferFunctionType == null || transferFunctionType.equals((Object)TransferFunctionType.LINEAR)) break block20;
                            if (transferFunctionType.equals((Object)TransferFunctionType.EXPONENTIAL)) {
                                if (this.exponential == null) {
                                    category = mathTransformFactory.getDefaultParameters("Exponential");
                                    category.parameter("base").setValue(10.0);
                                    this.exponential = mathTransformFactory.createParameterizedTransform((ParameterValueGroup)category);
                                }
                                mathTransform = mathTransformFactory.createConcatenatedTransform(mathTransform, this.exponential);
                                break block20;
                            }
                            throw new ImageMetadataException(Errors.getResources((Locale)this.getLocale()).getString(243, (Object)transferFunctionType));
                        }
                        catch (FactoryException factoryException) {
                            throw new ImageMetadataException(factoryException);
                        }
                    }
                    arrayList.add(new Category((CharSequence)internationalString2, null, numberRange, (MathTransform1D)mathTransform));
                }
                n2 &= n4;
            }
            if (arrayList.isEmpty()) {
                object = null;
            } else {
                object = arrayList.toArray(new Category[arrayList.size()]);
                bl = true;
            }
            Unit<?> unit = sampleDimension.getUnits();
            if (unit != null) {
                bl = true;
            }
            try {
                gridSampleDimension = new GridSampleDimension((CharSequence)internationalString2, (Category[])object, unit);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ImageMetadataException(illegalArgumentException);
            }
            objectArray[n] = gridSampleDimension;
            arrayList.clear();
        }
        if (bl) {
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = objectArray[n].geophysics(n2 != 0);
            }
            return UnmodifiableArrayList.wrap((Object[])objectArray);
        }
        return null;
    }

    private static boolean overlap(List<Category> list, NumberRange<?> numberRange) {
        for (Category category : list) {
            if (!numberRange.intersects((Range)category.getRange())) continue;
            return true;
        }
        return false;
    }

    public double adjustForRoundingError(double d) {
        return InternalUtilities.adjustForRoundingError((double)d, (double)360.0, (int)16);
    }
}

