/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.image.io.ImageReaderAdapter;
import org.geotoolkit.image.io.InformationType;
import org.geotoolkit.image.io.UnsupportedImageFormatException;
import org.geotoolkit.image.io.mosaic.MosaicImageReader;
import org.geotoolkit.internal.image.io.CheckedImageInputStream;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.DeferringIterator;
import org.geotoolkit.util.collection.FrequencySortedSet;
import org.geotoolkit.util.logging.Logging;

public final class XImageIO
extends Static {
    private static final int NAME = 0;
    private static final int SUFFIX = 1;
    private static final int MIME = 2;

    private XImageIO() {
    }

    static String[] getIdentifiers(ImageReaderWriterSpi imageReaderWriterSpi, int n) {
        switch (n) {
            case 0: {
                return imageReaderWriterSpi.getFormatNames();
            }
            case 1: {
                return imageReaderWriterSpi.getFileSuffixes();
            }
            case 2: {
                return imageReaderWriterSpi.getMIMETypes();
            }
        }
        throw new AssertionError(n);
    }

    private static <T extends ImageReaderWriterSpi> Iterator<T> getServiceProviders(Class<T> clazz, final int n, final String string) {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        if (string == null) {
            return XImageIO.orderForClassLoader(iIORegistry.getServiceProviders(clazz, true));
        }
        final class Filter
        extends IdentityHashMap<Object, Object>
        implements ServiceRegistry.Filter {
            Filter() {
            }

            @Override
            public boolean filter(Object object) {
                Object[] objectArray = XImageIO.getIdentifiers((ImageReaderWriterSpi)object, n);
                boolean bl = ArraysExt.contains((Object[])objectArray, (Object)string);
                if (!bl && (bl = ArraysExt.containsIgnoreCase((String[])objectArray, (String)string))) {
                    this.put(object, null);
                }
                return bl;
            }
        }
        final Filter filter = new Filter();
        return new DeferringIterator<T>(XImageIO.orderForClassLoader(iIORegistry.getServiceProviders(clazz, filter, true))){
            {
                super(iterator);
            }

            protected boolean isDeferred(T t) {
                return filter.containsKey(t);
            }
        };
    }

    private static <T extends ImageReaderWriterSpi> Iterator<T> orderForClassLoader(Iterator<T> iterator) {
        return Factories.orderForClassLoader((ClassLoader)XImageIO.class.getClassLoader(), iterator);
    }

    private static int codeAllowedType(Class<?>[] classArray, Class<?> clazz, Class<? extends ImageInputStream> clazz2) {
        int n = 0;
        if (classArray != null) {
            for (Class<Object> clazz3 : classArray) {
                if (clazz3.isAssignableFrom(clazz)) {
                    return 1;
                }
                if (!clazz3.isAssignableFrom(clazz2)) continue;
                n = 2;
            }
        }
        return n;
    }

    private static ImageReader createReaderInstance(ImageReaderSpi imageReaderSpi, Object object, Boolean bl, Boolean bl2) throws IOException {
        ImageReader imageReader = imageReaderSpi.createReaderInstance();
        if (object != null) {
            if (bl2 != null) {
                imageReader.setInput(object, bl != null && bl != false, bl2);
            } else if (bl != null) {
                imageReader.setInput(object, bl);
            } else {
                imageReader.setInput(object);
            }
        }
        return imageReader;
    }

    private static ImageReader getReader(int n, String string, Object object, Boolean bl, Boolean bl2) throws IOException {
        Object object22;
        Object object3;
        ArrayList<Object> arrayList = null;
        Iterator<ImageReaderSpi> iterator = XImageIO.getServiceProviders(ImageReaderSpi.class, n, string);
        boolean bl3 = false;
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (Boolean.TRUE.equals(bl2) && object3 instanceof ImageReaderAdapter.Spi && !(object22 = ((ImageReaderAdapter.Spi)object3).getModifiedInformation(object)).contains((Object)InformationType.RASTER) && !object22.contains((Object)InformationType.IMAGE)) continue;
            if (object == null || ((ImageReaderSpi)object3).canDecodeInput(object)) {
                return XImageIO.createReaderInstance((ImageReaderSpi)object3, object, bl, bl2);
            }
            bl3 = true;
            if (object instanceof ImageInputStream || XImageIO.codeAllowedType(((ImageReaderSpi)object3).getInputTypes(), object.getClass(), ImageInputStream.class) != 2) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(2);
            }
            arrayList.add(object3);
        }
        if (arrayList != null) {
            object3 = XImageIO.createImageInputStream(object);
            if (object3 != null) {
                for (Object object22 : arrayList) {
                    if (!((ImageReaderSpi)object22).canDecodeInput(object3)) continue;
                    return XImageIO.createReaderInstance((ImageReaderSpi)object22, object3, bl, bl2);
                }
                object3.close();
            } else {
                Object object4;
                int n2;
                if (object instanceof File) {
                    File file;
                    object22 = (File)object;
                    int n3 = 64;
                    while ((file = ((File)object22).getParentFile()) != null && !file.isDirectory()) {
                        n3 = 143;
                        object22 = file;
                    }
                    throw new FileNotFoundException(Errors.format((int)n3, (Object)object22));
                }
                if (IOUtilities.canProcessAsPath((Object)object)) {
                    n2 = 31;
                    object4 = IOUtilities.name((Object)object);
                } else {
                    n2 = 226;
                    object4 = object.getClass();
                }
                throw new IIOException(Errors.format((int)n2, (Object)object4));
            }
        }
        throw new UnsupportedImageFormatException(XImageIO.errorMessage(false, n, string, bl3));
    }

    private static String errorMessage(boolean bl, int n, String string, boolean bl2) {
        String string2;
        Object[] objectArray;
        int n2;
        if (string == null || bl2) {
            return Errors.format((int)(bl ? 159 : 158));
        }
        switch (n) {
            case 0: {
                n2 = 220;
                objectArray = bl ? ImageIO.getWriterFormatNames() : ImageIO.getReaderFormatNames();
                break;
            }
            case 1: {
                n2 = 219;
                objectArray = bl ? ImageIO.getWriterFileSuffixes() : ImageIO.getReaderFileSuffixes();
                break;
            }
            case 2: {
                n2 = 222;
                objectArray = bl ? ImageIO.getWriterMIMETypes() : ImageIO.getReaderMIMETypes();
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        objectArray = Formats.simplify((String[])objectArray);
        boolean bl3 = objectArray != null && objectArray.length != 0;
        Errors errors = Errors.getResources(null);
        if (n == 0 && bl3) {
            string2 = errors.getString(155, (Object)string, (Object)Arrays.toString(objectArray));
        } else {
            string2 = errors.getString(n2, (Object)string);
            if (bl3) {
                string2 = string2 + ' ' + errors.getString(62, (Object)Arrays.toString(objectArray));
            }
        }
        return string2;
    }

    public static ImageReader getReader(Object object, Boolean bl, Boolean bl2) throws IOException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)object);
        if (MosaicImageReader.Spi.DEFAULT.canDecodeInput(object)) {
            return XImageIO.createReaderInstance(MosaicImageReader.Spi.DEFAULT, object, bl, bl2);
        }
        return XImageIO.getReader(0, null, object, bl, bl2);
    }

    public static ImageReader getReaderBySuffix(Object object, Boolean bl, Boolean bl2) throws IOException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)object);
        if (!IOUtilities.canProcessAsPath((Object)object)) {
            return XImageIO.getReader(object, bl, bl2);
        }
        return XImageIO.getReaderBySuffix(IOUtilities.extension((Object)object), object, bl, bl2);
    }

    public static ImageReader getReaderBySuffix(String string, Object object, Boolean bl, Boolean bl2) throws IOException {
        ArgumentChecks.ensureNonNull((String)"suffix", (Object)string);
        return XImageIO.getReader(1, string, object, bl, bl2);
    }

    public static ImageReader getReaderByFormatName(String string, Object object, Boolean bl, Boolean bl2) throws IOException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        return XImageIO.getReader(0, string, object, bl, bl2);
    }

    public static ImageReader getReaderByMIMEType(String string, Object object, Boolean bl, Boolean bl2) throws IOException {
        ArgumentChecks.ensureNonNull((String)"mime", (Object)string);
        return XImageIO.getReader(2, string, object, bl, bl2);
    }

    public static void close(ImageReader imageReader) throws IOException {
        ArgumentChecks.ensureNonNull((String)"reader", (Object)imageReader);
        Object object = imageReader.getInput();
        imageReader.setInput(null);
        IOUtilities.close((Object)object);
    }

    private static ImageWriter createWriterInstance(ImageWriterSpi imageWriterSpi, Object object) throws IOException {
        ImageWriter imageWriter = imageWriterSpi.createWriterInstance();
        if (object != null) {
            imageWriter.setOutput(object);
        }
        return imageWriter;
    }

    private static ImageWriter getWriter(int n, String string, Object object, RenderedImage renderedImage) throws IOException {
        Object object2;
        Object object3 = null;
        Iterator<ImageWriterSpi> iterator = XImageIO.getServiceProviders(ImageWriterSpi.class, n, string);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl = true;
            object2 = iterator.next();
            if (renderedImage != null && !((ImageWriterSpi)object2).canEncodeImage(renderedImage)) continue;
            if (object == null) {
                return XImageIO.createWriterInstance((ImageWriterSpi)object2, object);
            }
            switch (XImageIO.codeAllowedType(((ImageWriterSpi)object2).getOutputTypes(), object.getClass(), ImageOutputStream.class)) {
                case 1: {
                    return XImageIO.createWriterInstance((ImageWriterSpi)object2, object);
                }
                case 2: {
                    if (object3 != null || object instanceof ImageOutputStream) break;
                    object3 = object2;
                }
            }
        }
        if (object3 != null && (object2 = ImageIO.createImageOutputStream(object)) != null) {
            return XImageIO.createWriterInstance(object3, object2);
        }
        throw new UnsupportedImageFormatException(XImageIO.errorMessage(true, n, string, bl));
    }

    public static ImageWriter getWriterBySuffix(Object object, RenderedImage renderedImage) throws IOException {
        ArgumentChecks.ensureNonNull((String)"output", (Object)object);
        return XImageIO.getWriterBySuffix(IOUtilities.extension((Object)object), object, renderedImage);
    }

    public static ImageWriter getWriterBySuffix(String string, Object object, RenderedImage renderedImage) throws IOException {
        ArgumentChecks.ensureNonNull((String)"suffix", (Object)string);
        return XImageIO.getWriter(1, string, object, renderedImage);
    }

    public static ImageWriter getWriterByFormatName(String string, Object object, RenderedImage renderedImage) throws IOException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        return XImageIO.getWriter(0, string, object, renderedImage);
    }

    public static ImageWriter getWriterByMIMEType(String string, Object object, RenderedImage renderedImage) throws IOException {
        ArgumentChecks.ensureNonNull((String)"mime", (Object)string);
        return XImageIO.getWriter(2, string, object, renderedImage);
    }

    public static void close(ImageWriter imageWriter) throws IOException {
        ArgumentChecks.ensureNonNull((String)"writer", (Object)imageWriter);
        Object object = imageWriter.getOutput();
        imageWriter.setOutput(null);
        IOUtilities.close((Object)object);
    }

    public static ImageReaderSpi getImageReaderSpi(ImageWriterSpi imageWriterSpi) {
        if (imageWriterSpi == null) {
            return null;
        }
        return (ImageReaderSpi)XImageIO.getSpi(imageWriterSpi.getImageReaderSpiNames(), "getImageReaderSpi");
    }

    public static ImageWriterSpi getImageWriterSpi(ImageReaderSpi imageReaderSpi) {
        if (imageReaderSpi == null) {
            return null;
        }
        return (ImageWriterSpi)XImageIO.getSpi(imageReaderSpi.getImageWriterSpiNames(), "getImageWriterSpi");
    }

    private static Object getSpi(String[] stringArray, String string) {
        if (stringArray != null) {
            IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
            for (String string2 : stringArray) {
                try {
                    Object obj = iIORegistry.getServiceProviderByClass(Class.forName(string2));
                    if (obj != null) {
                        return obj;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logging.recoverableException(XImageIO.class, (String)string, (Throwable)classNotFoundException);
                }
            }
        }
        return null;
    }

    public static ImageReaderSpi getReaderSpiByFormatName(String string) {
        ArgumentChecks.ensureNonNull((String)"format", (Object)string);
        return Formats.getReaderByFormatName(string, null);
    }

    public static ImageWriterSpi getWriterSpiByFormatName(String string) {
        ArgumentChecks.ensureNonNull((String)"format", (Object)string);
        return Formats.getWriterByFormatName(string, null);
    }

    public static String getFileSuffix(ImageReaderWriterSpi imageReaderWriterSpi) {
        String[] stringArray;
        if (imageReaderWriterSpi != null && (stringArray = imageReaderWriterSpi.getFileSuffixes()) != null) {
            for (String string : stringArray) {
                if (string == null || (string = string.trim()).isEmpty()) continue;
                if (string.charAt(0) != '.') {
                    string = '.' + string;
                }
                return string;
            }
        }
        return null;
    }

    public static String[] getFormatNamesByMimeType(String string, boolean bl, boolean bl2) {
        ArgumentChecks.ensureNonNull((String)"mime", (Object)string);
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        FrequencySortedSet frequencySortedSet = new FrequencySortedSet(true);
        if (bl != bl2) {
            XImageIO.getFormatNamesByMimeType(iIORegistry, string, bl ? ImageReaderSpi.class : ImageWriterSpi.class, (Collection<String>)frequencySortedSet);
        } else if (!bl) {
            XImageIO.getFormatNamesByMimeType(iIORegistry, string, ImageReaderSpi.class, (Collection<String>)frequencySortedSet);
            XImageIO.getFormatNamesByMimeType(iIORegistry, string, ImageWriterSpi.class, (Collection<String>)frequencySortedSet);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            XImageIO.getFormatNamesByMimeType(iIORegistry, string, ImageReaderSpi.class, arrayList);
            XImageIO.getFormatNamesByMimeType(iIORegistry, string, ImageWriterSpi.class, arrayList2);
            frequencySortedSet.addAll(arrayList);
            frequencySortedSet.addAll(arrayList2);
            frequencySortedSet.retainAll(arrayList);
            frequencySortedSet.retainAll(arrayList2);
        }
        return (String[])frequencySortedSet.toArray((Object[])new String[frequencySortedSet.size()]);
    }

    private static void getFormatNamesByMimeType(ServiceRegistry serviceRegistry, String string, Class<? extends ImageReaderWriterSpi> clazz, Collection<String> collection) {
        Iterator<? extends ImageReaderWriterSpi> iterator = serviceRegistry.getServiceProviders(clazz, false);
        while (iterator.hasNext()) {
            String[] stringArray;
            ImageReaderWriterSpi imageReaderWriterSpi = iterator.next();
            if (!ArraysExt.containsIgnoreCase((String[])imageReaderWriterSpi.getMIMETypes(), (String)string) || (stringArray = imageReaderWriterSpi.getFormatNames()) == null) continue;
            collection.addAll(Arrays.asList(stringArray));
        }
    }

    private static ImageInputStream createImageInputStream(Object object) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
        assert (CheckedImageInputStream.isValid(imageInputStream = CheckedImageInputStream.wrap(imageInputStream)));
        return imageInputStream;
    }
}

