/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.image.DataBuffer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.iterator.RectIter;
import org.geotoolkit.image.io.StreamImageWriter;
import org.geotoolkit.image.io.TextImageReader;

public abstract class TextImageWriter
extends StreamImageWriter {
    private static final int MAXIMUM_DIGITS = 12;
    private static final double NODIGITS_THRESHOLD = 1000000.0;
    private static final double DELTA_THRESHOLD = 0.1;
    private double maximum;
    private BufferedWriter writer;

    protected TextImageWriter(Spi spi) {
        super(spi);
    }

    protected Locale getDataLocale(ImageWriteParam imageWriteParam) {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).locale : null;
    }

    protected Charset getCharset(ImageWriteParam imageWriteParam) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).charset : null;
    }

    protected String getLineSeparator(ImageWriteParam imageWriteParam) {
        String string;
        if (this.originatingProvider instanceof Spi && (string = ((Spi)this.originatingProvider).lineSeparator) != null) {
            return string;
        }
        return System.getProperty("line.separator", "\n");
    }

    protected BufferedWriter getWriter(ImageWriteParam imageWriteParam) throws IllegalStateException, IOException {
        if (this.writer == null) {
            Object object = this.getOutput();
            if (object instanceof BufferedWriter) {
                this.writer = (BufferedWriter)object;
                this.closeOnReset = null;
            } else if (object instanceof Writer) {
                this.writer = new BufferedWriter((Writer)object);
                this.closeOnReset = null;
            } else {
                OutputStream outputStream = this.getOutputStream();
                Charset charset = this.getCharset(imageWriteParam);
                this.writer = new BufferedWriter(charset != null ? new OutputStreamWriter(outputStream, charset) : new OutputStreamWriter(outputStream));
                if (this.closeOnReset == outputStream) {
                    this.closeOnReset = this.writer;
                }
            }
        }
        return this.writer;
    }

    protected NumberFormat createNumberFormat(IIOImage iIOImage, ImageWriteParam imageWriteParam) {
        int n;
        Locale locale = this.getDataLocale(imageWriteParam);
        int n2 = n = iIOImage.hasRaster() ? iIOImage.getRaster().getTransferType() : iIOImage.getRenderedImage().getSampleModel().getDataType();
        if (n != 4 && n != 5) {
            this.maximum = (1 << DataBuffer.getDataTypeSize(n)) - 1;
            return locale != null ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getIntegerInstance();
        }
        int n3 = 0;
        double d = 1.0;
        this.maximum = Double.NEGATIVE_INFINITY;
        RectIter rectIter = TextImageWriter.createRectIter(iIOImage, imageWriteParam);
        if (!rectIter.finishedBands()) {
            do {
                if (!rectIter.finishedLines()) {
                    do {
                        if (!rectIter.finishedPixels()) {
                            block2: do {
                                double d2;
                                if (Double.isInfinite(d2 = Math.abs(rectIter.getSampleDouble()))) continue;
                                if (d2 > this.maximum) {
                                    this.maximum = d2;
                                }
                                while (true) {
                                    double d3 = d2 * d;
                                    if (n == 4) {
                                        d3 = (float)d3;
                                    }
                                    if (!(Math.abs(d3 - Math.rint(d3)) >= 0.1)) continue block2;
                                    if (++n3 > 12) {
                                        return TextImageWriter.createNumberFormat(locale);
                                    }
                                    d *= 10.0;
                                }
                            } while (!rectIter.nextPixelDone());
                        }
                        rectIter.startPixels();
                    } while (!rectIter.nextLineDone());
                }
                rectIter.startLines();
            } while (!rectIter.nextBandDone());
        }
        NumberFormat numberFormat = TextImageWriter.createNumberFormat(locale);
        if (n3 != 0 || this.maximum >= 0.1) {
            numberFormat.setMaximumFractionDigits(n3);
            if (this.maximum < 1000000.0) {
                numberFormat.setMinimumFractionDigits(n3);
            }
        }
        return numberFormat;
    }

    private static NumberFormat createNumberFormat(Locale locale) {
        return locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance();
    }

    protected FieldPosition getExpectedFractionPosition(NumberFormat numberFormat) {
        Object object;
        int n = (int)Math.floor(Math.log10(this.maximum)) + 1;
        int n2 = Math.max(numberFormat.getMinimumIntegerDigits(), n);
        int n3 = Math.min(numberFormat.getMaximumFractionDigits(), 12);
        if (numberFormat instanceof DecimalFormat) {
            object = (DecimalFormat)numberFormat;
            if (n3 > 0 || ((DecimalFormat)object).isDecimalSeparatorAlwaysShown()) {
                ++n2;
            }
            n2 += Math.max(((DecimalFormat)object).getNegativePrefix().length(), ((DecimalFormat)object).getPositivePrefix().length());
            n3 += Math.max(((DecimalFormat)object).getNegativeSuffix().length(), ((DecimalFormat)object).getPositiveSuffix().length());
        }
        object = new FieldPosition(1);
        ((FieldPosition)object).setBeginIndex(n2);
        ((FieldPosition)object).setEndIndex(n2 += n3);
        return object;
    }

    @Override
    protected void close() throws IOException {
        this.writer = null;
        super.close();
    }

    protected static abstract class Spi
    extends StreamImageWriter.Spi {
        private static final Class<?>[] OUTPUT_TYPES = new Class[]{File.class, URI.class, URL.class, URLConnection.class, Writer.class, OutputStream.class, ImageOutputStream.class, WritableByteChannel.class, String.class};
        protected Charset charset;
        protected Locale locale;
        protected String lineSeparator;

        protected Spi() {
            this.outputTypes = OUTPUT_TYPES;
            this.suffixes = TextImageReader.Spi.SUFFIXES;
        }
    }
}

