/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageReadParam;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.io.TextImageReader;
import org.geotoolkit.io.LineFormat;

final class TestReader
extends TextImageReader {
    private InputStream marked;
    private Set<String> keywords;
    private LineFormat parser;
    private double[][] rows;
    private int rowCount;

    public TestReader(TextImageReader.Spi spi) {
        super(spi);
    }

    @Override
    public int getWidth(int n) {
        return 0;
    }

    @Override
    public int getHeight(int n) {
        return 0;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) {
        throw new UnsupportedOperationException();
    }

    private Reader getReader(int n) throws IllegalStateException, IOException {
        Object object = this.getInput();
        if (object instanceof Reader) {
            Reader reader = (Reader)object;
            if (!reader.markSupported()) {
                return null;
            }
            reader.mark(n);
            return reader;
        }
        InputStream inputStream = this.getInputStream();
        if (this.closeOnReset == null) {
            if (!inputStream.markSupported()) {
                return null;
            }
            inputStream.mark(n);
            this.marked = inputStream;
        }
        Reader reader = this.getInputStreamReader(inputStream);
        if (this.closeOnReset == inputStream) {
            this.closeOnReset = reader;
        }
        return reader;
    }

    private void reset(Reader reader) throws IOException {
        InputStream inputStream = this.marked;
        if (inputStream != null) {
            this.marked = null;
            inputStream.reset();
        } else if (reader != null && reader != this.closeOnReset) {
            reader.reset();
        } else {
            super.close();
        }
    }

    final boolean canDecode(int n) throws IOException {
        Reader reader = this.getReader(n);
        if (reader == null) {
            return false;
        }
        char[] cArray = new char[n];
        if ((n = reader.read(cArray, 0, Math.min(n, 256))) < 0 || TestReader.containsBinary(cArray, 0, n)) {
            this.reset(reader);
            return false;
        }
        int n2 = reader.read(cArray, n, cArray.length - n);
        if (n2 >= 0) {
            if (TestReader.containsBinary(cArray, n, n + n2)) {
                this.reset(reader);
                return false;
            }
            n += n2;
        }
        n2 = 0;
        block0: while (n2 < n) {
            char c = cArray[n2];
            if (c == '\r' || c == '\n') {
                ++n2;
                continue;
            }
            int n3 = n2;
            while ((c = cArray[n3]) != '\r' && c != '\n') {
                if (++n3 < n) continue;
                break block0;
            }
            String string = new String(cArray, n2, n3 - n2);
            if (!this.isComment(string) && !this.parseLine(string)) {
                this.reset(reader);
                return false;
            }
            n2 = n3;
        }
        this.reset(reader);
        return this.isValidContent();
    }

    private static boolean containsBinary(char[] cArray, int n, int n2) {
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) >= ' ' || Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    private boolean parseLine(String string) throws IOException {
        if (this.rows == null) {
            String string2 = string.trim();
            int n = string2.length();
            if (n == 0) {
                return true;
            }
            if (Character.isJavaIdentifierStart(string2.charAt(0))) {
                Locale locale;
                int n2 = 0;
                while (++n2 < n && Character.isJavaIdentifierPart(string2.charAt(n2))) {
                }
                string2 = string2.substring(0, n2);
                if (this.keywords == null) {
                    this.keywords = new HashSet<String>();
                }
                string2 = (locale = this.getDataLocale()) != null ? string2.toUpperCase(locale) : string2.toUpperCase();
                this.keywords.add(string2);
                return true;
            }
        }
        if (this.parser == null) {
            this.parser = this.getLineFormat(0);
            this.rows = new double[16][];
        }
        try {
            if (this.parser.setLine(string) != 0) {
                if (this.rowCount == this.rows.length) {
                    this.rows = (double[][])Arrays.copyOf(this.rows, this.rows.length * 2);
                }
                this.rows[this.rowCount] = this.parser.getValues(this.rows[this.rowCount]);
                ++this.rowCount;
            }
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    private boolean isValidContent() throws IOException {
        TextImageReader.Spi spi = (TextImageReader.Spi)this.originatingProvider;
        if (this.keywords == null) {
            this.keywords = Collections.emptySet();
        }
        if (spi.isValidHeader(this.keywords)) {
            this.rows = this.rows == null ? (Object)new double[0][] : (double[][])ArraysExt.resize((Object[])this.rows, (int)this.rowCount);
            return spi.isValidContent(this.rows);
        }
        return false;
    }

    @Override
    protected void close() throws IOException {
        this.reset(null);
        this.marked = null;
        this.keywords = null;
        this.parser = null;
        this.rows = null;
        this.rowCount = 0;
        super.close();
    }
}

