/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.image.ImageDimension;
import org.geotoolkit.image.io.ImageReaderAdapter;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.image.io.SpatialImageWriteParam;
import org.geotoolkit.image.io.SubsampledRectIter;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Locales;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.logging.Logging;

public abstract class SpatialImageWriter
extends ImageWriter
implements WarningProducer,
Disposable {
    int imageIndex;
    private int thumbnailIndex;

    protected SpatialImageWriter(Spi spi) {
        super(spi);
        this.availableLocales = Locales.getAvailableLocales();
    }

    final boolean isSpatialMetadataSupported(boolean bl) {
        ImageWriterSpi imageWriterSpi = this.originatingProvider;
        return imageWriterSpi instanceof Spi && ((Spi)imageWriterSpi).isSpatialMetadataSupported(bl);
    }

    @Override
    public void setOutput(Object object) {
        this.closeSilently();
        super.setOutput(object);
    }

    final IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    @Override
    public SpatialImageWriteParam getDefaultWriteParam() {
        return new SpatialImageWriteParam(this);
    }

    @Override
    public SpatialMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        if (!this.isSpatialMetadataSupported(true)) {
            return null;
        }
        return new SpatialMetadata(true, (ImageWriter)this, null);
    }

    @Override
    public SpatialMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (!this.isSpatialMetadataSupported(false)) {
            return null;
        }
        return new SpatialMetadata(false, (ImageWriter)this, null);
    }

    @Override
    public SpatialMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            return null;
        }
        SpatialMetadataFormat spatialMetadataFormat = SpatialMetadataFormat.getStreamInstance("geotk-coverageio_3.07");
        if (iIOMetadata instanceof SpatialMetadata) {
            SpatialMetadata spatialMetadata = (SpatialMetadata)iIOMetadata;
            if (spatialMetadataFormat.equals(spatialMetadata.format)) {
                return spatialMetadata;
            }
        }
        return new SpatialMetadata((IIOMetadataFormat)spatialMetadataFormat, (ImageWriter)this, iIOMetadata);
    }

    @Override
    public SpatialMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            return null;
        }
        SpatialMetadataFormat spatialMetadataFormat = SpatialMetadataFormat.getImageInstance("geotk-coverageio_3.07");
        if (iIOMetadata instanceof SpatialMetadata) {
            SpatialMetadata spatialMetadata = (SpatialMetadata)iIOMetadata;
            if (spatialMetadataFormat.equals(spatialMetadata.format)) {
                return spatialMetadata;
            }
        }
        return new SpatialMetadata((IIOMetadataFormat)spatialMetadataFormat, (ImageWriter)this, iIOMetadata);
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    protected static SampleModel getSampleModel(IIOImage iIOImage, ImageWriteParam imageWriteParam) {
        ImageTypeSpecifier imageTypeSpecifier;
        if (imageWriteParam != null && (imageTypeSpecifier = imageWriteParam.getDestinationType()) != null) {
            return imageTypeSpecifier.getSampleModel();
        }
        if (iIOImage.hasRaster()) {
            return iIOImage.getRaster().getSampleModel();
        }
        return iIOImage.getRenderedImage().getSampleModel();
    }

    protected static RectIter createRectIter(IIOImage iIOImage, ImageWriteParam imageWriteParam) {
        RectIter rectIter;
        Object object;
        int[] nArray;
        int n;
        int n2;
        int n3;
        Rectangle rectangle;
        if (imageWriteParam != null) {
            rectangle = imageWriteParam.getSourceRegion();
            n3 = imageWriteParam.getSourceXSubsampling();
            n2 = imageWriteParam.getSourceYSubsampling();
            if (n3 != 1 || n2 != 1) {
                if (rectangle == null) {
                    rectangle = iIOImage.hasRaster() ? iIOImage.getRaster().getBounds() : ImageUtilities.getBounds((RenderedImage)iIOImage.getRenderedImage());
                }
                n = imageWriteParam.getSubsamplingXOffset();
                int n4 = imageWriteParam.getSubsamplingYOffset();
                rectangle.x += n;
                rectangle.y += n4;
                rectangle.width -= n;
                rectangle.height -= n4;
                rectangle.width -= (rectangle.width - 1) % n3;
                rectangle.height -= (rectangle.height - 1) % n2;
            }
            nArray = imageWriteParam.getSourceBands();
        } else {
            nArray = null;
            rectangle = null;
            n3 = 1;
            n2 = 1;
        }
        if (iIOImage.hasRaster()) {
            object = iIOImage.getRaster();
            n = ((Raster)object).getNumBands();
            rectIter = RectIterFactory.create((Raster)object, (Rectangle)rectangle);
        } else {
            object = iIOImage.getRenderedImage();
            n = object.getSampleModel().getNumBands();
            rectIter = RectIterFactory.create((RenderedImage)object, (Rectangle)rectangle);
        }
        if (n3 == 1 && n2 == 1) {
            if (nArray == null) {
                return rectIter;
            }
            if (nArray.length == n) {
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    if (nArray[i] == i) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return rectIter;
                }
            }
        }
        if (nArray == null) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        }
        return new SubsampledRectIter(rectIter, n3, n2, nArray);
    }

    protected static ImageDimension computeSize(IIOImage iIOImage, ImageWriteParam imageWriteParam) {
        ImageDimension imageDimension = iIOImage.hasRaster() ? new ImageDimension(iIOImage.getRaster()) : new ImageDimension(iIOImage.getRenderedImage());
        if (imageWriteParam != null) {
            int n = imageDimension.width;
            int n2 = imageDimension.height;
            Rectangle rectangle = imageWriteParam.getSourceRegion();
            if (rectangle != null) {
                if (rectangle.width < n) {
                    n = rectangle.width;
                }
                if (rectangle.height < n2) {
                    n2 = rectangle.height;
                }
            }
            int n3 = imageWriteParam.getSourceXSubsampling();
            int n4 = imageWriteParam.getSourceYSubsampling();
            n -= imageWriteParam.getSubsamplingXOffset();
            n2 -= imageWriteParam.getSubsamplingYOffset();
            n = (n + n3 - 1) / n3;
            n2 = (n2 + n4 - 1) / n4;
            imageDimension.setSize(n, n2);
        }
        return imageDimension;
    }

    protected void processImageStarted() {
        this.processImageStarted(this.imageIndex);
    }

    @Override
    protected void processImageComplete() {
        super.processImageComplete();
        this.thumbnailIndex = 0;
        ++this.imageIndex;
    }

    protected void processThumbnailStarted() {
        this.processThumbnailStarted(this.imageIndex, this.thumbnailIndex);
    }

    @Override
    protected void processThumbnailComplete() {
        super.processThumbnailComplete();
        ++this.thumbnailIndex;
    }

    protected void processWarningOccurred(String string) {
        this.processWarningOccurred(this.imageIndex, string);
    }

    protected void processWarningOccurred(String string, String string2) {
        this.processWarningOccurred(this.imageIndex, string, string2);
    }

    @Override
    public boolean warningOccurred(LogRecord logRecord) {
        if (this.warningListeners == null) {
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
            return false;
        }
        this.processWarningOccurred(Loggings.format((LogRecord)logRecord));
        return true;
    }

    final void closeSilently() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            Logging.unexpectedException((Logger)LOGGER, this.getClass(), (String)"close", (Throwable)iOException);
        }
    }

    void close() throws IOException {
        this.imageIndex = 0;
        this.thumbnailIndex = 0;
    }

    @Override
    public void dispose() {
        this.closeSilently();
        super.dispose();
    }

    protected static abstract class Spi
    extends ImageWriterSpi {
        protected Spi() {
            this.nativeStreamMetadataFormatName = "geotk-coverageio_3.07";
            this.nativeImageMetadataFormatName = "geotk-coverageio_3.07";
            if (this.getClass().getName().startsWith("org.geotoolkit.")) {
                this.vendorName = "Geotoolkit.org";
                this.version = Version.GEOTOOLKIT.toString();
            }
        }

        protected void addExtraMetadataFormat(String string, boolean bl, boolean bl2) {
            if (bl) {
                this.extraStreamMetadataFormatNames = ImageReaderAdapter.Spi.addExtraMetadataFormat(string, this.nativeStreamMetadataFormatName, this.extraStreamMetadataFormatNames);
            }
            if (bl2) {
                this.extraImageMetadataFormatNames = ImageReaderAdapter.Spi.addExtraMetadataFormat(string, this.nativeImageMetadataFormatName, this.extraImageMetadataFormatNames);
            }
        }

        final boolean isSpatialMetadataSupported(boolean bl) {
            Object[] objectArray;
            String string;
            if (bl) {
                string = this.nativeStreamMetadataFormatName;
                objectArray = this.extraStreamMetadataFormatNames;
            } else {
                string = this.nativeImageMetadataFormatName;
                objectArray = this.extraImageMetadataFormatNames;
            }
            return "geotk-coverageio_3.07".equals(string) || ArraysExt.contains((Object[])objectArray, (Object)"geotk-coverageio_3.07");
        }

        @Override
        public IIOMetadataFormat getStreamMetadataFormat(String string) {
            switch (SpatialImageReader.Spi.getMetadataFormatCode(string, this.nativeStreamMetadataFormatName, this.nativeStreamMetadataFormatClassName, this.extraStreamMetadataFormatNames, this.extraStreamMetadataFormatClassNames)) {
                case 0: {
                    return null;
                }
                case 1: {
                    return SpatialMetadataFormat.getStreamInstance(string);
                }
            }
            return super.getStreamMetadataFormat(string);
        }

        @Override
        public IIOMetadataFormat getImageMetadataFormat(String string) {
            switch (SpatialImageReader.Spi.getMetadataFormatCode(string, this.nativeImageMetadataFormatName, this.nativeImageMetadataFormatClassName, this.extraImageMetadataFormatNames, this.extraImageMetadataFormatClassNames)) {
                case 0: {
                    return null;
                }
                case 1: {
                    return SpatialMetadataFormat.getImageInstance(string);
                }
            }
            return super.getImageMetadataFormat(string);
        }
    }
}

