/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.image.io.PaletteFactory;
import org.geotoolkit.image.io.SampleConversionType;
import org.geotoolkit.image.io.SampleConverter;
import org.geotoolkit.image.io.SpatialImageReadParam;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.image.io.metadata.MetadataHelper;
import org.geotoolkit.image.io.metadata.SampleDimension;
import org.geotoolkit.image.io.metadata.SampleDomain;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Locales;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;

public abstract class SpatialImageReader
extends ImageReader
implements WarningProducer,
Disposable {
    private SpatialMetadata[] metadata;

    protected SpatialImageReader(Spi spi) {
        super(spi);
        this.availableLocales = Locales.getAvailableLocales();
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        this.closeSilently();
        super.setInput(object, bl, bl2);
    }

    final IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    protected void checkImageIndex(int n) throws IOException, IndexOutOfBoundsException {
        int n2 = this.getNumImages(false);
        int n3 = this.getMinIndex();
        if (n < n3 || n >= n2 && n2 >= 0) {
            throw new IndexOutOfBoundsException(this.indexOutOfBounds(n, n3, n2));
        }
    }

    protected void checkBandIndex(int n, int n2) throws IOException, IndexOutOfBoundsException {
        int n3 = this.getNumBands(n);
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException(this.indexOutOfBounds(n2, 0, n3));
        }
    }

    private String indexOutOfBounds(int n, int n2, int n3) {
        return this.getErrorResources().getString(246, (Object)n, n2 < n3 ? Integer.valueOf(n2) : "EOF", (Object)(n3 - 1));
    }

    @Override
    public int getNumImages(boolean bl) throws IllegalStateException, IOException {
        if (this.input != null) {
            return 1;
        }
        throw new IllegalStateException(this.getErrorResources().getString(156));
    }

    public int getNumBands(int n) throws IOException {
        this.checkImageIndex(n);
        return 1;
    }

    public int getDimension(int n) throws IOException {
        this.checkImageIndex(n);
        return 2;
    }

    public GridEnvelope getGridEnvelope(int n) throws IOException {
        int n2 = this.getDimension(n);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        switch (n2) {
            default: {
                Arrays.fill(nArray2, 1);
            }
            case 2: {
                nArray2[1] = this.getHeight(n);
            }
            case 1: {
                nArray2[0] = this.getWidth(n);
            }
            case 0: 
        }
        return new GeneralGridEnvelope(nArray, nArray2, false);
    }

    @Override
    public SpatialMetadata getStreamMetadata() throws IOException {
        return this.getSpatialMetadata(-1);
    }

    @Override
    public SpatialMetadata getImageMetadata(int n) throws IOException {
        this.checkImageIndex(n);
        return this.getSpatialMetadata(n);
    }

    private SpatialMetadata getSpatialMetadata(int n) throws IOException {
        SpatialMetadata spatialMetadata;
        int n2 = n + 1;
        if (this.metadata != null && n2 >= 0 && n2 < this.metadata.length && (spatialMetadata = this.metadata[n2]) != null) {
            return spatialMetadata != SpatialMetadata.EMPTY ? spatialMetadata : null;
        }
        if (this.isIgnoringMetadata()) {
            return null;
        }
        spatialMetadata = this.createMetadata(n);
        if (spatialMetadata != null) {
            spatialMetadata.setReadOnly(true);
        }
        if (this.metadata == null) {
            this.metadata = new SpatialMetadata[Math.max(n2 + 1, 4)];
        }
        if (n2 >= this.metadata.length) {
            this.metadata = Arrays.copyOf(this.metadata, Math.max(n2 + 1, this.metadata.length * 2));
        }
        this.metadata[n2] = spatialMetadata != null ? spatialMetadata : SpatialMetadata.EMPTY;
        return spatialMetadata;
    }

    protected SpatialMetadata createMetadata(int n) throws IOException {
        return null;
    }

    public boolean hasColors(int n) throws IOException {
        this.checkImageIndex(n);
        return false;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        Set<Object> set = imageTypeSpecifier != null ? Collections.singleton(imageTypeSpecifier) : Collections.emptySet();
        return set.iterator();
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        return this.getImageType(n, this.getDefaultReadParam(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ImageTypeSpecifier getImageType(int n, ImageReadParam imageReadParam, SampleConverter[] sampleConverterArray) throws IOException {
        long l;
        long l2;
        void var24_38;
        void var24_36;
        Object object;
        long l3;
        long l4;
        boolean bl;
        Object object2;
        int n2;
        int n3;
        String string;
        ImageTypeSpecifier imageTypeSpecifier;
        int[] nArray;
        int[] nArray2;
        if (imageReadParam != null) {
            nArray2 = imageReadParam.getSourceBands();
            nArray = imageReadParam.getDestinationBands();
            imageTypeSpecifier = imageReadParam.getDestinationType();
        } else {
            nArray2 = null;
            nArray = null;
            imageTypeSpecifier = null;
        }
        int n4 = nArray2 != null ? nArray2.length : (nArray != null ? nArray.length : this.getNumBands(n));
        Object object3 = null;
        if (imageReadParam instanceof SpatialImageReadParam) {
            SpatialImageReadParam spatialImageReadParam = (SpatialImageReadParam)imageReadParam;
            string = spatialImageReadParam.getNonNullPaletteName();
            n3 = spatialImageReadParam.getVisibleBand();
            object3 = spatialImageReadParam.getSampleDomains();
        } else {
            string = "grayscale";
            n3 = 0;
        }
        boolean bl2 = false;
        if (object3 == null) {
            SpatialMetadata spatialMetadata;
            n2 = this.ignoreMetadata;
            try {
                this.ignoreMetadata = false;
                spatialMetadata = this.getImageMetadata(n);
            }
            finally {
                this.ignoreMetadata = n2;
            }
            if (spatialMetadata != null && !XCollections.isNullOrEmpty((Collection)(object2 = spatialMetadata.getListForType(SampleDimension.class)))) {
                bl2 = nArray2 != null;
                object3 = object2;
            }
        }
        boolean bl3 = false;
        int n5 = n2 = imageTypeSpecifier != null ? imageTypeSpecifier.getSampleModel().getDataType() : this.getRawDataType(n);
        if (imageTypeSpecifier == null && imageReadParam instanceof SpatialImageReadParam) {
            object2 = (SpatialImageReadParam)imageReadParam;
            switch (n2) {
                case 2: {
                    if (((SpatialImageReadParam)object2).isSampleConversionAllowed(SampleConversionType.SHIFT_SIGNED_INTEGERS)) {
                        n2 = 1;
                    }
                }
                case 0: 
                case 1: 
                case 3: {
                    if (object3 == null || !((SpatialImageReadParam)object2).isSampleConversionAllowed(SampleConversionType.STORE_AS_FLOATS)) break;
                    boolean bl4 = false;
                    Iterator<SampleDomain> iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        SampleDomain sampleDomain = iterator.next();
                        double[] dArray = sampleDomain.getFillSampleValues();
                        if (dArray == null || dArray.length == 0) continue;
                        bl4 = true;
                        break;
                    }
                    if (!bl4) break;
                    n2 = 4;
                }
                case 4: 
                case 5: {
                    bl3 = ((SpatialImageReadParam)object2).isSampleConversionAllowed(SampleConversionType.REPLACE_FILL_VALUES);
                    break;
                }
            }
        }
        switch (n2) {
            case 4: 
            case 5: 
            case 32: {
                bl = true;
                l4 = Long.MIN_VALUE;
                l3 = Long.MAX_VALUE;
                break;
            }
            case 3: {
                bl = false;
                l4 = Integer.MIN_VALUE;
                l3 = Integer.MAX_VALUE;
                break;
            }
            case 2: {
                bl = false;
                l4 = -32768L;
                l3 = 32767L;
                break;
            }
            default: {
                bl = false;
                l4 = 0L;
                l3 = (1L << DataBuffer.getDataTypeSize(n2)) - 1L;
            }
        }
        NumberRange numberRange = null;
        NumberRange numberRange2 = null;
        SampleConverter sampleConverter = SampleConverter.IDENTITY;
        double d = 0.0;
        if (object3 != null) {
            Object var24_29 = null;
            int n6 = object3.size();
            for (int i = 0; i < n4; ++i) {
                SampleConverter sampleConverter2;
                int n7;
                double d2;
                double d3;
                NumberRange numberRange3;
                block64: {
                    int n8;
                    int n9 = n8 = bl2 ? nArray2[i] : i;
                    if (n8 < 0 || n8 >= n6) {
                        if (n6 != 1) {
                            Warnings.log((WarningProducer)this, null, SpatialImageReader.class, "getImageType", this.indexOutOfBounds(n8, 0, n6));
                        }
                        n8 = n6 - 1;
                    }
                    SampleDomain sampleDomain = (SampleDomain)object3.get(n8);
                    object = sampleDomain.getFillSampleValues();
                    if (sampleDomain instanceof SampleDimension) {
                        void var24_30;
                        if (var24_30 == null) {
                            MetadataHelper metadataHelper = new MetadataHelper((Localized)this);
                        }
                        numberRange3 = var24_30.getValidSampleValues(n8, (SampleDimension)sampleDomain, (double[])object);
                    } else {
                        numberRange3 = sampleDomain.getValidSampleValues();
                    }
                    if (numberRange3 != null) {
                        double d4;
                        d3 = numberRange3.getMinimum();
                        d2 = numberRange3.getMaximum();
                        if (!bl) {
                            if (d3 == Double.NEGATIVE_INFINITY) {
                                d3 = l4;
                            }
                            if (d2 == Double.POSITIVE_INFINITY) {
                                d2 = l3;
                            }
                        }
                        if ((d4 = d2 - d3) >= 0.0 && (bl || d4 <= (double)(l3 - l4))) {
                            numberRange = numberRange != null ? numberRange.union(numberRange3) : numberRange3;
                            break block64;
                        } else {
                            Warnings.log(this, null, SpatialImageReader.class, "getImageType", 14, numberRange3.getMinValue(), numberRange3.getMaxValue());
                            continue;
                        }
                    }
                    d3 = Double.NaN;
                    d2 = Double.NaN;
                }
                int n10 = n7 = nArray != null ? nArray[i] : i;
                if (bl) {
                    sampleConverter2 = bl3 ? SampleConverter.createPadValuesMask(object) : SampleConverter.IDENTITY;
                } else {
                    boolean bl5 = d3 <= 0.0 && d2 >= 0.0;
                    boolean bl6 = false;
                    if (object != null && ((double[])object).length != 0) {
                        double d5;
                        double[] dArray = (double[])object.clone();
                        Arrays.sort(dArray);
                        double d6 = d5 = dArray[0];
                        int n11 = dArray.length;
                        while (--n11 != 0 && Double.isNaN(d6 = dArray[n11])) {
                        }
                        assert (d5 <= d6 || Double.isNaN(d5)) : d6;
                        if (n7 == n3 && d6 > d) {
                            d = d6;
                        }
                        if (d5 < (double)l4 || d6 > (double)l3) {
                            bl6 = true;
                        } else if (d3 >= 0.0) {
                            int n12 = Arrays.binarySearch(dArray, d2);
                            n12 = n12 >= 0 ? ++n12 : (n12 ^= 0xFFFFFFFF);
                            if (n12 <= n11) {
                                double d7 = Math.max(dArray[n12] - d2 - 1.0, 0.0);
                                while (++n12 <= n11) {
                                    double d8 = dArray[n12] - dArray[n12 - 1] - 1.0;
                                    if (!(d8 > 0.0)) continue;
                                    d7 += d8;
                                }
                                int n13 = (int)Math.min(Math.round(d7), Integer.MAX_VALUE);
                                bl6 = this.collapseNoDataValues(bl5, dArray, n13);
                            }
                        }
                    }
                    sampleConverter2 = d3 < (double)l4 || d2 > (double)l3 ? SampleConverter.createOffset(Math.ceil(1.0 - d3), object) : (bl6 ? (bl5 ? SampleConverter.createOffset(Math.ceil(1.0 - d3), object) : SampleConverter.createPadValuesMask(object)) : SampleConverter.IDENTITY);
                }
                if (sampleConverterArray != null && i < sampleConverterArray.length) {
                    sampleConverterArray[i] = sampleConverter2;
                }
                if (n7 != n3) continue;
                sampleConverter = sampleConverter2;
                numberRange2 = numberRange3;
            }
        }
        if (sampleConverterArray != null) {
            void var24_33;
            int n14 = Math.min(sampleConverterArray.length, n4);
            while (--var24_33 >= 0) {
                if (sampleConverterArray[var24_33] != null) continue;
                sampleConverterArray[var24_33] = sampleConverter;
            }
        }
        if (imageTypeSpecifier != null) {
            return imageTypeSpecifier;
        }
        if (numberRange2 == null) {
            numberRange2 = numberRange != null ? numberRange : NumberRange.create((long)l4, (long)l3);
        }
        Object var24_34 = null;
        if (imageReadParam instanceof SpatialImageReadParam) {
            PaletteFactory paletteFactory = ((SpatialImageReadParam)imageReadParam).getPaletteFactory();
        }
        if (var24_36 == null) {
            PaletteFactory paletteFactory = PaletteFactory.getDefault();
        }
        var24_38.setWarningLocale(this.locale);
        double d9 = numberRange2.getMinimum();
        double d10 = numberRange2.getMaximum();
        if (bl) {
            assert (sampleConverter.getOffset() == 0.0) : sampleConverter;
            object = var24_38.getContinuousPalette(string, (float)d9, (float)d10, n2, n4, n3);
            return object.getImageTypeSpecifier();
        }
        double d11 = sampleConverter.getOffset();
        if (d9 == Double.NEGATIVE_INFINITY) {
            l2 = l4;
        } else {
            l2 = Math.round(d9 + d11);
            if (!numberRange2.isMinIncluded()) {
                ++l2;
            }
        }
        if (d10 == Double.POSITIVE_INFINITY) {
            l = l3;
        } else {
            l = Math.round(d10 + d11);
            if (numberRange2.isMaxIncluded()) {
                ++l;
            }
        }
        long l5 = Math.max(l, Math.round(d) + 1L);
        if (l2 < 0L) {
            l5 -= l2;
        }
        if (l2 >= -32768L && l2 + l5 <= (long)(l2 >= 0L ? 65536 : 32768)) {
            object = var24_38.getPalette(string, (int)l2, (int)l, (int)l5, n4, n3);
            return object.getImageTypeSpecifier();
        }
        object = var24_38.getContinuousPalette(string, (float)l2, (float)l, n2, n4, n3);
        return object.getImageTypeSpecifier();
    }

    protected int getRawDataType(int n) throws IOException {
        this.checkImageIndex(n);
        return 4;
    }

    protected boolean collapseNoDataValues(boolean bl, double[] dArray, int n) {
        return false;
    }

    protected BufferedImage getDestination(int n, ImageReadParam imageReadParam, int n2, int n3, SampleConverter[] sampleConverterArray) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getImageType(n, imageReadParam, sampleConverterArray);
        Set<ImageTypeSpecifier> set = Collections.singleton(imageTypeSpecifier);
        return SpatialImageReader.getDestination(imageReadParam, set.iterator(), n2, n3);
    }

    @Override
    public SpatialImageReadParam getDefaultReadParam() {
        return new SpatialImageReadParam(this);
    }

    @Override
    public boolean warningOccurred(LogRecord logRecord) {
        if (this.warningListeners == null) {
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
            return false;
        }
        this.processWarningOccurred(Loggings.format((LogRecord)logRecord));
        return true;
    }

    final void closeSilently() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            Logging.unexpectedException((Logger)LOGGER, this.getClass(), (String)"close", (Throwable)iOException);
        }
    }

    protected void close() throws IOException {
        this.metadata = null;
    }

    @Override
    public void dispose() {
        this.closeSilently();
        super.dispose();
    }

    protected static abstract class Spi
    extends ImageReaderSpi {
        private static final String[] GEOTK = new String[]{"geotk-coverageio_3.07"};
        private static final String[] GEOTK_ISO = new String[]{"geotk-coverageio_3.07", "ISO-19115_3.0"};

        protected Spi() {
            this.nativeStreamMetadataFormatName = "geotk-coverageio_3.07";
            this.nativeImageMetadataFormatName = "geotk-coverageio_3.07";
            if (this.getClass().getName().startsWith("org.geotoolkit.")) {
                this.vendorName = "Geotoolkit.org";
                this.version = Version.GEOTOOLKIT.toString();
            }
        }

        protected void addExtraMetadataFormat(String string, boolean bl, boolean bl2) {
            if (bl) {
                this.extraStreamMetadataFormatNames = Spi.addExtraMetadataFormat(string, this.nativeStreamMetadataFormatName, this.extraStreamMetadataFormatNames);
            }
            if (bl2) {
                this.extraImageMetadataFormatNames = Spi.addExtraMetadataFormat(string, this.nativeImageMetadataFormatName, this.extraImageMetadataFormatNames);
            }
        }

        static String[] addExtraMetadataFormat(String string, String string2, String[] stringArray) {
            ArgumentChecks.ensureNonNull((String)"formatName", (Object)string);
            if (string.equals(string2) || ArraysExt.contains((Object[])stringArray, (Object)string)) {
                return stringArray;
            }
            if (stringArray == null || stringArray.length == 0) {
                String[] stringArray2;
                if (string.equals("geotk-coverageio_3.07")) {
                    stringArray2 = GEOTK;
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = string;
                }
                return stringArray2;
            }
            if ("geotk-coverageio_3.07".equals(stringArray[0]) && string.equals("ISO-19115_3.0")) {
                return GEOTK_ISO;
            }
            return (String[])ArraysExt.append((Object[])stringArray, (Object)string);
        }

        static int getMetadataFormatCode(String string, String string2, String string3, String[] stringArray, String[] stringArray2) {
            ArgumentChecks.ensureNonNull((String)"formatName", (Object)string);
            if (string.equals(string2)) {
                return Spi.isSpatialFormat(string) ? 1 : (string3 != null ? 2 : 0);
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    return Spi.isSpatialFormat(string) ? 1 : (stringArray2 != null && stringArray2[i] != null ? 2 : 0);
                }
            }
            return 3;
        }

        private static boolean isSpatialFormat(String string) {
            return string.equals("geotk-coverageio_3.07") || string.equals("ISO-19115_3.0");
        }

        @Override
        public IIOMetadataFormat getStreamMetadataFormat(String string) {
            switch (Spi.getMetadataFormatCode(string, this.nativeStreamMetadataFormatName, this.nativeStreamMetadataFormatClassName, this.extraStreamMetadataFormatNames, this.extraStreamMetadataFormatClassNames)) {
                case 0: {
                    return null;
                }
                case 1: {
                    return SpatialMetadataFormat.getStreamInstance(string);
                }
            }
            return super.getStreamMetadataFormat(string);
        }

        @Override
        public IIOMetadataFormat getImageMetadataFormat(String string) {
            switch (Spi.getMetadataFormatCode(string, this.nativeImageMetadataFormatName, this.nativeImageMetadataFormatClassName, this.extraImageMetadataFormatNames, this.extraImageMetadataFormatClassNames)) {
                case 0: {
                    return null;
                }
                case 1: {
                    return SpatialMetadataFormat.getImageInstance(string);
                }
            }
            return super.getImageMetadataFormat(string);
        }
    }
}

