/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.LogRecord;
import javax.imageio.IIOParam;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.image.io.DimensionIdentification;
import org.geotoolkit.image.io.DimensionSet;
import org.geotoolkit.image.io.DimensionSlice;
import org.geotoolkit.image.io.PaletteFactory;
import org.geotoolkit.image.io.SampleConversionType;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.image.io.metadata.SampleDomain;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;

public class SpatialImageReadParam
extends ImageReadParam
implements WarningProducer {
    public static final String DEFAULT_PALETTE_NAME = "grayscale";
    private DimensionSet dimensionSlices;
    private String paletteName;
    private PaletteFactory paletteFactory;
    private int visibleBand;
    private List<SampleDomain> sampleDomains;
    private Set<SampleConversionType> allowedConversions;
    protected final ImageReader reader;

    public SpatialImageReadParam(ImageReader imageReader) {
        this.reader = imageReader;
    }

    private IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    public boolean hasDimensionSlices() {
        return this.dimensionSlices != null && !this.dimensionSlices.isEmpty();
    }

    public DimensionSlice newDimensionSlice() {
        if (this.dimensionSlices == null) {
            this.dimensionSlices = new DimensionSet(this);
        }
        return new DimensionSlice(this.dimensionSlices);
    }

    public Set<DimensionSlice> getDimensionSlices() {
        if (this.dimensionSlices == null) {
            this.dimensionSlices = new DimensionSet(this);
        }
        return this.dimensionSlices;
    }

    public DimensionSlice getDimensionSlice(Object ... objectArray) {
        return this.dimensionSlices != null ? (DimensionSlice)this.dimensionSlices.getDimensionSlice(SpatialImageReadParam.class, objectArray) : null;
    }

    public int getSliceIndex(Object ... objectArray) {
        return this.dimensionSlices != null ? this.dimensionSlices.getSliceIndex(SpatialImageReadParam.class, objectArray) : 0;
    }

    private void ensureValidBand(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(this.getErrorResources().getString(5, (Object)n));
        }
    }

    public int getVisibleBand() {
        return this.visibleBand;
    }

    public void setVisibleBand(int n) throws IllegalArgumentException {
        this.ensureValidBand(n);
        this.visibleBand = n;
    }

    final String getNonNullPaletteName() {
        String string = this.getPaletteName();
        return string != null ? string : DEFAULT_PALETTE_NAME;
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public void setPaletteName(String string) {
        this.paletteName = string;
    }

    public PaletteFactory getPaletteFactory() {
        return this.paletteFactory;
    }

    public void setPaletteFactory(PaletteFactory paletteFactory) {
        this.paletteFactory = paletteFactory;
    }

    public List<SampleDomain> getSampleDomains() {
        return this.sampleDomains;
    }

    public void setSampleDomains(List<SampleDomain> unmodifiableArrayList) {
        if (unmodifiableArrayList != null && !(unmodifiableArrayList instanceof UnmodifiableArrayList)) {
            unmodifiableArrayList = UnmodifiableArrayList.wrap((Object[])unmodifiableArrayList.toArray(new SampleDomain[unmodifiableArrayList.size()]));
        }
        this.sampleDomains = unmodifiableArrayList;
    }

    public boolean isSampleConversionAllowed(SampleConversionType sampleConversionType) {
        return this.allowedConversions != null && this.allowedConversions.contains((Object)sampleConversionType);
    }

    public void setSampleConversionAllowed(SampleConversionType sampleConversionType, boolean bl) {
        if (bl) {
            if (this.allowedConversions == null) {
                this.allowedConversions = EnumSet.noneOf(SampleConversionType.class);
            }
            this.allowedConversions.add(sampleConversionType);
        } else if (this.allowedConversions != null) {
            this.allowedConversions.remove((Object)sampleConversionType);
        }
    }

    public Locale getLocale() {
        return this.reader != null ? this.reader.getLocale() : null;
    }

    @Override
    public boolean warningOccurred(LogRecord logRecord) {
        return Warnings.log(this.reader, logRecord);
    }

    static StringBuilder toStringBegining(IIOParam iIOParam) {
        Rectangle rectangle = iIOParam.getSourceRegion();
        Point point = iIOParam.getDestinationOffset();
        int n = iIOParam.getSourceXSubsampling();
        int n2 = iIOParam.getSourceYSubsampling();
        int[] nArray = iIOParam.getSourceBands();
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)iIOParam));
        stringBuilder.append('[');
        if (rectangle != null) {
            stringBuilder.append("sourceRegion=(").append(rectangle.x).append(',').append(rectangle.y).append(" : ").append(rectangle.width).append(',').append(rectangle.height).append("), ");
        }
        if (n != 1 || n2 != 1) {
            stringBuilder.append("sourceSubsampling=(").append(n).append(',').append(n2).append("), ");
        }
        if (nArray != null) {
            stringBuilder.append("sourceBands={");
            for (int i = 0; i < nArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(nArray[i]);
            }
            stringBuilder.append("}, ");
        }
        if (point != null && (point.x != 0 || point.y != 0)) {
            stringBuilder.append("destinationOffset=(").append(point.x).append(',').append(point.y).append("), ");
        }
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = SpatialImageReadParam.toStringBegining(this);
        if (this.paletteName != null) {
            stringBuilder.append("palette=\"").append(this.paletteName).append('\"');
        }
        return SpatialImageReadParam.toStringEnd(stringBuilder, this.dimensionSlices);
    }

    static String toStringEnd(StringBuilder stringBuilder, Set<DimensionIdentification> set) {
        int n = stringBuilder.length();
        if (stringBuilder.charAt(n - 1) == ' ') {
            stringBuilder.setLength(n - 2);
        }
        stringBuilder.append(']');
        if (!XCollections.isNullOrEmpty(set)) {
            int n2 = 0;
            for (DimensionIdentification dimensionIdentification : set) {
                n2 = stringBuilder.append("\n\u00a0\u00a0\u251c\u2500\u00a0").length();
                stringBuilder.append(dimensionIdentification);
            }
            if (n2 != 0) {
                stringBuilder.append('\n').setCharAt(n2 - 3, '\u2514');
            }
        }
        return stringBuilder.toString();
    }
}

