/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.image.io.ImageReaderAdapter;
import org.geotoolkit.image.io.ImageWriteParamAdapter;
import org.geotoolkit.image.io.InformationType;
import org.geotoolkit.image.io.InvalidImageStoreException;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.image.io.SpatialImageWriteParam;
import org.geotoolkit.image.io.SpatialImageWriter;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.util.converter.Classes;

public abstract class ImageWriterAdapter
extends SpatialImageWriter {
    protected final ImageWriter main;
    private final Class<?>[] outputTypes;
    private final boolean acceptStream;

    protected ImageWriterAdapter(Spi spi) throws IOException {
        this(spi, spi.main.createWriterInstance());
    }

    protected ImageWriterAdapter(Spi spi, ImageWriter imageWriter) {
        super(spi);
        this.main = imageWriter;
        ArgumentChecks.ensureNonNull((String)"main", (Object)imageWriter);
        if (spi != null) {
            this.outputTypes = spi.getMainTypes();
            this.acceptStream = spi.acceptStream;
        } else {
            this.outputTypes = null;
            this.acceptStream = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object createOutput(String string) throws IllegalStateException, IOException {
        void var3_7;
        Object object;
        ImageOutputStream imageOutputStream;
        Object object2 = this.output;
        if (object2 == null) {
            throw new IllegalStateException(this.getErrorResources().getString(157));
        }
        if (!"main".equalsIgnoreCase(string)) {
            return null;
        }
        if (this.outputTypes != null) {
            for (Class<?> clazz : this.outputTypes) {
                if (!clazz.isInstance(object2)) continue;
                return object2;
            }
        }
        Object var3_4 = null;
        if (this.acceptStream && (imageOutputStream = ImageIO.createImageOutputStream(object2)) == null && (object = IOUtilities.tryToFile((Object)object2)) != object2) {
            ImageOutputStream imageOutputStream2 = ImageIO.createImageOutputStream(object);
        }
        return var3_7;
    }

    protected void initialize() throws IOException {
    }

    private void ensureOutputInitialized() throws IOException {
        if (this.main.getOutput() == null) {
            Object object = this.createOutput("main");
            if (object == null) {
                throw new InvalidImageStoreException(this.getErrorResources(), this.output, this.outputTypes, true);
            }
            this.main.setOutput(object);
            this.initialize();
        }
    }

    @Override
    public SpatialImageWriteParam getDefaultWriteParam() {
        ImageWriteParam imageWriteParam = this.main.getDefaultWriteParam();
        if (imageWriteParam instanceof SpatialImageWriteParam) {
            return (SpatialImageWriteParam)imageWriteParam;
        }
        return new ImageWriteParamAdapter(this, this.main.getDefaultWriteParam());
    }

    private static ImageWriteParam unwrap(ImageWriteParam imageWriteParam) {
        if (imageWriteParam instanceof ImageWriteParamAdapter) {
            imageWriteParam = ((ImageWriteParamAdapter)imageWriteParam).param;
        }
        return imageWriteParam;
    }

    @Override
    public SpatialMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        IIOMetadata iIOMetadata = this.main.getDefaultStreamMetadata(ImageWriterAdapter.unwrap(imageWriteParam));
        if (iIOMetadata == null && !this.isSpatialMetadataSupported(true)) {
            return null;
        }
        return new SpatialMetadata(true, (ImageWriter)this, iIOMetadata);
    }

    @Override
    public SpatialMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        IIOMetadata iIOMetadata = this.main.getDefaultImageMetadata(imageTypeSpecifier, ImageWriterAdapter.unwrap(imageWriteParam));
        if (iIOMetadata == null && !this.isSpatialMetadataSupported(false)) {
            return null;
        }
        return new SpatialMetadata(false, (ImageWriter)this, iIOMetadata);
    }

    protected void writeStreamMetadata(IIOMetadata iIOMetadata) throws IOException {
    }

    protected void writeImageMetadata(IIOMetadata iIOMetadata, int n, ImageWriteParam imageWriteParam) throws IOException {
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.ensureOutputInitialized();
        this.writeStreamMetadata(iIOMetadata);
        this.writeImageMetadata(iIOImage.getMetadata(), 0, imageWriteParam);
        this.main.write(iIOMetadata, iIOImage, ImageWriterAdapter.unwrap(imageWriteParam));
    }

    @Override
    public boolean canWriteRasters() {
        return this.main.canWriteRasters();
    }

    @Override
    public boolean canWriteSequence() {
        return this.main.canWriteSequence();
    }

    @Override
    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.ensureOutputInitialized();
        this.writeStreamMetadata(iIOMetadata);
        this.main.prepareWriteSequence(iIOMetadata);
    }

    @Override
    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.writeImageMetadata(iIOImage.getMetadata(), this.imageIndex, imageWriteParam);
        this.main.writeToSequence(iIOImage, ImageWriterAdapter.unwrap(imageWriteParam));
        ++this.imageIndex;
    }

    @Override
    public void endWriteSequence() throws IOException {
        this.main.endWriteSequence();
    }

    @Override
    public boolean canReplacePixels(int n) throws IOException {
        this.ensureOutputInitialized();
        return this.main.canReplacePixels(n);
    }

    @Override
    public void prepareReplacePixels(int n, Rectangle rectangle) throws IOException {
        this.ensureOutputInitialized();
        this.main.prepareReplacePixels(n, rectangle);
    }

    @Override
    public void replacePixels(RenderedImage renderedImage, ImageWriteParam imageWriteParam) throws IOException {
        this.main.replacePixels(renderedImage, ImageWriterAdapter.unwrap(imageWriteParam));
    }

    @Override
    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        this.main.replacePixels(raster, ImageWriterAdapter.unwrap(imageWriteParam));
    }

    @Override
    public void endReplacePixels() throws IOException {
        this.main.endReplacePixels();
    }

    @Override
    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.main.getNumThumbnailsSupported(imageTypeSpecifier, ImageWriterAdapter.unwrap(imageWriteParam), iIOMetadata, iIOMetadata2);
    }

    @Override
    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.main.getPreferredThumbnailSizes(imageTypeSpecifier, ImageWriterAdapter.unwrap(imageWriteParam), iIOMetadata, iIOMetadata2);
    }

    @Override
    public Locale[] getAvailableLocales() {
        return this.main.getAvailableLocales();
    }

    @Override
    public Locale getLocale() {
        return this.main.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.main.setLocale(locale);
        this.locale = locale;
    }

    @Override
    public void addIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        super.addIIOWriteWarningListener(iIOWriteWarningListener);
        this.main.addIIOWriteWarningListener(iIOWriteWarningListener);
    }

    @Override
    public void removeIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        super.removeIIOWriteWarningListener(iIOWriteWarningListener);
        this.main.removeIIOWriteWarningListener(iIOWriteWarningListener);
    }

    @Override
    public void removeAllIIOWriteWarningListeners() {
        super.removeAllIIOWriteWarningListeners();
        this.main.removeAllIIOWriteWarningListeners();
    }

    @Override
    public void addIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        this.main.addIIOWriteProgressListener(iIOWriteProgressListener);
    }

    @Override
    public void removeIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        super.removeIIOWriteProgressListener(iIOWriteProgressListener);
        this.main.removeIIOWriteProgressListener(iIOWriteProgressListener);
    }

    @Override
    public void removeAllIIOWriteProgressListeners() {
        super.removeAllIIOWriteProgressListeners();
        this.main.removeAllIIOWriteProgressListeners();
    }

    @Override
    public void abort() {
        super.abort();
        this.main.abort();
    }

    @Override
    public void reset() {
        super.reset();
        this.main.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.main.dispose();
    }

    @Override
    protected void close() throws IOException {
        super.close();
        Object object = this.main.getOutput();
        this.main.setOutput(null);
        if (object != null && object != this.output) {
            IOUtilities.close((Object)object);
        }
    }

    protected void finalize() throws Throwable {
        this.closeSilently();
        super.finalize();
    }

    public static abstract class Spi
    extends SpatialImageWriter.Spi {
        private static final Class<?>[] TYPES = ImageReaderAdapter.Spi.TYPES;
        protected final ImageWriterSpi main;
        final boolean acceptStream;

        protected Spi(ImageWriterSpi imageWriterSpi) {
            ArgumentChecks.ensureNonNull((String)"main", (Object)imageWriterSpi);
            this.main = imageWriterSpi;
            this.names = imageWriterSpi.getFormatNames();
            this.suffixes = imageWriterSpi.getFileSuffixes();
            this.MIMETypes = imageWriterSpi.getMIMETypes();
            this.outputTypes = TYPES;
            this.supportsStandardStreamMetadataFormat = imageWriterSpi.isStandardStreamMetadataFormatSupported();
            this.supportsStandardImageMetadataFormat = imageWriterSpi.isStandardImageMetadataFormatSupported();
            this.nativeStreamMetadataFormatName = imageWriterSpi.getNativeStreamMetadataFormatName();
            this.nativeImageMetadataFormatName = imageWriterSpi.getNativeImageMetadataFormatName();
            this.extraStreamMetadataFormatNames = imageWriterSpi.getExtraStreamMetadataFormatNames();
            this.extraImageMetadataFormatNames = imageWriterSpi.getExtraImageMetadataFormatNames();
            this.acceptStream = Classes.isAssignableTo(ImageOutputStream.class, (Class[])imageWriterSpi.getOutputTypes());
        }

        protected Spi(String string) {
            this(Formats.getWriterByFormatName(string, Spi.class));
        }

        protected void addFormatNameSuffix(String string) {
            ImageReaderAdapter.Spi.addFormatNameSuffix(this.names, this.MIMETypes, string);
        }

        final Class<?>[] getMainTypes() {
            return ImageReaderAdapter.Spi.getMainTypes(this.outputTypes, this.main.getOutputTypes());
        }

        @Override
        public IIOMetadataFormat getStreamMetadataFormat(String string) {
            switch (SpatialImageReader.Spi.getMetadataFormatCode(string, this.nativeStreamMetadataFormatName, this.nativeStreamMetadataFormatClassName, this.extraStreamMetadataFormatNames, this.extraStreamMetadataFormatClassNames)) {
                case 1: {
                    return SpatialMetadataFormat.getStreamInstance(string);
                }
                case 2: {
                    return super.getStreamMetadataFormat(string);
                }
            }
            return this.main.getStreamMetadataFormat(string);
        }

        @Override
        public IIOMetadataFormat getImageMetadataFormat(String string) {
            switch (SpatialImageReader.Spi.getMetadataFormatCode(string, this.nativeImageMetadataFormatName, this.nativeImageMetadataFormatClassName, this.extraImageMetadataFormatNames, this.extraImageMetadataFormatClassNames)) {
                case 1: {
                    return SpatialMetadataFormat.getImageInstance(string);
                }
                case 2: {
                    return super.getImageMetadataFormat(string);
                }
            }
            return this.main.getImageMetadataFormat(string);
        }

        @Override
        public boolean isFormatLossless() {
            return this.main.isFormatLossless();
        }

        @Override
        public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
            return this.main.canEncodeImage(imageTypeSpecifier);
        }

        @Override
        public boolean canEncodeImage(RenderedImage renderedImage) {
            return this.main.canEncodeImage(renderedImage);
        }

        public Set<InformationType> getModifiedInformation(ImageTypeSpecifier imageTypeSpecifier) {
            return ImageReaderAdapter.Spi.INFO;
        }

        @Override
        public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
            serviceRegistry.setOrdering(clazz, this.main, this);
        }

        public static ImageWriterSpi unwrap(ImageWriterSpi imageWriterSpi) {
            while (imageWriterSpi instanceof Spi) {
                imageWriterSpi = ((Spi)imageWriterSpi).main;
            }
            return imageWriterSpi;
        }
    }
}

