/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.io.ImageReadParamAdapter;
import org.geotoolkit.image.io.InformationType;
import org.geotoolkit.image.io.InvalidImageStoreException;
import org.geotoolkit.image.io.SpatialImageReadParam;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.metadata.SpatialMetadataFormat;
import org.geotoolkit.internal.image.io.CheckedImageInputStream;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.util.Strings;
import org.opengis.coverage.grid.GridEnvelope;

public abstract class ImageReaderAdapter
extends SpatialImageReader {
    protected final ImageReader main;
    private final Class<?>[] inputTypes;
    private final boolean acceptStream;

    protected ImageReaderAdapter(Spi spi) throws IOException {
        this(spi, spi.main.createReaderInstance());
    }

    protected ImageReaderAdapter(Spi spi, ImageReader imageReader) {
        super(spi);
        this.main = imageReader;
        ArgumentChecks.ensureNonNull((String)"main", (Object)imageReader);
        if (spi != null) {
            this.inputTypes = spi.getMainTypes();
            this.acceptStream = spi.acceptStream;
        } else {
            this.inputTypes = null;
            this.acceptStream = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object createInput(String string) throws IllegalStateException, IOException {
        void var3_9;
        void var3_7;
        ImageInputStream imageInputStream;
        Object object;
        ImageInputStream imageInputStream2;
        Object object2 = this.input;
        if (object2 == null) {
            throw new IllegalStateException(this.getErrorResources().getString(156));
        }
        if (!"main".equalsIgnoreCase(string)) {
            return null;
        }
        if (this.inputTypes != null) {
            for (Class<?> clazz : this.inputTypes) {
                if (!clazz.isInstance(object2)) continue;
                return object2;
            }
        }
        Object var3_4 = null;
        if (this.acceptStream && (imageInputStream2 = ImageIO.createImageInputStream(object2)) == null && (object = IOUtilities.tryToFile((Object)object2)) != object2) {
            ImageInputStream imageInputStream3 = ImageIO.createImageInputStream(object);
        }
        assert (CheckedImageInputStream.isValid(imageInputStream = CheckedImageInputStream.wrap((ImageInputStream)var3_7)));
        return var3_9;
    }

    protected void initialize() throws IOException {
    }

    private void ensureInitialized() throws IOException {
        if (this.main.getInput() == null) {
            Object object = this.createInput("main");
            if (object == null) {
                throw new InvalidImageStoreException(this.getErrorResources(), this.input, this.inputTypes, false);
            }
            this.main.setInput(object, this.seekForwardOnly, this.ignoreMetadata);
            this.initialize();
        }
        this.sync();
    }

    private void sync() {
        this.minIndex = this.main.getMinIndex();
    }

    @Override
    public int getNumImages(boolean bl) throws IllegalStateException, IOException {
        this.ensureInitialized();
        int n = this.main.getNumImages(bl);
        this.sync();
        return n;
    }

    @Override
    public int getNumThumbnails(int n) throws IllegalStateException, IOException {
        this.checkImageIndex(n);
        int n2 = this.main.getNumThumbnails(n);
        this.sync();
        return n2;
    }

    @Override
    public int getNumBands(int n) throws IOException {
        this.checkImageIndex(n);
        int n2 = this.main instanceof SpatialImageReader ? ((SpatialImageReader)this.main).getNumBands(n) : this.main.getRawImageType(n).getNumBands();
        this.sync();
        return n2;
    }

    @Override
    public int getDimension(int n) throws IOException {
        int n2;
        if (this.main instanceof SpatialImageReader) {
            this.checkImageIndex(n);
            n2 = ((SpatialImageReader)this.main).getDimension(n);
        } else {
            n2 = super.getDimension(n);
        }
        this.sync();
        return n2;
    }

    @Override
    public GridEnvelope getGridEnvelope(int n) throws IOException {
        GridEnvelope gridEnvelope;
        if (this.main instanceof SpatialImageReader) {
            this.checkImageIndex(n);
            gridEnvelope = ((SpatialImageReader)this.main).getGridEnvelope(n);
        } else {
            gridEnvelope = super.getGridEnvelope(n);
        }
        this.sync();
        return gridEnvelope;
    }

    @Override
    public float getAspectRatio(int n) throws IOException {
        this.checkImageIndex(n);
        float f = this.main.getAspectRatio(n);
        this.sync();
        return f;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkImageIndex(n);
        int n2 = this.main.getWidth(n);
        this.sync();
        return n2;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkImageIndex(n);
        int n2 = this.main.getHeight(n);
        this.sync();
        return n2;
    }

    @Override
    public int getTileWidth(int n) throws IOException {
        this.checkImageIndex(n);
        int n2 = this.main.getTileWidth(n);
        this.sync();
        return n2;
    }

    @Override
    public int getTileHeight(int n) throws IOException {
        this.checkImageIndex(n);
        int n2 = this.main.getTileHeight(n);
        this.sync();
        return n2;
    }

    @Override
    public int getTileGridXOffset(int n) throws IOException {
        this.checkImageIndex(n);
        int n2 = this.main.getTileGridXOffset(n);
        this.sync();
        return n2;
    }

    @Override
    public int getTileGridYOffset(int n) throws IOException {
        this.checkImageIndex(n);
        int n2 = this.main.getTileGridYOffset(n);
        this.sync();
        return n2;
    }

    @Override
    public int getThumbnailWidth(int n, int n2) throws IOException {
        this.checkImageIndex(n);
        int n3 = this.main.getThumbnailWidth(n, n2);
        this.sync();
        return n3;
    }

    @Override
    public int getThumbnailHeight(int n, int n2) throws IOException {
        this.checkImageIndex(n);
        int n3 = this.main.getThumbnailHeight(n, n2);
        this.sync();
        return n3;
    }

    @Override
    public boolean hasThumbnails(int n) throws IOException {
        this.checkImageIndex(n);
        boolean bl = this.main.hasThumbnails(n);
        this.sync();
        return bl;
    }

    @Override
    public boolean isImageTiled(int n) throws IOException {
        this.checkImageIndex(n);
        boolean bl = this.main.isImageTiled(n);
        this.sync();
        return bl;
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        this.checkImageIndex(n);
        boolean bl = this.main.isRandomAccessEasy(n);
        this.sync();
        return bl;
    }

    @Override
    public SpatialMetadata getStreamMetadata() throws IOException {
        this.ensureInitialized();
        SpatialMetadata spatialMetadata = super.getStreamMetadata();
        this.sync();
        return spatialMetadata;
    }

    @Override
    public SpatialMetadata getImageMetadata(int n) throws IOException {
        SpatialMetadata spatialMetadata = super.getImageMetadata(n);
        this.sync();
        return spatialMetadata;
    }

    @Override
    protected SpatialMetadata createMetadata(int n) throws IOException {
        if (n >= 0) {
            IIOMetadata iIOMetadata = this.main.getImageMetadata(n);
            if (iIOMetadata != null) {
                if (iIOMetadata instanceof SpatialMetadata) {
                    SpatialMetadata spatialMetadata = (SpatialMetadata)iIOMetadata;
                    spatialMetadata.setReadOnly(false);
                    return spatialMetadata;
                }
                return new SpatialMetadata(false, (ImageReader)this, iIOMetadata);
            }
        } else {
            IIOMetadata iIOMetadata = this.main.getStreamMetadata();
            if (iIOMetadata != null) {
                if (iIOMetadata instanceof SpatialMetadata) {
                    SpatialMetadata spatialMetadata = (SpatialMetadata)iIOMetadata;
                    spatialMetadata.setReadOnly(false);
                    return spatialMetadata;
                }
                return new SpatialMetadata(true, (ImageReader)this, iIOMetadata);
            }
        }
        return null;
    }

    @Override
    public boolean hasColors(int n) throws IOException {
        this.checkImageIndex(n);
        if (this.main instanceof SpatialImageReader) {
            return ((SpatialImageReader)this.main).hasColors(n);
        }
        return true;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.checkImageIndex(n);
        Iterator<ImageTypeSpecifier> iterator = this.main.getImageTypes(n);
        this.sync();
        return iterator;
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.checkImageIndex(n);
        ImageTypeSpecifier imageTypeSpecifier = this.main.getRawImageType(n);
        this.sync();
        return imageTypeSpecifier;
    }

    @Override
    public SpatialImageReadParam getDefaultReadParam() {
        ImageReadParam imageReadParam = this.main.getDefaultReadParam();
        if (imageReadParam instanceof SpatialImageReadParam) {
            return (SpatialImageReadParam)imageReadParam;
        }
        return new ImageReadParamAdapter(this, imageReadParam);
    }

    private static ImageReadParam unwrap(ImageReadParam imageReadParam) {
        if (imageReadParam instanceof ImageReadParamAdapter) {
            imageReadParam = ((ImageReadParamAdapter)imageReadParam).param;
        }
        return imageReadParam;
    }

    @Override
    public BufferedImage read(int n) throws IOException {
        this.checkImageIndex(n);
        BufferedImage bufferedImage = this.main.read(n);
        this.sync();
        return bufferedImage;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkImageIndex(n);
        BufferedImage bufferedImage = this.main.read(n, ImageReaderAdapter.unwrap(imageReadParam));
        this.sync();
        return bufferedImage;
    }

    @Override
    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkImageIndex(n);
        RenderedImage renderedImage = this.main.readAsRenderedImage(n, ImageReaderAdapter.unwrap(imageReadParam));
        this.sync();
        return renderedImage;
    }

    @Override
    public BufferedImage readTile(int n, int n2, int n3) throws IOException {
        this.checkImageIndex(n);
        BufferedImage bufferedImage = this.main.readTile(n, n2, n3);
        this.sync();
        return bufferedImage;
    }

    @Override
    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkImageIndex(n);
        Raster raster = this.main.readRaster(n, ImageReaderAdapter.unwrap(imageReadParam));
        this.sync();
        return raster;
    }

    @Override
    public Raster readTileRaster(int n, int n2, int n3) throws IOException {
        this.checkImageIndex(n);
        Raster raster = this.main.readTileRaster(n, n2, n3);
        this.sync();
        return raster;
    }

    @Override
    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        this.checkImageIndex(n);
        BufferedImage bufferedImage = this.main.readThumbnail(n, n2);
        this.sync();
        return bufferedImage;
    }

    @Override
    public boolean readerSupportsThumbnails() {
        return this.main.readerSupportsThumbnails();
    }

    @Override
    public boolean canReadRaster() {
        return this.main.canReadRaster();
    }

    @Override
    public Locale[] getAvailableLocales() {
        return this.main.getAvailableLocales();
    }

    @Override
    public Locale getLocale() {
        return this.main.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.main.setLocale(locale);
        this.locale = locale;
    }

    @Override
    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        super.addIIOReadWarningListener(iIOReadWarningListener);
        this.main.addIIOReadWarningListener(iIOReadWarningListener);
    }

    @Override
    public void removeIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        super.removeIIOReadWarningListener(iIOReadWarningListener);
        this.main.removeIIOReadWarningListener(iIOReadWarningListener);
    }

    @Override
    public void removeAllIIOReadWarningListeners() {
        super.removeAllIIOReadWarningListeners();
        this.main.removeAllIIOReadWarningListeners();
    }

    @Override
    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.main.addIIOReadProgressListener(iIOReadProgressListener);
    }

    @Override
    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        super.removeIIOReadProgressListener(iIOReadProgressListener);
        this.main.removeIIOReadProgressListener(iIOReadProgressListener);
    }

    @Override
    public void removeAllIIOReadProgressListeners() {
        super.removeAllIIOReadProgressListeners();
        this.main.removeAllIIOReadProgressListeners();
    }

    @Override
    public void addIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        this.main.addIIOReadUpdateListener(iIOReadUpdateListener);
    }

    @Override
    public void removeIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        super.removeIIOReadUpdateListener(iIOReadUpdateListener);
        this.main.removeIIOReadUpdateListener(iIOReadUpdateListener);
    }

    @Override
    public void removeAllIIOReadUpdateListeners() {
        super.removeAllIIOReadUpdateListeners();
        this.main.removeAllIIOReadUpdateListeners();
    }

    @Override
    public void abort() {
        super.abort();
        this.main.abort();
    }

    @Override
    public void reset() {
        super.reset();
        this.main.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.main.dispose();
    }

    @Override
    protected void close() throws IOException {
        super.close();
        Object object = this.main.getInput();
        this.main.setInput(null);
        if (object != null && object != this.input) {
            IOUtilities.close((Object)object);
        }
        this.sync();
    }

    protected void finalize() throws Throwable {
        this.closeSilently();
        super.finalize();
    }

    public static abstract class Spi
    extends SpatialImageReader.Spi {
        static final Class<?>[] TYPES = new Class[]{File.class, URI.class, URL.class, String.class};
        static final Set<InformationType> INFO = Collections.unmodifiableSet(EnumSet.allOf(InformationType.class));
        protected final ImageReaderSpi main;
        final boolean acceptStream;

        protected Spi(ImageReaderSpi imageReaderSpi) {
            ArgumentChecks.ensureNonNull((String)"main", (Object)imageReaderSpi);
            this.main = imageReaderSpi;
            this.names = imageReaderSpi.getFormatNames();
            this.suffixes = imageReaderSpi.getFileSuffixes();
            this.MIMETypes = imageReaderSpi.getMIMETypes();
            this.inputTypes = TYPES;
            this.supportsStandardStreamMetadataFormat = imageReaderSpi.isStandardStreamMetadataFormatSupported();
            this.supportsStandardImageMetadataFormat = imageReaderSpi.isStandardImageMetadataFormatSupported();
            this.nativeStreamMetadataFormatName = imageReaderSpi.getNativeStreamMetadataFormatName();
            this.nativeImageMetadataFormatName = imageReaderSpi.getNativeImageMetadataFormatName();
            this.extraStreamMetadataFormatNames = imageReaderSpi.getExtraStreamMetadataFormatNames();
            this.extraImageMetadataFormatNames = imageReaderSpi.getExtraImageMetadataFormatNames();
            boolean bl = false;
            for (Class<ImageInputStream> clazz : imageReaderSpi.getInputTypes()) {
                if (!clazz.isAssignableFrom(ImageInputStream.class)) continue;
                bl = true;
                break;
            }
            this.acceptStream = bl;
        }

        protected Spi(String string) {
            this(Formats.getReaderByFormatName(string, Spi.class));
        }

        protected void addFormatNameSuffix(String string) {
            Spi.addFormatNameSuffix(this.names, this.MIMETypes, string);
        }

        static void addFormatNameSuffix(String[] stringArray, String[] stringArray2, String string) {
            if (stringArray != null && !string.isEmpty()) {
                String string2 = string.toUpperCase(Locale.ENGLISH);
                boolean[] blArray = new boolean[stringArray2 != null ? stringArray2.length : 0];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3;
                    String string4 = string3.concat(Strings.isUpperCase((CharSequence)(string3 = stringArray[i])) ? string2 : string);
                    for (int j = 0; j < blArray.length; ++j) {
                        if (blArray[j]) continue;
                        stringArray2[j] = stringArray2[j].replace(string3, string4);
                        blArray[j] = true;
                    }
                    stringArray[i] = string4;
                }
            }
        }

        @Override
        public IIOMetadataFormat getStreamMetadataFormat(String string) {
            switch (Spi.getMetadataFormatCode(string, this.nativeStreamMetadataFormatName, this.nativeStreamMetadataFormatClassName, this.extraStreamMetadataFormatNames, this.extraStreamMetadataFormatClassNames)) {
                case 1: {
                    return SpatialMetadataFormat.getStreamInstance(string);
                }
                case 2: {
                    return super.getStreamMetadataFormat(string);
                }
            }
            return this.main.getStreamMetadataFormat(string);
        }

        @Override
        public IIOMetadataFormat getImageMetadataFormat(String string) {
            switch (Spi.getMetadataFormatCode(string, this.nativeImageMetadataFormatName, this.nativeImageMetadataFormatClassName, this.extraImageMetadataFormatNames, this.extraImageMetadataFormatClassNames)) {
                case 1: {
                    return SpatialMetadataFormat.getImageInstance(string);
                }
                case 2: {
                    return super.getImageMetadataFormat(string);
                }
            }
            return this.main.getImageMetadataFormat(string);
        }

        final Class<?>[] getMainTypes() {
            return Spi.getMainTypes(this.inputTypes, this.main.getInputTypes());
        }

        static Class<?>[] getMainTypes(Class<?>[] classArray, Class<?>[] classArray2) {
            int n = 0;
            block0: for (int i = 0; i < classArray2.length; ++i) {
                Class<?> clazz = classArray2[i];
                for (Class<?> clazz2 : classArray) {
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    classArray2[n++] = clazz;
                    continue block0;
                }
            }
            return n != 0 ? (Class[])ArraysExt.resize((Object[])classArray2, (int)n) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canDecodeInput(Object object) throws IOException {
            ArgumentChecks.ensureNonNull((String)"source", (Object)object);
            for (Class clazz : this.inputTypes) {
                ImageInputStream imageInputStream;
                if (!clazz.isInstance(object)) continue;
                if (this.main.canDecodeInput(object)) {
                    return true;
                }
                if (!this.acceptStream || ImageInputStream.class.isInstance(object) || (imageInputStream = Formats.createUncachedImageInputStream(object)) == null) break;
                try {
                    boolean bl = this.main.canDecodeInput(imageInputStream);
                    return bl;
                }
                finally {
                    imageInputStream.close();
                }
            }
            return false;
        }

        public Set<InformationType> getModifiedInformation(Object object) throws IOException {
            return INFO;
        }

        @Override
        public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
            serviceRegistry.setOrdering(clazz, this.main, this);
        }

        public static ImageReaderSpi unwrap(ImageReaderSpi imageReaderSpi) {
            while (imageReaderSpi instanceof Spi) {
                imageReaderSpi = ((Spi)imageReaderSpi).main;
            }
            return imageReaderSpi;
        }
    }
}

