/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.geotoolkit.image.io.StreamImageWriter;
import org.geotoolkit.image.io.XImageIO;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.io.TemporaryFile;

public abstract class FileImageWriter
extends StreamImageWriter {
    private File outputFile;
    private boolean isTemporary;

    protected FileImageWriter(StreamImageWriter.Spi spi) {
        super(spi);
    }

    public String getURLEncoding() {
        return "UTF-8";
    }

    protected File getOutputFile() throws IOException {
        Serializable serializable;
        if (this.outputFile != null) {
            return this.outputFile;
        }
        Object object = this.output;
        if (object == null) {
            throw new IllegalStateException(this.getErrorResources().getString(157));
        }
        if (object instanceof String) {
            this.outputFile = new File((String)object);
            return this.outputFile;
        }
        if (object instanceof File) {
            this.outputFile = (File)object;
            return this.outputFile;
        }
        if (object instanceof URI && ((URI)(serializable = (URI)object)).getScheme().equalsIgnoreCase("file")) {
            this.outputFile = new File((URI)serializable);
            return this.outputFile;
        }
        if (object instanceof URL && ((URL)(serializable = (URL)object)).getProtocol().equalsIgnoreCase("file")) {
            this.outputFile = IOUtilities.toFile((URL)serializable, (String)this.getURLEncoding());
            return this.outputFile;
        }
        this.outputFile = TemporaryFile.createTempFile((String)"FIW", (String)XImageIO.getFileSuffix(this.originatingProvider), null);
        this.isTemporary = true;
        return this.outputFile;
    }

    protected boolean isTemporaryFile() {
        return this.isTemporary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        File file = this.outputFile;
        this.outputFile = null;
        if (this.isTemporary) {
            try {
                this.isTemporary = false;
                OutputStream outputStream = this.getOutputStream();
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    IOUtilities.copy((InputStream)fileInputStream, (OutputStream)outputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
                outputStream.flush();
            }
            finally {
                if (!TemporaryFile.delete((File)file)) {
                    file.deleteOnExit();
                }
                super.close();
            }
        }
        super.close();
    }
}

