/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.geotoolkit.image.io.StreamImageReader;
import org.geotoolkit.image.io.XImageIO;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.io.TemporaryFile;

public abstract class FileImageReader
extends StreamImageReader {
    private File inputFile;
    private boolean isTemporary;

    protected FileImageReader(StreamImageReader.Spi spi) {
        super(spi);
    }

    public String getURLEncoding() {
        return "UTF-8";
    }

    private void ensureFileExists(File file) throws FileNotFoundException {
        if (!file.isFile() || !file.canRead()) {
            throw new FileNotFoundException(this.getErrorResources().getString(64, (Object)file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getInputFile() throws FileNotFoundException, IOException {
        Object object;
        if (this.inputFile != null) {
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof String) {
            this.inputFile = new File((String)this.input);
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof File) {
            this.inputFile = (File)this.input;
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof URI && ((URI)(object = (URI)this.input)).getScheme().equalsIgnoreCase("file")) {
            this.inputFile = new File((URI)object);
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof URL && ((URL)(object = (URL)this.input)).getProtocol().equalsIgnoreCase("file")) {
            this.inputFile = IOUtilities.toFile((URL)object, (String)this.getURLEncoding());
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        object = this.getInputStream();
        this.inputFile = TemporaryFile.createTempFile((String)"FIR", (String)XImageIO.getFileSuffix(this.originatingProvider), null);
        this.isTemporary = true;
        FileOutputStream fileOutputStream = new FileOutputStream(this.inputFile);
        try {
            IOUtilities.copy((InputStream)object, (OutputStream)fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
        return this.inputFile;
    }

    protected boolean isTemporaryFile() {
        return this.isTemporary;
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            super.close();
        }
        finally {
            File file = this.inputFile;
            if (file != null) {
                this.inputFile = null;
                if (this.isTemporary && !TemporaryFile.delete((File)file)) {
                    file.deleteOnExit();
                }
            }
            this.isTemporary = false;
        }
    }
}

