/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.LogRecord;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.geotoolkit.image.io.DimensionSet;
import org.geotoolkit.image.io.DimensionSlice;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.converter.Classes;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.util.CodeList;

public class DimensionIdentification
implements WarningProducer {
    final DimensionSet owner;

    protected DimensionIdentification(DimensionSet dimensionSet, DimensionSlice.API aPI) throws IllegalArgumentException {
        if (dimensionSet == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"owner"));
        }
        this.owner = dimensionSet;
        if (aPI != DimensionSlice.API.NONE) {
            int n = aPI.ordinal();
            DimensionIdentification[] dimensionIdentificationArray = dimensionSet.apiMapping();
            if (dimensionIdentificationArray[n] != null) {
                throw new IllegalArgumentException(this.getErrorResources().getString(245, (Object)aPI));
            }
            dimensionIdentificationArray[n] = this;
        }
    }

    DimensionIdentification(DimensionSet dimensionSet) {
        this.owner = dimensionSet;
    }

    DimensionIdentification(DimensionIdentification dimensionIdentification) {
        this.owner = dimensionIdentification.owner;
    }

    private IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    private void addDimensionId(String string, Object[] objectArray) throws IllegalArgumentException {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                throw new NullArgumentException(this.getErrorResources().getString(172, (Object)(string + '[' + i + ']')));
            }
            this.owner.addDimensionId(this, object);
        }
    }

    public void addDimensionId(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(this.getErrorResources().getString(73, (Object)"index", (Object)n));
        }
        this.owner.addDimensionId(this, n);
    }

    public void addDimensionId(String ... stringArray) throws IllegalArgumentException {
        this.addDimensionId("names", (Object[])stringArray);
    }

    public void addDimensionId(AxisDirection ... axisDirectionArray) throws IllegalArgumentException {
        this.addDimensionId("axes", (Object[])axisDirectionArray);
    }

    public void removeDimensionId(Object ... objectArray) {
        this.owner.removeDimensionId(this, objectArray);
    }

    public Object[] getDimensionIds() {
        Map<Object, DimensionIdentification> map = this.owner.identifiersMap();
        Object[] objectArray = new Object[map.size()];
        int n = 0;
        for (Map.Entry<Object, DimensionIdentification> entry : map.entrySet()) {
            if (!this.equals(entry.getValue())) continue;
            objectArray[n++] = entry.getKey();
        }
        return ArraysExt.resize((Object[])objectArray, (int)n);
    }

    public boolean hasDimensionIds() {
        return this.owner.identifiersMap().values().contains(this);
    }

    public int findDimensionIndex(Iterable<?> iterable) {
        Object object;
        HashSet<Object> hashSet = null;
        for (Map.Entry<Object, DimensionIdentification> entry : this.owner.identifiersMap().entrySet()) {
            if (!this.equals(entry.getValue())) continue;
            object = entry.getKey();
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (hashSet == null) {
                hashSet = new HashSet<Object>(8);
            }
            hashSet.add(object);
        }
        if (iterable != null && hashSet != null) {
            Object object2 = null;
            int n = 0;
            for (Object object3 : iterable) {
                Map.Entry entry;
                if (object3 instanceof Map.Entry) {
                    entry = (Map.Entry)object3;
                    object3 = entry.getKey();
                    n = (Integer)entry.getValue();
                }
                if (hashSet.contains(object3)) {
                    if (object2 == null) {
                        object2 = new LinkedHashMap(4);
                    }
                    if ((entry = object2.put(n, object3)) != null) {
                        object2.put(n, entry);
                    }
                }
                ++n;
            }
            object = (Integer)DimensionSet.first(object2, this, DimensionIdentification.class, "findDimensionIndex");
            if (object != null) {
                return (Integer)object;
            }
        }
        return -1;
    }

    public Locale getLocale() {
        return this.owner.getLocale();
    }

    @Override
    public boolean warningOccurred(LogRecord logRecord) {
        return Warnings.log(this, logRecord);
    }

    public String toString() {
        return this.toStringBuilder().append("}]").toString();
    }

    final StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this)).append("[id={");
        boolean bl = false;
        for (Map.Entry<Object, DimensionIdentification> entry : this.owner.identifiersMap().entrySet()) {
            if (entry.getValue() != this) continue;
            Object object = entry.getKey();
            boolean bl2 = object instanceof CharSequence;
            if (object instanceof CodeList) {
                object = ((CodeList)object).name();
            }
            if (bl) {
                stringBuilder.append(", ");
            }
            if (bl2) {
                stringBuilder.append('\"');
            }
            stringBuilder.append(object);
            if (bl2) {
                stringBuilder.append('\"');
            }
            bl = true;
        }
        return stringBuilder;
    }
}

