/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.util.AbstractList;
import java.util.List;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;

final class NameList
extends AbstractList<LocalName> {
    private final NameFactory factory;
    private final String base;
    private final LocalName[] names;
    private final List<String> imageNames;

    NameList(NameFactory nameFactory, List<String> list) {
        this.factory = nameFactory;
        this.base = null;
        this.names = new LocalName[list.size()];
        this.imageNames = list;
    }

    NameList(NameFactory nameFactory, String string, int n) {
        this.factory = nameFactory;
        this.base = string;
        this.names = new LocalName[n];
        this.imageNames = null;
    }

    @Override
    public int size() {
        return this.names.length;
    }

    @Override
    public LocalName get(int n) {
        String string;
        if (n < 0 || n >= this.names.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        LocalName localName = this.names[n];
        if (localName == null && (string = this.imageNames != null ? this.imageNames.get(n) : this.base + " [" + (n + 1) + ']') != null) {
            this.names[n] = localName = this.factory.createLocalName(null, (CharSequence)string);
        }
        return localName;
    }
}

