/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.ImageGeometry;
import org.geotoolkit.coverage.io.CoverageIO;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageStore;
import org.geotoolkit.coverage.io.ImageCoverageReader;
import org.geotoolkit.image.io.mosaic.MosaicBuilder;
import org.geotoolkit.image.io.mosaic.MosaicImageWriteParam;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.image.io.mosaic.TileManagerFactory;
import org.geotoolkit.image.io.mosaic.TileWritingPolicy;
import org.geotoolkit.internal.image.io.SupportFiles;
import org.geotoolkit.io.wkt.PrjFiles;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

final class MosaicCoverageReader
extends ImageCoverageReader {
    static final String CACHE_EXTENSION = ".tiles";
    boolean saved;
    private final CoordinateReferenceSystem crs;
    private transient GridGeometry2D gridGeometry;

    public MosaicCoverageReader(Object object, CoordinateReferenceSystem coordinateReferenceSystem) throws CoverageStoreException {
        this.crs = coordinateReferenceSystem;
        this.setInput(object);
    }

    public MosaicCoverageReader(File file, boolean bl) throws CoverageStoreException {
        TileManager tileManager;
        Object object;
        File file2 = file.getParentFile();
        if (file2 != null && !file2.isDirectory()) {
            throw new CoverageStoreException(Errors.format((int)143, (Object)file2));
        }
        try {
            this.crs = PrjFiles.read((File)((File)SupportFiles.changeExtension(file, "prj")));
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        file2 = new File(file2, file.getName() + CACHE_EXTENSION);
        File file3 = new File(file2, "TileManager.serialized");
        if (file3.exists()) {
            object = null;
            try {
                object = TileManagerFactory.DEFAULT.create(file3);
            }
            catch (Exception exception) {
                Logging.recoverableException((Logger)GridCoverageStore.LOGGER, CoverageIO.class, (String)"createMosaicReader", (Throwable)exception);
            }
            if (object != null && ((TileManager[])object).length == 1) {
                this.setInput(object[0]);
                return;
            }
        }
        if (!bl) {
            this.setInput(file);
            return;
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new CoverageStoreException(Errors.format((int)143, (Object)file2));
            }
            object = TileWritingPolicy.NO_WRITE;
        } else {
            if (!file2.mkdir()) {
                throw new CoverageStoreException(Errors.format((int)25, (Object)file2));
            }
            object = TileWritingPolicy.OVERWRITE;
        }
        MosaicBuilder mosaicBuilder = new MosaicBuilder();
        mosaicBuilder.setTileDirectory(file2);
        MosaicImageWriteParam mosaicImageWriteParam = new MosaicImageWriteParam();
        mosaicImageWriteParam.setTileWritingPolicy((TileWritingPolicy)((Object)object));
        try {
            tileManager = mosaicBuilder.writeFromInput(file, mosaicImageWriteParam);
            if (object == TileWritingPolicy.OVERWRITE) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file3));
                objectOutputStream.writeObject(tileManager);
                objectOutputStream.writeObject(this.crs);
                objectOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        this.setInput(tileManager);
        this.saved = true;
    }

    @Override
    public void setInput(Object object) throws CoverageStoreException {
        if (object != null && !(object instanceof TileManager)) {
            TileManager[] tileManagerArray;
            try {
                tileManagerArray = TileManagerFactory.DEFAULT.createFromObject(object);
            }
            catch (IOException iOException) {
                throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
            }
            if (tileManagerArray != null && tileManagerArray.length == 1) {
                object = tileManagerArray[0];
            }
        }
        ArgumentChecks.ensureCanCast((String)"input", TileManager.class, (Object)object);
        super.setInput(object);
    }

    @Override
    public TileManager getInput() throws CoverageStoreException {
        return (TileManager)super.getInput();
    }

    @Override
    public GridGeometry2D getGridGeometry(int n) throws CoverageStoreException {
        if (n != 0) {
            return super.getGridGeometry(n);
        }
        if (this.gridGeometry == null) {
            ImageGeometry imageGeometry;
            TileManager tileManager = this.getInput();
            if (tileManager == null) {
                throw new IllegalStateException(this.formatErrorMessage(156));
            }
            try {
                imageGeometry = tileManager.getGridGeometry();
            }
            catch (IOException iOException) {
                throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
            }
            this.gridGeometry = imageGeometry == null ? super.getGridGeometry(n) : new GridGeometry2D(imageGeometry.getExtent(), PixelInCell.CELL_CORNER, imageGeometry.getGridToCRS(), this.crs, null);
        }
        return this.gridGeometry;
    }

    public String toString() {
        return "MosaicCoverageReader[saved=" + this.saved + ']';
    }
}

