/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.operator.WarpDescriptor;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageWriteParam;
import org.geotoolkit.coverage.io.GridCoverageWriter;
import org.geotoolkit.coverage.io.ImageCoverageStore;
import org.geotoolkit.image.io.MultidimensionalImageStore;
import org.geotoolkit.image.io.XImageIO;
import org.geotoolkit.image.io.metadata.MetadataNodeAccessor;
import org.geotoolkit.image.io.metadata.MetadataNodeParser;
import org.geotoolkit.image.io.metadata.ReferencingBuilder;
import org.geotoolkit.image.io.mosaic.MosaicImageWriter;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.internal.image.io.DimensionAccessor;
import org.geotoolkit.internal.image.io.GridDomainAccessor;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.referencing.operation.transform.WarpFactory;
import org.geotoolkit.resources.Errors;
import org.opengis.coverage.InterpolationMethod;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class ImageCoverageWriter
extends GridCoverageWriter {
    protected ImageWriter imageWriter;

    @Override
    public void setLogLevel(Level level) {
        super.setLogLevel(level);
        this.copyLevel(this.imageWriter);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        ImageCoverageWriter.setLocale(this.imageWriter, locale);
    }

    private static void setLocale(ImageWriter imageWriter, Locale locale) {
        if (imageWriter != null) {
            imageWriter.setLocale(ImageCoverageWriter.select(locale, imageWriter.getAvailableLocales()));
        }
    }

    @Override
    public void setOutput(Object object) throws CoverageStoreException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(object, iOException, true), iOException);
        }
        super.setOutput(object);
    }

    private void setImageOutput(RenderedImage renderedImage, String string) throws CoverageStoreException {
        Object object = this.output;
        if (object != null) {
            try {
                Object object2;
                ImageWriter imageWriter = this.imageWriter;
                ImageWriter imageWriter2 = null;
                if (object instanceof ImageWriter) {
                    imageWriter2 = (ImageWriter)object;
                } else {
                    if (imageWriter != null && (object2 = imageWriter.getOriginatingProvider()) != null && this.canReuseImageWriter((ImageWriterSpi)object2, string, object, renderedImage)) {
                        imageWriter2 = imageWriter;
                    }
                    if (imageWriter2 == null) {
                        imageWriter2 = this.createImageWriter(string, object, renderedImage);
                    }
                    if (imageWriter2 != object && imageWriter2.getOutput() == null) {
                        object2 = object;
                        ImageWriterSpi imageWriterSpi = imageWriter2.getOriginatingProvider();
                        if (imageWriterSpi != null) {
                            boolean bl = false;
                            for (Class<ImageOutputStream> clazz : imageWriterSpi.getOutputTypes()) {
                                if (clazz.isInstance(object2)) {
                                    bl = false;
                                    break;
                                }
                                if (!clazz.isAssignableFrom(ImageOutputStream.class)) continue;
                                bl = true;
                            }
                            if (bl && (object2 = ImageIO.createImageOutputStream(object)) == null) {
                                Object object3;
                                int n;
                                if (IOUtilities.canProcessAsPath((Object)object)) {
                                    n = 42;
                                    object3 = IOUtilities.name((Object)object);
                                } else {
                                    n = 226;
                                    object3 = object.getClass();
                                }
                                throw new CoverageStoreException(Errors.getResources((Locale)this.locale).getString(n, object3));
                            }
                        }
                        imageWriter2.setOutput(object2);
                    }
                }
                if (imageWriter2 != imageWriter) {
                    if (imageWriter != null) {
                        object2 = imageWriter.getOutput();
                        imageWriter.dispose();
                        if (object2 != imageWriter2.getOutput()) {
                            IOUtilities.close((Object)object2);
                        }
                    }
                    this.copyLevel(imageWriter2);
                    ImageCoverageWriter.setLocale(imageWriter2, this.locale);
                    if (LOGGER.isLoggable(this.getFineLevel())) {
                        ImageCoverageStore.logCodecCreation(this, ImageCoverageWriter.class, imageWriter2, imageWriter2.getOriginatingProvider());
                    }
                }
                this.imageWriter = imageWriter2;
            }
            catch (IOException iOException) {
                throw new CoverageStoreException(this.formatErrorMessage(object, iOException, true), iOException);
            }
        }
    }

    protected boolean canReuseImageWriter(ImageWriterSpi imageWriterSpi, String string, Object object, RenderedImage renderedImage) throws IOException {
        String[] stringArray;
        if (!(string == null || (stringArray = imageWriterSpi.getFormatNames()) != null && ArraysExt.containsIgnoreCase((String[])stringArray, (String)string))) {
            return false;
        }
        return imageWriterSpi.canEncodeImage(renderedImage);
    }

    protected ImageWriter createImageWriter(String string, Object object, RenderedImage renderedImage) throws IOException {
        if (MosaicImageWriter.Spi.DEFAULT.canEncodeOutput(object)) {
            return MosaicImageWriter.Spi.DEFAULT.createWriterInstance();
        }
        if (string != null) {
            return XImageIO.getWriterByFormatName(string, object, renderedImage);
        }
        return XImageIO.getWriterBySuffix(object, renderedImage);
    }

    protected ImageWriteParam createImageWriteParam(RenderedImage renderedImage) throws IOException {
        ImageWriteParam imageWriteParam = this.imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteTiles()) {
            imageWriteParam.setTilingMode(1);
        }
        if (imageWriteParam.canWriteProgressive()) {
            imageWriteParam.setProgressiveMode(1);
        }
        if (imageWriteParam.canWriteCompressed()) {
            imageWriteParam.setCompressionMode(1);
        }
        return imageWriteParam;
    }

    protected void completeImageMetadata(IIOMetadata iIOMetadata, GridCoverage gridCoverage) throws IOException {
    }

    @Override
    public void write(GridCoverage gridCoverage, GridCoverageWriteParam gridCoverageWriteParam) throws CoverageStoreException, CancellationException {
        this.write(Collections.singleton(gridCoverage), gridCoverageWriteParam);
    }

    @Override
    public void write(Iterable<? extends GridCoverage> iterable, GridCoverageWriteParam gridCoverageWriteParam) throws CoverageStoreException, CancellationException {
        boolean bl;
        this.abortRequested = false;
        long l = this.isLoggable() ? System.nanoTime() : Long.MIN_VALUE;
        Iterator<? extends GridCoverage> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new CoverageStoreException(Errors.format((int)261, GridCoverage.class));
        }
        this.write(iterator.next(), gridCoverageWriteParam, true, !(bl = iterator.hasNext()), l);
        while (bl) {
            this.write(iterator.next(), gridCoverageWriteParam, false, !(bl = iterator.hasNext()), l);
        }
    }

    private void write(GridCoverage gridCoverage, GridCoverageWriteParam gridCoverageWriteParam, boolean bl, boolean bl2, long l) throws CoverageStoreException, CancellationException {
        long l2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        InterpolationMethod interpolationMethod;
        ImageWriteParam imageWriteParam;
        Object object7;
        GridGeometry2D gridGeometry2D = GridGeometry2D.castOrCopy((GridGeometry)gridCoverage.getGridGeometry());
        RenderedImage renderedImage = gridCoverage.getRenderableImage(gridGeometry2D.gridDimensionX, gridGeometry2D.gridDimensionY).createDefaultRendering();
        while (renderedImage instanceof RenderedImageAdapter) {
            renderedImage = ((RenderedImageAdapter)renderedImage).getWrappedImage();
        }
        if (bl) {
            object7 = gridCoverageWriteParam != null ? gridCoverageWriteParam.getFormatName() : null;
            this.setImageOutput(renderedImage, (String)object7);
        }
        if ((object7 = this.imageWriter) == null) {
            throw new IllegalStateException(this.formatErrorMessage(157));
        }
        if (!bl2 && !((ImageWriter)object7).canWriteSequence()) {
            throw new CoverageStoreException(Errors.format((int)262, GridCoverage.class));
        }
        try {
            imageWriteParam = this.createImageWriteParam(renderedImage);
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        MathTransform2D mathTransform2D = null;
        RenderedOp renderedOp = null;
        if (gridCoverageWriteParam != null) {
            int n;
            interpolationMethod = gridCoverageWriteParam.getInterpolation();
            if (interpolationMethod.equals((Object)InterpolationMethod.NEAREST_NEIGHBOUR)) {
                n = 0;
            } else if (interpolationMethod.equals((Object)InterpolationMethod.BILINEAR)) {
                n = 1;
            } else if (interpolationMethod.equals((Object)InterpolationMethod.BICUBIC)) {
                n = 2;
            } else {
                throw new CoverageStoreException(Errors.getResources((Locale)this.locale).getString(73, (Object)"interpolation", (Object)interpolationMethod.name()));
            }
            mathTransform2D = this.geodeticToPixelCoordinates(gridGeometry2D, gridCoverageWriteParam, imageWriteParam);
            imageWriteParam.setSourceBands(gridCoverageWriteParam.getSourceBands());
            object6 = imageWriteParam.getSourceRegion();
            object5 = this.requestedBounds;
            if (n != 0 || !ImageCoverageWriter.isIdentity(mathTransform2D) || ImageCoverageWriter.isGreater(((Rectangle)object5).width, imageWriteParam.getSourceXSubsampling(), ((Rectangle)object6).width) || ImageCoverageWriter.isGreater(((Rectangle)object5).height, imageWriteParam.getSourceYSubsampling(), ((Rectangle)object6).height)) {
                object4 = gridCoverage instanceof AbstractCoverage ? ((AbstractCoverage)gridCoverage).getName() : null;
                object3 = new ImageLayout(((Rectangle)object5).x, ((Rectangle)object5).y, ((Rectangle)object5).width, ((Rectangle)object5).height);
                object3.setTileWidth(((Rectangle)object5).width);
                object3.setTileHeight(((Rectangle)object5).height);
                RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, object3);
                mathTransform2D = (MathTransform2D)this.destGridToSource;
                try {
                    object2 = WarpFactory.DEFAULT.create((CharSequence)object4, mathTransform2D, (Rectangle)object6);
                }
                catch (TransformException transformException) {
                    throw new CoverageStoreException(this.formatErrorMessage(transformException), transformException);
                }
                object = gridCoverageWriteParam.getBackgroundValues();
                if (object == null) {
                    object = CoverageUtilities.getBackgroundValues((GridCoverage)gridCoverage);
                }
                renderedOp = WarpDescriptor.create((RenderedImage)renderedImage, (Warp)object2, (Interpolation)Interpolation.getInstance((int)n), (double[])object, (RenderingHints)renderingHints);
                renderedImage = renderedOp;
                imageWriteParam.setSourceRegion(null);
                imageWriteParam.setSourceSubsampling(1, 1, 0, 0);
            }
            if (imageWriteParam.canWriteCompressed() && (object4 = gridCoverageWriteParam.getCompressionQuality()) != null) {
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(((Float)object4).floatValue());
            }
        }
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(renderedImage);
        interpolationMethod = bl ? ((ImageWriter)object7).getDefaultStreamMetadata(imageWriteParam) : null;
        object6 = ((ImageWriter)object7).getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        if (object6 != null && ArraysExt.contains((Object[])((IIOMetadata)object6).getMetadataFormatNames(), (Object)"geotk-coverageio_3.07")) {
            object5 = null;
            object4 = null;
            object3 = null;
            if (gridCoverageWriteParam != null) {
                object5 = gridCoverageWriteParam.getCoordinateReferenceSystem();
                object4 = gridCoverageWriteParam.getEnvelope();
                object3 = gridCoverageWriteParam.getResolution();
            }
            boolean bl3 = object7.getClass().getName().equals("org.geotoolkit.image.io.plugin.NetcdfImageWriter");
            if (object5 == null && gridGeometry2D.isDefined(1)) {
                object5 = object7 instanceof MultidimensionalImageStore || bl3 ? gridGeometry2D.getCoordinateReferenceSystem() : gridGeometry2D.getCoordinateReferenceSystem2D();
            }
            if (object4 == null && gridGeometry2D.isDefined(2)) {
                object4 = object7 instanceof MultidimensionalImageStore || bl3 ? gridGeometry2D.getEnvelope() : gridGeometry2D.getEnvelope2D();
            }
            if (object5 != null) {
                object2 = new ReferencingBuilder((IIOMetadata)object6);
                ((ReferencingBuilder)((Object)object2)).setCoordinateReferenceSystem((CoordinateReferenceSystem)object5);
            }
            if (object4 != null) {
                object2 = new GridDomainAccessor((IIOMetadata)object6);
                object = ImageCoverageWriter.getImageSize(renderedImage, imageWriteParam);
                double d = object4.getMinimum(0);
                double d2 = object4.getMaximum(1);
                if (object3 != null) {
                    double[] dArray = new double[]{d, d2};
                    ((GridDomainAccessor)object2).setOrigin(dArray);
                    dArray[0] = object3[0];
                    dArray[1] = 0.0;
                    ((GridDomainAccessor)object2).addOffsetVector(dArray);
                    dArray[1] = -object3[1];
                    dArray[0] = 0.0;
                    ((GridDomainAccessor)object2).addOffsetVector(dArray);
                    dArray[0] = object4.getMedian(0);
                    dArray[1] = object4.getMedian(1);
                    ((GridDomainAccessor)object2).setSpatialRepresentation(dArray, null, PixelOrientation.UPPER_LEFT);
                    ((GridDomainAccessor)object2).setLimits(new int[2], new int[]{((Dimension)object).width - 1, ((Dimension)object).height - 1});
                } else {
                    ((GridDomainAccessor)object2).setAll(d, d2, object4.getMaximum(0), object4.getMinimum(1), ((Dimension)object).width, ((Dimension)object).height, false, null);
                }
            }
            int n = gridCoverage.getNumSampleDimensions();
            object = new DimensionAccessor((IIOMetadata)object6);
            for (int i = 0; i < n; ++i) {
                SampleDimension sampleDimension = gridCoverage.getSampleDimension(i);
                ((MetadataNodeParser)object).selectChild(((MetadataNodeAccessor)object).appendChild());
                if (sampleDimension == null) continue;
                ((DimensionAccessor)object).setDimension(sampleDimension, this.locale);
            }
        }
        this.checkAbortState();
        try {
            if (interpolationMethod != null) {
                this.completeImageMetadata((IIOMetadata)interpolationMethod, null);
            }
            this.completeImageMetadata((IIOMetadata)object6, gridCoverage);
            object5 = new IIOImage(renderedImage, null, (IIOMetadata)object6);
            if (bl & bl2) {
                ((ImageWriter)object7).write((IIOMetadata)interpolationMethod, (IIOImage)object5, imageWriteParam);
            } else {
                if (bl) {
                    ((ImageWriter)object7).prepareWriteSequence((IIOMetadata)interpolationMethod);
                }
                ((ImageWriter)object7).writeToSequence((IIOImage)object5, imageWriteParam);
                if (bl2) {
                    ((ImageWriter)object7).endWriteSequence();
                }
            }
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        this.checkAbortState();
        if (bl2 && l != Long.MIN_VALUE && LOGGER.isLoggable((Level)(object3 = (Object)this.getLogLevel(l2 = System.nanoTime() - l)))) {
            Dimension dimension = ImageCoverageWriter.getImageSize(renderedImage, imageWriteParam);
            object2 = null;
            if (gridCoverageWriteParam != null) {
                object2 = gridCoverageWriteParam.getCoordinateReferenceSystem();
            }
            ImageCoverageStore.logOperation((Level)object3, this.locale, ImageCoverageWriter.class, true, this.output, 0, gridCoverage, dimension, (CoordinateReferenceSystem)object2, mathTransform2D, l2);
        }
        if (renderedOp != null) {
            renderedOp.dispose();
        }
    }

    private static Dimension getImageSize(RenderedImage renderedImage, ImageWriteParam imageWriteParam) {
        Rectangle rectangle;
        Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        if (imageWriteParam != null && (rectangle = imageWriteParam.getSourceRegion()) != null) {
            dimension.width = Math.min(dimension.width, rectangle.width / imageWriteParam.getSourceXSubsampling());
            dimension.height = Math.min(dimension.height, rectangle.height / imageWriteParam.getSourceXSubsampling());
        }
        return dimension;
    }

    private static boolean isGreater(int n, int n2, int n3) {
        return n * n2 - (n2 - 1) > n3;
    }

    @Override
    public void abort() {
        super.abort();
        ImageWriter imageWriter = this.imageWriter;
        if (imageWriter != null) {
            imageWriter.abort();
        }
    }

    @Override
    final String formatErrorMessage(Throwable throwable) {
        return this.formatErrorMessage(this.output, throwable, true);
    }

    private void close() throws IOException {
        Object object = this.output;
        this.output = null;
        ImageWriter imageWriter = this.imageWriter;
        if (imageWriter != null) {
            if (imageWriter.getOutput() != object) {
                XImageIO.close(imageWriter);
            } else {
                imageWriter.setOutput(null);
            }
        }
    }

    @Override
    public void reset() throws CoverageStoreException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        if (this.imageWriter != null) {
            this.imageWriter.reset();
        }
        super.reset();
    }

    @Override
    public void dispose() throws CoverageStoreException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new CoverageStoreException(this.formatErrorMessage(iOException), iOException);
        }
        if (this.imageWriter != null) {
            this.imageWriter.dispose();
            this.imageWriter = null;
        }
        super.dispose();
    }
}

