/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.spi.ImageReaderWriterSpi;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.io.GridCoverageStore;
import org.geotoolkit.coverage.io.GridCoverageWriter;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.InternationalString;

final class ImageCoverageStore
extends Static {
    private ImageCoverageStore() {
    }

    static void logCodecCreation(GridCoverageStore gridCoverageStore, Class<?> clazz, Object object, ImageReaderWriterSpi imageReaderWriterSpi) {
        Serializable serializable;
        assert (clazz.isInstance(gridCoverageStore)) : clazz;
        boolean bl = gridCoverageStore instanceof GridCoverageWriter;
        Locale locale = gridCoverageStore.locale;
        String string = Loggings.getResources((Locale)locale).getString(61, (Object)(bl ? 1 : 0), (Object)object.getClass().getName());
        if (imageReaderWriterSpi != null) {
            serializable = new StringBuilder(string).append('\n');
            Formats.formatDescription(imageReaderWriterSpi, locale, (StringBuilder)serializable);
            string = ((StringBuilder)serializable).toString();
        }
        serializable = new LogRecord(gridCoverageStore.getFineLevel(), string);
        ((LogRecord)serializable).setLoggerName(GridCoverageStore.LOGGER.getName());
        ((LogRecord)serializable).setSourceClassName(clazz.getName());
        ((LogRecord)serializable).setSourceMethodName(bl ? "setOutput" : "setInput");
        GridCoverageStore.LOGGER.log((LogRecord)serializable);
    }

    static void logOperation(Level level, Locale locale, Class<?> clazz, boolean bl, Object object, int n, GridCoverage gridCoverage, Dimension dimension, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform2D mathTransform2D, long l) {
        Object object2;
        String string;
        Object object3;
        if (object instanceof Object[] && n < ((Object[])(object3 = (Object[])object)).length) {
            object = object3[n];
        }
        object3 = IOUtilities.canProcessAsPath((Object)object) ? IOUtilities.name((Object)object) : Classes.getShortClassName((Object)object);
        InternationalString internationalString = null;
        if (gridCoverage instanceof AbstractCoverage) {
            internationalString = ((AbstractCoverage)gridCoverage).getName();
        }
        if (internationalString == null) {
            internationalString = Vocabulary.formatInternational((int)311);
        }
        String string2 = gridCoverage instanceof GridCoverage2D ? ((GridCoverage2D)gridCoverage).getViewTypes().toString() : Vocabulary.getResources((Locale)locale).getString(203);
        GridEnvelope gridEnvelope = gridCoverage.getGridGeometry().getExtent();
        int n2 = gridEnvelope.getDimension();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            int n3 = gridEnvelope.getSpan(i);
            if (dimension != null) {
                switch (i) {
                    case 0: {
                        n3 = dimension.width;
                        break;
                    }
                    case 1: {
                        n3 = dimension.height;
                    }
                }
            }
            if (i != 0) {
                stringBuilder.append(" \u00d7 ");
            }
            stringBuilder.append(n3);
        }
        String string3 = stringBuilder.toString();
        String string4 = null;
        if (coordinateReferenceSystem == null) {
            coordinateReferenceSystem = gridCoverage.getCoordinateReferenceSystem();
        }
        if (coordinateReferenceSystem != null) {
            stringBuilder.setLength(0);
            string = IdentifiedObjects.getName((IdentifiedObject)coordinateReferenceSystem, null);
            if (string != null) {
                stringBuilder.append(string);
            }
            if ((object2 = IdentifiedObjects.getIdentifier((IdentifiedObject)coordinateReferenceSystem)) != null) {
                stringBuilder.append(" (").append((String)object2).append(')');
            }
            if (stringBuilder.length() != 0) {
                string4 = stringBuilder.toString();
            }
        }
        if (string4 == null) {
            string4 = Vocabulary.getResources((Locale)locale).getString(307);
        }
        string = null;
        if (mathTransform2D != null && !mathTransform2D.isIdentity()) {
            try {
                if (mathTransform2D instanceof AffineTransform) {
                    object2 = (AffineTransform)mathTransform2D.inverse();
                    if (((AffineTransform)object2).getShearX() == 0.0 && ((AffineTransform)object2).getShearY() == 0.0) {
                        stringBuilder.setLength(0);
                        string = stringBuilder.append("AffineTransform[scale=(").append(InternalUtilities.adjustForRoundingError((double)((AffineTransform)object2).getScaleX())).append(", ").append(InternalUtilities.adjustForRoundingError((double)((AffineTransform)object2).getScaleY())).append("), translation=(").append(InternalUtilities.adjustForRoundingError((double)((AffineTransform)object2).getTranslateX())).append(", ").append(InternalUtilities.adjustForRoundingError((double)((AffineTransform)object2).getTranslateY())).append(")]").toString();
                    } else {
                        string = new AffineTransform((AffineTransform)object2).toString();
                    }
                } else {
                    string = Classes.getShortClassName((Object)mathTransform2D);
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                string = noninvertibleTransformException.toString();
            }
        }
        if (string == null) {
            string = Vocabulary.getResources((Locale)locale).getString(203);
        }
        object2 = Loggings.getResources((Locale)locale).getLogRecord(level, 62, (Object)new Object[]{bl ? 1 : 0, object3, internationalString.toString(locale), string2, string3, string4, string, (double)l / 1000000.0});
        ((LogRecord)object2).setLoggerName(GridCoverageStore.LOGGER.getName());
        ((LogRecord)object2).setSourceClassName(clazz.getName());
        ((LogRecord)object2).setSourceMethodName(bl ? "write" : "read");
        GridCoverageStore.LOGGER.log((LogRecord)object2);
    }
}

