/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.GridCoverageStore;
import org.geotoolkit.coverage.io.GridCoverageWriteParam;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.resources.Errors;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class GridCoverageWriter
extends GridCoverageStore {
    Object output;
    transient Rectangle requestedBounds;

    protected GridCoverageWriter() {
    }

    public void setOutput(Object object) throws CoverageStoreException {
        this.output = object;
        this.abortRequested = false;
    }

    public Object getOutput() throws CoverageStoreException {
        return this.output;
    }

    public abstract void write(GridCoverage var1, GridCoverageWriteParam var2) throws CoverageStoreException, CancellationException;

    public void write(Iterable<? extends GridCoverage> iterable, GridCoverageWriteParam gridCoverageWriteParam) throws CoverageStoreException, CancellationException {
        int n = 261;
        Iterator<? extends GridCoverage> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            GridCoverage gridCoverage = iterator.next();
            if (!iterator.hasNext()) {
                this.write(gridCoverage, gridCoverageWriteParam);
                return;
            }
            n = 262;
        }
        throw new CoverageStoreException(Errors.format((int)n, GridCoverage.class));
    }

    @Override
    final void computeRequestedBounds(MathTransform mathTransform, Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException, CoverageStoreException {
        GeneralGridEnvelope generalGridEnvelope = new GeneralGridEnvelope((Envelope)Envelopes.transform((MathTransform)mathTransform.inverse(), (Envelope)envelope), PixelInCell.CELL_CORNER, false);
        int n = generalGridEnvelope.getDimension();
        while (--n >= 0) {
            if (generalGridEnvelope.getSpan(n) > 0) continue;
            String string = this.formatErrorMessage(247);
            if (coordinateReferenceSystem != null) {
                string = coordinateReferenceSystem.getCoordinateSystem().getAxis(n).getName().getCode() + ": " + string;
            }
            throw new CoverageStoreException(string);
        }
        this.requestedBounds = new Rectangle(generalGridEnvelope.getLow(0), generalGridEnvelope.getLow(1), generalGridEnvelope.getSpan(0), generalGridEnvelope.getSpan(1));
    }

    @Override
    public void reset() throws CoverageStoreException {
        this.requestedBounds = null;
        this.output = null;
        super.reset();
    }

    @Override
    public void dispose() throws CoverageStoreException {
        this.requestedBounds = null;
        this.output = null;
        super.dispose();
    }
}

