/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.io.GridCoverageStoreParam;
import org.opengis.coverage.InterpolationMethod;

public class GridCoverageWriteParam
extends GridCoverageStoreParam {
    private static final long serialVersionUID = 171475620398426965L;
    private String formatName;
    private Float compressionQuality;
    private InterpolationMethod interpolation;
    private double[] backgroundValues;

    public GridCoverageWriteParam() {
    }

    public GridCoverageWriteParam(GridCoverageStoreParam gridCoverageStoreParam) {
        super(gridCoverageStoreParam);
        if (gridCoverageStoreParam instanceof GridCoverageWriteParam) {
            GridCoverageWriteParam gridCoverageWriteParam = (GridCoverageWriteParam)gridCoverageStoreParam;
            this.formatName = gridCoverageWriteParam.formatName;
            this.compressionQuality = gridCoverageWriteParam.compressionQuality;
            this.backgroundValues = gridCoverageWriteParam.backgroundValues;
        }
    }

    @Override
    public void clear() {
        this.formatName = null;
        this.compressionQuality = null;
        this.backgroundValues = null;
        super.clear();
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String string) {
        this.formatName = string;
    }

    public Float getCompressionQuality() {
        return this.compressionQuality;
    }

    public void setCompressionQuality(Float f) throws IllegalArgumentException {
        if (f != null) {
            ArgumentChecks.ensureBetween((String)"quality", (float)0.0f, (float)1.0f, (float)f.floatValue());
        }
        this.compressionQuality = f;
    }

    public InterpolationMethod getInterpolation() {
        if (this.interpolation == null) {
            this.interpolation = InterpolationMethod.NEAREST_NEIGHBOUR;
        }
        return this.interpolation;
    }

    public void setInterpolation(InterpolationMethod interpolationMethod) {
        this.interpolation = interpolationMethod;
    }

    public double[] getBackgroundValues() {
        double[] dArray = this.backgroundValues;
        if (dArray != null) {
            dArray = (double[])dArray.clone();
        }
        return dArray;
    }

    public void setBackgroundValues(double ... dArray) {
        if (dArray != null) {
            dArray = (double[])dArray.clone();
        }
        this.backgroundValues = dArray;
    }
}

