/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.cs.AxisRangeType;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class GridCoverageStoreParam
implements Serializable {
    private static final long serialVersionUID = 5654080292972651645L;
    private CoordinateReferenceSystem crs;
    private Envelope envelope;
    private double[] resolution;
    private int[] sourceBands;

    protected GridCoverageStoreParam() {
    }

    protected GridCoverageStoreParam(GridCoverageStoreParam gridCoverageStoreParam) {
        if (gridCoverageStoreParam != null) {
            this.crs = gridCoverageStoreParam.crs;
            this.envelope = gridCoverageStoreParam.envelope;
            this.resolution = gridCoverageStoreParam.resolution;
            this.sourceBands = gridCoverageStoreParam.sourceBands;
        }
    }

    public void clear() {
        this.crs = null;
        this.envelope = null;
        this.resolution = null;
        this.sourceBands = null;
    }

    private static void ensureCompatibleCRS(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (coordinateReferenceSystem != null && envelope != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem2)) {
            throw new MismatchedReferenceSystemException(Errors.format((int)111));
        }
    }

    private static void ensureCompatibleDimension(double[] dArray, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        int n;
        int n2;
        if (coordinateReferenceSystem != null && dArray != null && (n2 = dArray.length) != (n = coordinateReferenceSystem.getCoordinateSystem().getDimension())) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n2, (Object)n));
        }
    }

    private static void ensureCompatibleDimension(double[] dArray, Envelope envelope) throws MismatchedDimensionException {
        int n;
        int n2;
        if (dArray != null && envelope != null && (n2 = dArray.length) != (n = envelope.getDimension())) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n2, (Object)n));
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.crs == null && this.envelope != null) {
            return this.envelope.getCoordinateReferenceSystem();
        }
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        GridCoverageStoreParam.ensureCompatibleCRS(this.envelope, coordinateReferenceSystem);
        GridCoverageStoreParam.ensureCompatibleDimension(this.resolution, coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    public Envelope getEnvelope() {
        Envelope envelope = this.envelope;
        if (envelope != null) {
            if (this.crs != null && envelope.getCoordinateReferenceSystem() == null) {
                GeneralEnvelope generalEnvelope = new GeneralEnvelope(envelope);
                generalEnvelope.setCoordinateReferenceSystem(this.crs);
                envelope = generalEnvelope;
            } else if (envelope instanceof Cloneable) {
                envelope = (Envelope)((Cloneable)envelope).clone();
            }
        }
        return envelope;
    }

    final GeneralEnvelope getValidEnvelope(boolean bl) {
        Envelope envelope = this.getEnvelope();
        if (envelope == null) {
            return null;
        }
        GeneralEnvelope generalEnvelope = envelope instanceof GeneralEnvelope && envelope != this.envelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
        if (bl) {
            generalEnvelope.setCoordinateReferenceSystem(CRSUtilities.shiftAxisRange((CoordinateReferenceSystem)generalEnvelope.getCoordinateReferenceSystem(), (AxisRangeType)AxisRangeType.POSITIVE_LONGITUDE));
        }
        if (generalEnvelope.reduceToDomain(false)) {
            generalEnvelope.reorderCorners();
        }
        return generalEnvelope;
    }

    public void setEnvelope(Envelope envelope) throws IllegalArgumentException {
        if (envelope != null) {
            GridCoverageStoreParam.ensureCompatibleCRS(envelope, this.crs);
            GridCoverageStoreParam.ensureCompatibleDimension(this.resolution, envelope);
            int n = 0;
            int n2 = envelope.getDimension();
            while (--n2 >= 0) {
                if (!(envelope.getSpan(n2) > 0.0)) continue;
                ++n;
            }
            if (n < 2) {
                throw new IllegalArgumentException(Errors.format((int)60));
            }
            if (envelope instanceof Cloneable) {
                envelope = (Envelope)((Cloneable)envelope).clone();
            }
        }
        this.envelope = envelope;
    }

    public void setEnvelope(Rectangle2D rectangle2D, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        this.setEnvelope((Envelope)(rectangle2D != null ? new Envelope2D(coordinateReferenceSystem, rectangle2D) : null));
    }

    public double[] getResolution() {
        return this.resolution != null ? (double[])this.resolution.clone() : null;
    }

    public void setResolution(double ... dArray) throws MismatchedDimensionException {
        GridCoverageStoreParam.ensureCompatibleDimension(dArray, this.crs);
        GridCoverageStoreParam.ensureCompatibleDimension(dArray, this.envelope);
        if (dArray != null) {
            for (double d : dArray = (double[])dArray.clone()) {
                ArgumentChecks.ensurePositive((String)"resolution", (double)d);
            }
        }
        this.resolution = dArray;
    }

    public int[] getSourceBands() {
        int[] nArray = this.sourceBands;
        return nArray != null ? (int[])nArray.clone() : null;
    }

    public void setSourceBands(int ... nArray) throws IllegalArgumentException {
        this.sourceBands = GridCoverageStoreParam.checkAndClone(nArray);
    }

    static int[] checkAndClone(int[] nArray) throws IllegalArgumentException {
        if (nArray != null) {
            if (nArray.length == 0) {
                throw new IllegalArgumentException(Errors.format((int)58));
            }
            nArray = (int[])nArray.clone();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0) {
                    throw new IllegalArgumentException(Errors.format((int)5, (Object)n));
                }
                int n2 = i;
                while (--n2 >= 0) {
                    if (n != nArray[n2]) continue;
                    throw new IllegalArgumentException(Errors.format((int)56, (Object)n));
                }
            }
        }
        return nArray;
    }

    public String toString() {
        CoordinateReferenceSystem coordinateReferenceSystem;
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        String string = "";
        if (this.envelope != null) {
            stringBuilder.append("envelope=").append(this.envelope);
            string = ", ";
        }
        if (this.resolution != null) {
            stringBuilder.append(string).append("resolution=").append(Arrays.toString(this.resolution));
            string = ", ";
        }
        if ((coordinateReferenceSystem = this.getCoordinateReferenceSystem()) != null) {
            stringBuilder.append(string).append("crs=\"").append(coordinateReferenceSystem.getName().getCode()).append('\"');
            string = ", ";
        }
        if (this.sourceBands != null) {
            stringBuilder.append(string).append("sourceBands=").append(Arrays.toString(this.sourceBands));
            string = ", ";
        }
        this.toString(stringBuilder, string);
        return stringBuilder.append(']').toString();
    }

    void toString(StringBuilder stringBuilder, String string) {
    }
}

