/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.io;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOParam;
import org.apache.sis.util.logging.PerformanceLevel;
import org.geotoolkit.coverage.grid.GridEnvelope2D;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.InvalidGridGeometryException;
import org.geotoolkit.coverage.io.CoverageStoreException;
import org.geotoolkit.coverage.io.DisjointCoverageDomainException;
import org.geotoolkit.coverage.io.GridCoverageStoreParam;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.cs.AxisRangeType;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.logging.LogProducer;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GridCoverageStore
implements LogProducer,
Localized {
    static final boolean DEBUG = false;
    static final Logger LOGGER = Logging.getLogger(GridCoverageStore.class);
    private static final int MIN_SIZE = 4;
    private static final double EPS = 1.0E-5;
    private final Hints hints = new Hints();
    private Level logLevel;
    Locale locale;
    boolean ignoreGridTransforms;
    transient MathTransform destGridToSource;
    protected volatile boolean abortRequested;

    protected GridCoverageStore() {
    }

    final boolean isLoggable() {
        Level level = this.logLevel;
        if (level == null) {
            level = PerformanceLevel.SLOWEST;
        }
        return LOGGER.isLoggable(level);
    }

    final Level getFineLevel() {
        Level level = this.logLevel;
        return level != null ? level : PerformanceLevel.FINE;
    }

    final Level getLogLevel(long l) {
        Level level = this.logLevel;
        if (level == null) {
            level = PerformanceLevel.forDuration((long)l, (TimeUnit)TimeUnit.NANOSECONDS);
        }
        return level;
    }

    public Level getLogLevel() {
        Level level = this.logLevel;
        return level != null ? level : PerformanceLevel.PERFORMANCE;
    }

    public void setLogLevel(Level level) {
        this.logLevel = level;
    }

    final void copyLevel(Object object) {
        if (object instanceof LogProducer) {
            ((LogProducer)object).setLogLevel(this.logLevel);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    static Locale select(Locale locale, Locale[] localeArray) {
        if (locale != null && localeArray != null) {
            int n = localeArray.length;
            while (--n >= 0) {
                Locale locale2 = localeArray[n];
                if (!locale.equals(locale2)) continue;
                return locale2;
            }
            String string = GridCoverageStore.getISO3Language(locale);
            if (string != null) {
                int n2 = localeArray.length;
                while (--n2 >= 0) {
                    Locale locale3 = localeArray[n2];
                    if (!string.equals(GridCoverageStore.getISO3Language(locale3))) continue;
                    return locale3;
                }
            }
        }
        return null;
    }

    private static String getISO3Language(Locale locale) {
        try {
            return locale.getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    final String formatErrorMessage(int n) {
        return Errors.getResources((Locale)this.locale).getString(n);
    }

    String formatErrorMessage(Throwable throwable) {
        return throwable.getLocalizedMessage();
    }

    final String formatErrorMessage(Object object, Throwable throwable, boolean bl) {
        String string = throwable.getLocalizedMessage();
        if (IOUtilities.canProcessAsPath((Object)object)) {
            String string2 = string;
            string = Errors.getResources((Locale)this.locale).getString(bl ? 42 : 31, (Object)IOUtilities.name((Object)object));
            if (string2 != null && string2.indexOf(32) > 0) {
                string = string + '\n' + string2;
            }
        }
        return string;
    }

    MathTransform2D geodeticToPixelCoordinates(GridGeometry2D gridGeometry2D, GridCoverageStoreParam gridCoverageStoreParam, IIOParam iIOParam) throws CoverageStoreException {
        MathTransform2D mathTransform2D;
        boolean bl = AxisRangeType.POSITIVE_LONGITUDE.indexIn(gridGeometry2D.getCoordinateReferenceSystem().getCoordinateSystem()) >= 0;
        try {
            mathTransform2D = this.geodeticToPixelCoordinates(gridGeometry2D, gridCoverageStoreParam.getValidEnvelope(bl), gridCoverageStoreParam.getResolution(), gridCoverageStoreParam.getCoordinateReferenceSystem(), iIOParam);
        }
        catch (CoverageStoreException coverageStoreException) {
            throw coverageStoreException;
        }
        catch (Exception exception) {
            throw new CoverageStoreException(this.formatErrorMessage(exception), exception);
        }
        return mathTransform2D;
    }

    private MathTransform2D geodeticToPixelCoordinates(GridGeometry2D gridGeometry2D, GeneralEnvelope generalEnvelope, double[] dArray, CoordinateReferenceSystem coordinateReferenceSystem, IIOParam iIOParam) throws InvalidGridGeometryException, TransformException, FactoryException, CoverageStoreException {
        int n;
        double d;
        double d2;
        boolean bl;
        boolean bl2;
        Envelope2D envelope2D;
        CoordinateReferenceSystem coordinateReferenceSystem2;
        CoordinateReferenceSystem coordinateReferenceSystem3;
        int n2;
        int n3;
        int n4;
        Object object;
        GridEnvelope2D gridEnvelope2D = gridGeometry2D.getExtent2D();
        MathTransform2D mathTransform2D = gridGeometry2D.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        MathTransform2D mathTransform2D2 = mathTransform2D.inverse();
        Shape shape = mathTransform2D.createTransformedShape((Shape)gridEnvelope2D);
        Rectangle2D rectangle2D = shape instanceof Rectangle2D ? (Rectangle2D)shape : shape.getBounds2D();
        this.ensureNonEmpty(rectangle2D);
        GeneralEnvelope generalEnvelope2 = generalEnvelope;
        MathTransform mathTransform = null;
        CoordinateReferenceSystem coordinateReferenceSystem4 = gridGeometry2D.getCoordinateReferenceSystem2D();
        if (coordinateReferenceSystem != null && coordinateReferenceSystem4 != null && !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem4)) {
            object = this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem4);
            mathTransform = object.getMathTransform();
            if (mathTransform.isIdentity()) {
                mathTransform = null;
            } else {
                generalEnvelope2 = Envelopes.transform((CoordinateOperation)object, (Envelope)generalEnvelope);
            }
        }
        if (generalEnvelope2 != null && !(object = XRectangle2D.createFromExtremums((double)generalEnvelope2.getMinimum(0), (double)generalEnvelope2.getMinimum(1), (double)generalEnvelope2.getMaximum(0), (double)generalEnvelope2.getMaximum(1))).contains(rectangle2D)) {
            object.intersect(rectangle2D);
            if (shape == rectangle2D || shape.contains((Rectangle2D)object)) {
                rectangle2D = object;
                shape = rectangle2D;
            } else {
                Area area = new Area(shape);
                area.intersect(new Area((Shape)object));
                shape = area;
                rectangle2D = shape.getBounds2D();
            }
            if (rectangle2D.isEmpty()) {
                throw new DisjointCoverageDomainException(this.formatErrorMessage(266));
            }
        }
        shape = mathTransform2D2 instanceof AffineTransform ? XAffineTransform.transform((AffineTransform)((AffineTransform)mathTransform2D2), (Shape)shape, (shape != rectangle2D ? 1 : 0) != 0) : mathTransform2D2.createTransformedShape(shape);
        object = shape instanceof RectangularShape ? (RectangularShape)shape : shape.getBounds2D();
        int n5 = gridEnvelope2D.width;
        int n6 = gridEnvelope2D.height;
        if (dArray != null) {
            double[] dArray2 = dArray;
            if (mathTransform != null) {
                double[] dArray3 = new double[mathTransform.getSourceDimensions()];
                dArray3[0] = ((RectangularShape)object).getCenterX();
                dArray3[1] = ((RectangularShape)object).getCenterY();
                mathTransform2D.transform(dArray3, 0, dArray3, 0, 1);
                mathTransform.inverse().transform(dArray3, 0, dArray3, 0, 1);
                dArray2 = CRS.deltaTransform((MathTransform)mathTransform, (DirectPosition)new GeneralDirectPosition(dArray3), (double[])dArray);
            }
            double d3 = dArray2[0] * (((RectangularShape)object).getWidth() / rectangle2D.getWidth());
            double d4 = dArray2[1] * (((RectangularShape)object).getHeight() / rectangle2D.getHeight());
            n4 = Math.max(1, Math.min(n5 / 4, (int)(d3 + 1.0E-5)));
            n3 = Math.max(1, Math.min(n6 / 4, (int)(d4 + 1.0E-5)));
        } else {
            n4 = 1;
            n3 = 1;
        }
        int n7 = (int)Math.floor(((RectangularShape)object).getMinX() + 1.0E-5);
        int n8 = (int)Math.floor(((RectangularShape)object).getMinY() + 1.0E-5);
        int n9 = (int)Math.ceil(((RectangularShape)object).getMaxX() - 1.0E-5);
        int n10 = (int)Math.ceil(((RectangularShape)object).getMaxY() - 1.0E-5);
        int n11 = n9 - n7;
        n11 = Math.max(4 * n4 - n11, n11 % n4 - 1);
        if (n11 > 0) {
            n2 = n11 & 1;
            n7 -= (n11 >>>= 1);
            n9 += n11 + n2;
        }
        n11 = n10 - n8;
        if ((n11 = Math.max(4 * n3 - n11, n11 % n3 - 1)) > 0) {
            n2 = n11 & 1;
            n8 -= (n11 >>>= 1);
            n10 += n11 + n2;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n9 > n5) {
            n9 = n5;
        }
        if (n10 > n6) {
            n10 = n6;
        }
        n5 = n9 - n7;
        n6 = n10 - n8;
        if (iIOParam != null) {
            iIOParam.setSourceRegion(new Rectangle(n7, n8, n5, n6));
            iIOParam.setSourceSubsampling(n4, n3, 0, 0);
        }
        if (this.ignoreGridTransforms) {
            return null;
        }
        if (generalEnvelope == null || dArray == null) {
            coordinateReferenceSystem3 = CRSUtilities.getCRS2D((CoordinateReferenceSystem)coordinateReferenceSystem);
            if (coordinateReferenceSystem3 == null) {
                coordinateReferenceSystem3 = coordinateReferenceSystem4;
            } else if (coordinateReferenceSystem4 != null && !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem4, (Object)coordinateReferenceSystem3)) {
                coordinateReferenceSystem2 = this.createOperation(coordinateReferenceSystem4, coordinateReferenceSystem3);
                rectangle2D = Envelopes.transform((CoordinateOperation)coordinateReferenceSystem2, (Rectangle2D)rectangle2D, (Rectangle2D)rectangle2D);
                this.ensureNonEmpty(rectangle2D);
            }
            envelope2D = new Envelope2D(coordinateReferenceSystem3, rectangle2D);
        } else {
            envelope2D = null;
        }
        if (generalEnvelope == null) {
            coordinateReferenceSystem3 = envelope2D;
        } else {
            coordinateReferenceSystem2 = coordinateReferenceSystem;
            if (coordinateReferenceSystem2 == null) {
                coordinateReferenceSystem2 = generalEnvelope.getDimension() == 2 ? coordinateReferenceSystem4 : gridGeometry2D.getCoordinateReferenceSystem();
            }
            generalEnvelope.setCoordinateReferenceSystem(coordinateReferenceSystem2);
            coordinateReferenceSystem3 = generalEnvelope;
            if (envelope2D != null) {
                XRectangle2D xRectangle2D = XRectangle2D.createFromExtremums((double)coordinateReferenceSystem3.getMinimum(0), (double)coordinateReferenceSystem3.getMinimum(1), (double)coordinateReferenceSystem3.getMaximum(0), (double)coordinateReferenceSystem3.getMaximum(1));
                xRectangle2D.intersect((Rectangle2D)envelope2D);
                envelope2D.setRect((Rectangle2D)xRectangle2D);
                this.ensureNonEmpty((Rectangle2D)envelope2D);
            }
        }
        if (coordinateReferenceSystem != null || coordinateReferenceSystem4 != null) {
            CoordinateSystem coordinateSystem = (coordinateReferenceSystem != null ? coordinateReferenceSystem : coordinateReferenceSystem4).getCoordinateSystem();
            bl2 = GridCoverageStore.isOpposite(coordinateSystem.getAxis(0).getDirection());
            bl = !GridCoverageStore.isOpposite(coordinateSystem.getAxis(1).getDirection());
        } else {
            bl2 = false;
            bl = true;
        }
        int n12 = coordinateReferenceSystem3.getDimension();
        XMatrix xMatrix = Matrices.create((int)(n12 + 1), (int)3);
        xMatrix.setElement(n12, 2, 1.0);
        int n13 = n12;
        while (--n13 >= 0) {
            double d5 = bl2 && n13 == 0 || bl && n13 == 1 ? coordinateReferenceSystem3.getMaximum(n13) : coordinateReferenceSystem3.getMinimum(n13);
            xMatrix.setElement(n13, 2, InternalUtilities.adjustForRoundingError((double)d5));
        }
        if (dArray != null) {
            d2 = dArray[0];
            d = dArray[1];
        } else {
            d2 = envelope2D.getSpan(0) / (double)n5;
            d = envelope2D.getSpan(1) / (double)n6;
        }
        if (bl2) {
            d2 = -d2;
        }
        if (bl) {
            d = -d;
        }
        d2 = InternalUtilities.adjustForRoundingError((double)d2);
        d = InternalUtilities.adjustForRoundingError((double)d);
        xMatrix.setElement(0, 0, d2);
        xMatrix.setElement(1, 1, d);
        LinearTransform linearTransform = MathTransforms.linear((Matrix)xMatrix);
        this.computeRequestedBounds((MathTransform)linearTransform, (Envelope)coordinateReferenceSystem3, coordinateReferenceSystem);
        if (mathTransform == null && (n = linearTransform.getTargetDimensions()) != 2) {
            mathTransform = MathTransforms.dimensionFilter((int)n, (int[])new int[]{0, 1});
        }
        if (mathTransform != null) {
            linearTransform = MathTransforms.concatenate((MathTransform)linearTransform, (MathTransform)mathTransform);
        }
        linearTransform = MathTransforms.concatenate((MathTransform)linearTransform, (MathTransform)mathTransform2D2);
        this.destGridToSource = linearTransform;
        if (n4 != 1 || n3 != 1 || n7 != 0 || n8 != 0) {
            d2 = 1.0 / (double)n4;
            d = 1.0 / (double)n3;
            linearTransform = MathTransforms.concatenate((MathTransform)linearTransform, (MathTransform)new AffineTransform2D(d2, 0.0, 0.0, d, (double)(-n7) / (double)n4, (double)(-n8) / (double)n3));
        }
        return (MathTransform2D)linearTransform;
    }

    void computeRequestedBounds(MathTransform mathTransform, Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException, CoverageStoreException {
    }

    private void ensureNonEmpty(Rectangle2D rectangle2D) throws CoverageStoreException {
        if (rectangle2D.isEmpty()) {
            throw new CoverageStoreException(this.formatErrorMessage(60));
        }
    }

    private CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        return CRS.getCoordinateOperationFactory((boolean)Boolean.TRUE.equals(this.hints.get((Object)Hints.LENIENT_DATUM_SHIFT))).createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    private static boolean isOpposite(AxisDirection axisDirection) {
        boolean bl = AxisDirections.isOpposite((AxisDirection)axisDirection);
        if (AxisDirection.ROW_POSITIVE.equals((Object)(axisDirection = AxisDirections.absolute((AxisDirection)axisDirection))) || AxisDirection.DISPLAY_DOWN.equals((Object)axisDirection)) {
            bl = !bl;
        }
        return bl;
    }

    static boolean isIdentity(MathTransform2D mathTransform2D) {
        return mathTransform2D == null || mathTransform2D.isIdentity() || mathTransform2D instanceof AffineTransform && XAffineTransform.isIdentity((AffineTransform)((AffineTransform)mathTransform2D), (double)1.0E-5);
    }

    public void abort() {
        this.abortRequested = true;
    }

    final void checkAbortState() throws CancellationException {
        if (this.abortRequested) {
            throw new CancellationException(this.formatErrorMessage(20));
        }
    }

    public void reset() throws CoverageStoreException {
        this.locale = null;
        this.destGridToSource = null;
        this.abortRequested = false;
    }

    public void dispose() throws CoverageStoreException {
        this.locale = null;
        this.destGridToSource = null;
        this.abortRequested = false;
    }
}

