/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import javax.media.jai.Warp;
import javax.media.jai.WarpPolynomial;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform2D;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.WarpAdapter;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class WarpTransform2D
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -7949539694656719923L;
    public static final int MAX_DEGREE = 7;
    private final Warp warp;
    private final WarpTransform2D inverse;

    public WarpTransform2D(Point2D[] point2DArray, Point2D[] point2DArray2, int n) {
        this(null, point2DArray, 0, null, point2DArray2, 0, Math.min(point2DArray.length, point2DArray2.length), n);
    }

    public WarpTransform2D(Rectangle2D rectangle2D, Point2D[] point2DArray, int n, Rectangle2D rectangle2D2, Point2D[] point2DArray2, int n2, int n3, int n4) {
        this(rectangle2D, WarpTransform2D.toFloat(point2DArray, n, n3), 0, rectangle2D2, WarpTransform2D.toFloat(point2DArray2, n2, n3), 0, n3, n4, false);
    }

    private static float[] toFloat(Point2D[] point2DArray, int n, int n2) {
        float[] fArray = new float[n2 * 2];
        int n3 = 0;
        while (n3 < fArray.length) {
            Point2D point2D = point2DArray[n++];
            fArray[n3++] = (float)point2D.getX();
            fArray[n3++] = (float)point2D.getY();
        }
        return fArray;
    }

    public WarpTransform2D(Rectangle2D rectangle2D, float[] fArray, int n, Rectangle2D rectangle2D2, float[] fArray2, int n2, int n3, int n4) {
        this(rectangle2D, fArray, n, rectangle2D2, fArray2, n2, n3, n4, true);
    }

    private WarpTransform2D(Rectangle2D rectangle2D, float[] fArray, int n, Rectangle2D rectangle2D2, float[] fArray2, int n2, int n3, int n4, boolean bl) {
        float f;
        float f2;
        float f3;
        float f4;
        if (rectangle2D != null) {
            f4 = (float)rectangle2D.getWidth();
            f3 = (float)rectangle2D.getHeight();
        } else {
            f4 = WarpTransform2D.getWidth(fArray, n, n3);
            f3 = WarpTransform2D.getWidth(fArray, n + 1, n3);
        }
        if (rectangle2D2 != null) {
            f2 = (float)rectangle2D2.getWidth();
            f = (float)rectangle2D2.getHeight();
        } else {
            f2 = WarpTransform2D.getWidth(fArray2, n2, n3);
            f = WarpTransform2D.getWidth(fArray2, n2 + 1, n3);
        }
        double d = f4 / f2;
        double d2 = f3 / f;
        if (d != 1.0 || d2 != 1.0) {
            int n5 = n3 * 2;
            if (bl) {
                fArray = Arrays.copyOfRange(fArray, n, n + n5);
                n = 0;
                fArray2 = Arrays.copyOfRange(fArray2, n2, n2 + n5);
                n2 = 0;
            }
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n + n6;
                fArray[n7] = (float)((double)fArray[n7] / d);
                int n8 = n2 + n6++;
                fArray2[n8] = (float)((double)fArray2[n8] * d);
                int n9 = n + n6;
                fArray[n9] = (float)((double)fArray[n9] / d2);
                int n10 = n2 + n6++;
                fArray2[n10] = (float)((double)fArray2[n10] * d2);
            }
        }
        this.warp = WarpPolynomial.createWarp((float[])fArray2, (int)n2, (float[])fArray, (int)n, (int)n3, (float)(1.0f / f4), (float)(1.0f / f3), (float)f2, (float)f, (int)n4);
        this.inverse = new WarpTransform2D((Warp)WarpPolynomial.createWarp((float[])fArray, (int)n, (float[])fArray2, (int)n2, (int)n3, (float)(1.0f / f2), (float)(1.0f / f), (float)f4, (float)f3, (int)n4), this);
    }

    private static float getWidth(float[] fArray, int n, int n2) {
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        while (--n2 >= 0) {
            float f3 = fArray[n];
            if (f3 < f) {
                f = f3;
            }
            if (f3 > f2) {
                f2 = f3;
            }
            n += 2;
        }
        return f2 - f;
    }

    protected WarpTransform2D(Warp warp, Warp warp2) {
        WarpTransform2D.ensureNonNull((String)"warp", (Object)warp);
        this.warp = warp;
        this.inverse = warp2 != null ? new WarpTransform2D(warp2, this) : null;
    }

    private WarpTransform2D(Warp warp, WarpTransform2D warpTransform2D) {
        this.warp = warp;
        this.inverse = warpTransform2D;
    }

    public static MathTransform2D create(Warp warp) {
        if (warp instanceof WarpAdapter) {
            return ((WarpAdapter)warp).getTransform();
        }
        return new WarpTransform2D(warp, (Warp)null);
    }

    public Warp getWarp() {
        return this.warp;
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.warp instanceof WarpPolynomial ? org.geotoolkit.referencing.operation.provider.WarpPolynomial.PARAMETERS : null;
    }

    public ParameterValueGroup getParameterValues() {
        if (this.warp instanceof WarpPolynomial) {
            WarpPolynomial warpPolynomial = (WarpPolynomial)this.warp;
            Object[] objectArray = new ParameterValue[7];
            int n = 0;
            objectArray[n++] = new Parameter(org.geotoolkit.referencing.operation.provider.WarpPolynomial.DEGREE, (Object)warpPolynomial.getDegree());
            objectArray[n++] = new Parameter(org.geotoolkit.referencing.operation.provider.WarpPolynomial.X_COEFFS, (Object)warpPolynomial.getXCoeffs());
            objectArray[n++] = new Parameter(org.geotoolkit.referencing.operation.provider.WarpPolynomial.Y_COEFFS, (Object)warpPolynomial.getYCoeffs());
            float f = warpPolynomial.getPreScaleX();
            if (f != 1.0f) {
                objectArray[n++] = new Parameter(org.geotoolkit.referencing.operation.provider.WarpPolynomial.PRE_SCALE_X, (Object)Float.valueOf(f));
            }
            if ((f = warpPolynomial.getPreScaleY()) != 1.0f) {
                objectArray[n++] = new Parameter(org.geotoolkit.referencing.operation.provider.WarpPolynomial.PRE_SCALE_Y, (Object)Float.valueOf(f));
            }
            if ((f = warpPolynomial.getPostScaleX()) != 1.0f) {
                objectArray[n++] = new Parameter(org.geotoolkit.referencing.operation.provider.WarpPolynomial.POST_SCALE_X, (Object)Float.valueOf(f));
            }
            if ((f = warpPolynomial.getPostScaleY()) != 1.0f) {
                objectArray[n++] = new Parameter(org.geotoolkit.referencing.operation.provider.WarpPolynomial.POST_SCALE_Y, (Object)Float.valueOf(f));
            }
            return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])ArraysExt.resize((Object[])objectArray, (int)n));
        }
        return null;
    }

    public boolean isIdentity() {
        return false;
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        point2D = new PointDouble(point2D.getX() - 0.5, point2D.getY() - 0.5);
        Point2D point2D3 = this.warp.mapDestPoint(point2D);
        point2D3.setLocation(point2D3.getX() + 0.5, point2D3.getY() + 0.5);
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D3);
        return point2D2;
    }

    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        Matrix matrix;
        Matrix matrix2 = matrix = bl ? this.derivative(new Point2D.Double(dArray[n], dArray[n + 1])) : null;
        if (dArray2 != null) {
            this.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4 = 0;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest((int)n, (int)2, (int)n2, (int)2, (int)n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * 2;
                    n2 += (n3 - 1) * 2;
                    n4 = -4;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * 2);
                    n = 0;
                }
            }
        }
        PointDouble pointDouble = new PointDouble();
        while (--n3 >= 0) {
            pointDouble.x = dArray[n++] - 0.5;
            pointDouble.y = dArray[n++] - 0.5;
            Point2D point2D = this.warp.mapDestPoint((Point2D)pointDouble);
            dArray2[n2++] = point2D.getX() + 0.5;
            dArray2[n2++] = point2D.getY() + 0.5;
            n2 += n4;
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4 = 0;
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest((int)n, (int)2, (int)n2, (int)2, (int)n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * 2;
                    n2 += (n3 - 1) * 2;
                    n4 = -4;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * 2);
                    n = 0;
                }
            }
        }
        PointFloat pointFloat = new PointFloat();
        while (--n3 >= 0) {
            pointFloat.x = fArray[n++] - 0.5f;
            pointFloat.y = fArray[n++] - 0.5f;
            Point2D point2D = this.warp.mapDestPoint((Point2D)pointFloat);
            fArray2[n2++] = (float)(point2D.getX() + 0.5);
            fArray2[n2++] = (float)(point2D.getY() + 0.5);
            n2 += n4;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        PointDouble pointDouble = new PointDouble();
        while (--n3 >= 0) {
            pointDouble.x = dArray[n++] - 0.5;
            pointDouble.y = dArray[n++] - 0.5;
            Point2D point2D = this.warp.mapDestPoint((Point2D)pointDouble);
            fArray[n2++] = (float)(point2D.getX() + 0.5);
            fArray[n2++] = (float)(point2D.getY() + 0.5);
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        PointDouble pointDouble = new PointDouble();
        while (--n3 >= 0) {
            pointDouble.x = (double)fArray[n++] - 0.5;
            pointDouble.y = (double)fArray[n++] - 0.5;
            Point2D point2D = this.warp.mapDestPoint((Point2D)pointDouble);
            dArray[n2++] = point2D.getX() + 0.5;
            dArray[n2++] = point2D.getY() + 0.5;
        }
    }

    public MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse != null) {
            return this.inverse;
        }
        return super.inverse();
    }

    protected int computeHashCode() {
        return Utilities.hash((Object)this.warp, (int)super.computeHashCode());
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            WarpTransform2D warpTransform2D = (WarpTransform2D)object;
            return Utilities.equals((Object)this.warp, (Object)warpTransform2D.warp);
        }
        return false;
    }

    private static final class PointDouble
    extends Point2D.Double {
        public PointDouble() {
        }

        public PointDouble(double d, double d2) {
            super(d, d2);
        }

        @Override
        public PointDouble clone() {
            return this;
        }
    }

    private static final class PointFloat
    extends Point2D.Float {
        private PointFloat() {
        }

        @Override
        public PointFloat clone() {
            return this;
        }
    }
}

