/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpGrid;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Cache;
import org.geotoolkit.display.shape.DoubleDimension2D;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.referencing.operation.transform.WarpAdapter;
import org.geotoolkit.referencing.operation.transform.WarpCache;
import org.geotoolkit.referencing.operation.transform.WarpKey;
import org.geotoolkit.referencing.operation.transform.WarpTransform2D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class WarpFactory {
    public static final WarpFactory DEFAULT = new WarpFactory(0.25);
    private static final int MIN_SIZE = 4;
    private static final double EPS = 1.1920929E-7;
    private final double tolerance;
    private final WarpCache cache;

    public WarpFactory(double d) {
        ArgumentChecks.ensurePositive((String)"tolerance", (double)d);
        this.tolerance = d;
        this.cache = new WarpCache();
    }

    private static double roundIfAlmostInteger(double d) {
        double d2 = Math.round(d);
        if (d2 != 0.0 && Math.abs(d2 - d) <= 1.1920929E-7) {
            return d2;
        }
        return d;
    }

    private static Warp create(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        XAffineTransform.roundIfAlmostInteger((AffineTransform)affineTransform2, (double)1.1920929E-7);
        return new WarpAffine(affineTransform2);
    }

    public Warp create(CharSequence charSequence, MathTransform2D mathTransform2D) {
        if (mathTransform2D instanceof WarpTransform2D) {
            return ((WarpTransform2D)mathTransform2D).getWarp();
        }
        if (mathTransform2D instanceof AffineTransform) {
            return WarpFactory.create((AffineTransform)mathTransform2D);
        }
        if (charSequence == null) {
            charSequence = Vocabulary.formatInternational((int)309);
        }
        return new WarpAdapter(charSequence, mathTransform2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Warp create(CharSequence charSequence, MathTransform2D mathTransform2D, Rectangle rectangle) throws TransformException {
        if (mathTransform2D instanceof WarpTransform2D) {
            return ((WarpTransform2D)mathTransform2D).getWarp();
        }
        if (mathTransform2D instanceof AffineTransform) {
            return WarpFactory.create((AffineTransform)mathTransform2D);
        }
        WarpKey warpKey = new WarpKey(mathTransform2D, rectangle);
        Warp warp = (Warp)this.cache.peek(warpKey);
        if (warp == null) {
            Cache.Handler handler = this.cache.lock(warpKey);
            try {
                warp = (Warp)handler.peek();
                if (warp == null) {
                    warp = this.create(charSequence, mathTransform2D, warpKey);
                }
            }
            finally {
                handler.putAndUnlock((Object)warp);
            }
        }
        return warp;
    }

    private Warp create(CharSequence charSequence, MathTransform2D mathTransform2D, WarpKey warpKey) throws TransformException {
        Dimension dimension;
        double d;
        Matrix2 matrix2;
        Matrix2 matrix22;
        Matrix2 matrix23;
        Matrix2 matrix24;
        double d2 = warpKey.getMinX();
        double d3 = warpKey.getMaxX();
        double d4 = warpKey.getMinY();
        double d5 = warpKey.getMaxY();
        Point2D.Double double_ = new Point2D.Double();
        try {
            double_.x = d2;
            double_.y = d5;
            matrix24 = WarpFactory.derivative(mathTransform2D, double_);
            double_.x = d3;
            double_.y = d5;
            matrix23 = WarpFactory.derivative(mathTransform2D, double_);
            double_.x = d2;
            double_.y = d4;
            matrix22 = WarpFactory.derivative(mathTransform2D, double_);
            double_.x = d3;
            double_.y = d4;
            matrix2 = WarpFactory.derivative(mathTransform2D, double_);
        }
        catch (TransformException transformException) {
            Logging.recoverableException(WarpFactory.class, (String)"create", (Throwable)transformException);
            return this.create(charSequence, mathTransform2D);
        }
        try {
            d = 2.0 * this.tolerance;
            dimension = WarpFactory.depth(mathTransform2D, double_, new DoubleDimension2D(d / (d3 - d2), d / (d5 - d4)), d2, d3, d4, d5, matrix24, matrix23, matrix22, matrix2);
        }
        catch (ArithmeticException arithmeticException) {
            Logging.recoverableException(WarpFactory.class, (String)"create", (Throwable)arithmeticException);
            return this.create(charSequence, mathTransform2D);
        }
        if (dimension.width == 0 && dimension.height == 0) {
            d = warpKey.getCenterX();
            double d6 = warpKey.getCenterY();
            double_.x = d3;
            double_.y = d6;
            Point2D point2D = mathTransform2D.transform((Point2D)double_, (Point2D)double_);
            double d7 = point2D.getX();
            double d8 = point2D.getY();
            double_.x = d2;
            double_.y = d6;
            point2D = mathTransform2D.transform((Point2D)double_, (Point2D)double_);
            d7 -= point2D.getX();
            d8 -= point2D.getY();
            double_.x = d;
            double_.y = d5;
            point2D = mathTransform2D.transform((Point2D)double_, (Point2D)double_);
            double d9 = point2D.getX();
            double d10 = point2D.getY();
            double_.x = d;
            double_.y = d4;
            point2D = mathTransform2D.transform((Point2D)double_, (Point2D)double_);
            d9 -= point2D.getX();
            d10 -= point2D.getY();
            double_.x = d;
            double_.y = d6;
            point2D = mathTransform2D.transform((Point2D)double_, (Point2D)double_);
            double d11 = warpKey.getWidth();
            double d12 = warpKey.getHeight();
            AffineTransform affineTransform = new AffineTransform(WarpFactory.roundIfAlmostInteger(d7 / d11), WarpFactory.roundIfAlmostInteger(d8 / d11), WarpFactory.roundIfAlmostInteger(d9 / d12), WarpFactory.roundIfAlmostInteger(d10 / d12), WarpFactory.roundIfAlmostInteger(point2D.getX()), WarpFactory.roundIfAlmostInteger(point2D.getY()));
            affineTransform.translate(-d, -d6);
            XAffineTransform.roundIfAlmostInteger((AffineTransform)affineTransform, (double)1.1920929E-7);
            return new WarpAffine(affineTransform);
        }
        int n = warpKey.width / (1 << dimension.width);
        int n2 = warpKey.height / (1 << dimension.height);
        int n3 = (warpKey.width + n - 1) / n;
        int n4 = (warpKey.height + n2 - 1) / n2;
        float[] fArray = new float[2 * (n3 + 1) * (n4 + 1)];
        int n5 = warpKey.x + n3 * n;
        int n6 = warpKey.y + n4 * n2;
        int n7 = 0;
        for (int i = warpKey.y; i <= n6; i += n2) {
            for (int j = warpKey.x; j <= n5; j += n) {
                fArray[n7++] = j;
                fArray[n7++] = i;
            }
        }
        mathTransform2D.transform(fArray, 0, fArray, 0, n7 / 2);
        return new WarpGrid(warpKey.x, n, n3, warpKey.y, n2, n4, fArray);
    }

    private static Dimension depth(MathTransform2D mathTransform2D, Point2D.Double double_, DoubleDimension2D doubleDimension2D, double d, double d2, double d3, double d4, Matrix2 matrix2, Matrix2 matrix22, Matrix2 matrix23, Matrix2 matrix24) throws TransformException, ArithmeticException {
        Dimension dimension;
        if (!(d2 - d >= 4.0) || !(d4 - d3 >= 4.0)) {
            throw new ArithmeticException(Errors.format((int)152));
        }
        double d5 = doubleDimension2D.width;
        double d6 = doubleDimension2D.height;
        doubleDimension2D.width *= 2.0;
        doubleDimension2D.height *= 2.0;
        double d7 = double_.x = 0.5 * (d + d2);
        double d8 = double_.y = 0.5 * (d3 + d4);
        Matrix2 matrix25 = WarpFactory.derivative(mathTransform2D, double_);
        double_.x = d;
        double_.y = d8;
        Matrix2 matrix26 = WarpFactory.derivative(mathTransform2D, double_);
        double_.x = d2;
        double_.y = d8;
        Matrix2 matrix27 = WarpFactory.derivative(mathTransform2D, double_);
        double_.x = d7;
        double_.y = d3;
        Matrix2 matrix28 = WarpFactory.derivative(mathTransform2D, double_);
        double_.x = d7;
        double_.y = d4;
        Matrix2 matrix29 = WarpFactory.derivative(mathTransform2D, double_);
        boolean bl = WarpFactory.equals(matrix25, matrix26, doubleDimension2D);
        boolean bl2 = WarpFactory.equals(matrix25, matrix27, doubleDimension2D);
        boolean bl3 = WarpFactory.equals(matrix25, matrix28, doubleDimension2D);
        boolean bl4 = WarpFactory.equals(matrix25, matrix29, doubleDimension2D);
        int n = 0;
        int n2 = 0;
        if (!(bl && bl4 && WarpFactory.equals(matrix25, matrix2, doubleDimension2D))) {
            dimension = WarpFactory.depth(mathTransform2D, double_, doubleDimension2D, d, d7, d8, d4, matrix2, matrix29, matrix26, matrix25);
            WarpFactory.incrementNonAffineDimension(bl, bl4, dimension);
            n = dimension.width;
            n2 = dimension.height;
        }
        if (!(bl2 && bl4 && WarpFactory.equals(matrix25, matrix22, doubleDimension2D))) {
            dimension = WarpFactory.depth(mathTransform2D, double_, doubleDimension2D, d7, d2, d8, d4, matrix29, matrix22, matrix25, matrix27);
            WarpFactory.incrementNonAffineDimension(bl2, bl4, dimension);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        if (!(bl && bl3 && WarpFactory.equals(matrix25, matrix23, doubleDimension2D))) {
            dimension = WarpFactory.depth(mathTransform2D, double_, doubleDimension2D, d, d7, d3, d8, matrix26, matrix25, matrix23, matrix28);
            WarpFactory.incrementNonAffineDimension(bl, bl3, dimension);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        if (!(bl2 && bl3 && WarpFactory.equals(matrix25, matrix24, doubleDimension2D))) {
            dimension = WarpFactory.depth(mathTransform2D, double_, doubleDimension2D, d7, d2, d3, d8, matrix25, matrix27, matrix28, matrix24);
            WarpFactory.incrementNonAffineDimension(bl2, bl3, dimension);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        doubleDimension2D.width = d5;
        doubleDimension2D.height = d6;
        return new Dimension(n, n2);
    }

    private static void incrementNonAffineDimension(boolean bl, boolean bl2, Dimension dimension) {
        if (bl == bl2) {
            ++dimension.width;
            ++dimension.height;
        } else if (bl2) {
            ++dimension.width;
        } else {
            ++dimension.height;
        }
    }

    private static Matrix2 derivative(MathTransform2D mathTransform2D, Point2D point2D) throws TransformException {
        Matrix matrix = mathTransform2D.derivative(point2D);
        return matrix instanceof Matrix2 ? (Matrix2)matrix : new Matrix2(matrix);
    }

    private static boolean equals(Matrix2 matrix2, Matrix2 matrix22, DoubleDimension2D doubleDimension2D) {
        return Math.abs(matrix2.m00 - matrix22.m00) <= doubleDimension2D.width && Math.abs(matrix2.m01 - matrix22.m01) <= doubleDimension2D.width && Math.abs(matrix2.m10 - matrix22.m10) <= doubleDimension2D.height && Math.abs(matrix2.m11 - matrix22.m11) <= doubleDimension2D.height;
    }
}

