/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.builder;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.grid.GridEnvelope2D;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public class GridToEnvelopeMapper {
    public static final int SWAP_XY = 1;
    public static final int REVERSE_AXIS = 2;
    private int defined;
    private GridEnvelope gridExtent;
    private Envelope envelope;
    private PixelInCell anchor = PixelInCell.CELL_CENTER;
    private Boolean swapXY;
    private boolean[] reverseAxis;
    private MathTransform transform;

    public GridToEnvelopeMapper() {
    }

    public GridToEnvelopeMapper(GridEnvelope gridEnvelope, Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"gridExtent", (Object)gridEnvelope);
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = gridEnvelope.getDimension();
        int n2 = envelope.getDimension();
        if (n2 != n) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n, (Object)n2));
        }
        this.gridExtent = gridEnvelope;
        this.envelope = envelope;
    }

    private static void ensureDimensionMatch(GridEnvelope gridEnvelope, Envelope envelope, boolean bl) {
        if (gridEnvelope != null && envelope != null) {
            int n;
            int n2;
            String string;
            if (bl) {
                string = "gridExtent";
                n2 = gridEnvelope.getDimension();
                n = envelope.getDimension();
            } else {
                string = "envelope";
                n2 = envelope.getDimension();
                n = gridEnvelope.getDimension();
            }
            if (n2 != n) {
                throw new MismatchedDimensionException(Errors.format((int)113, (Object)string, (Object)n2, (Object)n));
            }
        }
    }

    private void reset() {
        this.transform = null;
        if (this.isAutomatic(2)) {
            this.reverseAxis = null;
        }
        if (this.isAutomatic(1)) {
            this.swapXY = null;
        }
    }

    public PixelInCell getPixelAnchor() {
        return this.anchor;
    }

    public void setPixelAnchor(PixelInCell pixelInCell) {
        ArgumentChecks.ensureNonNull((String)"anchor", (Object)pixelInCell);
        if (!Utilities.equals((Object)this.anchor, (Object)pixelInCell)) {
            this.anchor = pixelInCell;
            this.reset();
        }
    }

    public GridEnvelope getGridExtent() throws IllegalStateException {
        if (this.gridExtent == null) {
            throw new IllegalStateException(Errors.format((int)120, (Object)"gridEnvelope"));
        }
        return this.gridExtent;
    }

    public void setGridExtent(GridEnvelope gridEnvelope) {
        ArgumentChecks.ensureNonNull((String)"extent", (Object)gridEnvelope);
        GridToEnvelopeMapper.ensureDimensionMatch(gridEnvelope, this.envelope, true);
        if (!Utilities.equals((Object)this.gridExtent, (Object)gridEnvelope)) {
            this.gridExtent = gridEnvelope;
            this.reset();
        }
    }

    public void setGridExtent(Rectangle rectangle) {
        GridEnvelope gridEnvelope;
        if (rectangle instanceof GridEnvelope) {
            gridEnvelope = (GridEnvelope)rectangle;
        } else {
            ArgumentChecks.ensureNonNull((String)"gridEnvelope", (Object)rectangle);
            gridEnvelope = new GridEnvelope2D(rectangle);
        }
        this.setGridExtent(gridEnvelope);
    }

    public void setGridExtent(int n, int n2, int n3, int n4) {
        this.setGridExtent(new GridEnvelope2D(n, n2, n3, n4));
    }

    public Envelope getEnvelope() throws IllegalStateException {
        if (this.envelope == null) {
            throw new IllegalStateException(Errors.format((int)120, (Object)"envelope"));
        }
        return this.envelope;
    }

    public void setEnvelope(Envelope envelope) {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        GridToEnvelopeMapper.ensureDimensionMatch(this.gridExtent, envelope, false);
        if (!Utilities.equals((Object)this.envelope, (Object)envelope)) {
            this.envelope = envelope;
            this.reset();
        }
    }

    public void setEnvelope(Rectangle2D rectangle2D) {
        Envelope envelope;
        if (rectangle2D instanceof Envelope) {
            envelope = (Envelope)rectangle2D;
        } else {
            ArgumentChecks.ensureNonNull((String)"envelope", (Object)rectangle2D);
            envelope = new Envelope2D(null, rectangle2D);
        }
        this.setEnvelope(envelope);
    }

    public void setEnvelope(double d, double d2, double d3, double d4) {
        this.setEnvelope((Envelope)new Envelope2D(null, d, d2, d3, d4));
    }

    private static boolean swapXY(CoordinateSystem coordinateSystem) {
        if (coordinateSystem != null && coordinateSystem.getDimension() >= 2) {
            return AxisDirection.NORTH.equals((Object)AxisDirections.absolute((AxisDirection)coordinateSystem.getAxis(0).getDirection())) && AxisDirection.EAST.equals((Object)AxisDirections.absolute((AxisDirection)coordinateSystem.getAxis(1).getDirection()));
        }
        return false;
    }

    public boolean getSwapXY() {
        if (this.swapXY == null) {
            boolean bl = false;
            if (this.isAutomatic(1)) {
                bl = GridToEnvelopeMapper.swapXY(this.getCoordinateSystem());
            }
            this.swapXY = bl;
        }
        return this.swapXY;
    }

    public void setSwapXY(boolean bl) {
        Boolean bl2 = bl;
        if (!bl2.equals(this.swapXY)) {
            this.reset();
        }
        this.swapXY = bl2;
        this.defined |= 1;
    }

    public boolean[] getReverseAxis() {
        if (this.reverseAxis == null) {
            CoordinateSystem coordinateSystem = this.getCoordinateSystem();
            if (coordinateSystem != null) {
                int n = coordinateSystem.getDimension();
                this.reverseAxis = new boolean[n];
                if (this.isAutomatic(2)) {
                    int n2;
                    for (n2 = 0; n2 < n; ++n2) {
                        this.reverseAxis[n2] = AxisDirections.isOpposite((AxisDirection)coordinateSystem.getAxis(n2).getDirection());
                    }
                    if (n >= 2) {
                        n2 = this.getSwapXY() ? 0 : 1;
                        this.reverseAxis[n2] = !this.reverseAxis[n2];
                    }
                }
            } else {
                int n = 0;
                if (this.gridExtent != null) {
                    n = this.gridExtent.getDimension();
                } else if (this.envelope != null) {
                    n = this.envelope.getDimension();
                }
                if (n >= 2) {
                    this.reverseAxis = new boolean[n];
                    this.reverseAxis[1] = true;
                }
            }
        }
        return this.reverseAxis != null ? (boolean[])this.reverseAxis.clone() : null;
    }

    public void setReverseAxis(boolean[] blArray) {
        if (blArray != null) {
            blArray = (boolean[])blArray.clone();
        }
        if (!Arrays.equals(this.reverseAxis, blArray)) {
            this.reset();
        }
        this.reverseAxis = blArray;
        this.defined |= 2;
    }

    public void reverseAxis(int n) {
        if (this.reverseAxis == null) {
            int n2;
            if (this.gridExtent != null) {
                n2 = this.gridExtent.getDimension();
            } else {
                ArgumentChecks.ensureNonNull((String)"envelope", (Object)this.envelope);
                n2 = this.envelope.getDimension();
            }
            this.reverseAxis = new boolean[n2];
        }
        if (!this.reverseAxis[n]) {
            this.reset();
        }
        this.reverseAxis[n] = true;
        this.defined |= 2;
    }

    public boolean isAutomatic(int n) {
        return (this.defined & n) == 0;
    }

    public void setAutomatic(int n) {
        this.defined &= ~n;
    }

    private CoordinateSystem getCoordinateSystem() {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (this.envelope != null && (coordinateReferenceSystem = this.envelope.getCoordinateReferenceSystem()) != null) {
            return coordinateReferenceSystem.getCoordinateSystem();
        }
        return null;
    }

    public MathTransform createTransform() throws IllegalStateException {
        if (this.transform == null) {
            double d;
            GridEnvelope gridEnvelope = this.getGridExtent();
            Envelope envelope = this.getEnvelope();
            boolean bl = this.getSwapXY();
            boolean[] blArray = this.getReverseAxis();
            PixelInCell pixelInCell = this.getPixelAnchor();
            int n = gridEnvelope.getDimension();
            if (PixelInCell.CELL_CENTER.equals((Object)pixelInCell)) {
                d = 0.5;
            } else if (PixelInCell.CELL_CORNER.equals((Object)pixelInCell)) {
                d = 0.0;
            } else {
                throw new IllegalStateException(Errors.format((int)73, (Object)"gridType", (Object)pixelInCell));
            }
            XMatrix xMatrix = Matrices.create((int)(n + 1));
            for (int i = 0; i < n; ++i) {
                double d2;
                int n2 = i;
                if (bl && n2 <= 1) {
                    n2 = 1 - n2;
                }
                double d3 = envelope.getSpan(n2) / (double)gridEnvelope.getSpan(i);
                if (blArray == null || n2 >= blArray.length || !blArray[n2]) {
                    d2 = envelope.getMinimum(n2);
                } else {
                    d3 = -d3;
                    d2 = envelope.getMaximum(n2);
                }
                xMatrix.setElement(n2, n2, 0.0);
                xMatrix.setElement(n2, i, d3);
                xMatrix.setElement(n2, n, d2 -= d3 * ((double)gridEnvelope.getLow(i) - d));
            }
            this.transform = MathTransforms.linear((Matrix)xMatrix);
        }
        return this.transform;
    }

    public AffineTransform createAffineTransform() throws IllegalStateException {
        MathTransform mathTransform = this.createTransform();
        if (mathTransform instanceof AffineTransform) {
            return (AffineTransform)mathTransform;
        }
        throw new IllegalStateException(Errors.format((int)140));
    }
}

