/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Arrays;
import java.util.List;
import org.geotoolkit.referencing.cs.DiscreteCRS;
import org.geotoolkit.referencing.cs.DiscreteCS;
import org.geotoolkit.referencing.cs.DiscreteCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DiscreteReferencingFactory;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class DiscreteCompoundCRS
extends DiscreteCRS<CompoundCRS>
implements CompoundCRS {
    private static final long serialVersionUID = -4292250243969805179L;
    private final List<CoordinateReferenceSystem> components;

    private DiscreteCompoundCRS(CompoundCRS compoundCRS, DiscreteCS discreteCS, CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        super(compoundCRS, discreteCS);
        this.components = UnmodifiableArrayList.wrap((Object[])coordinateReferenceSystemArray);
    }

    public List<CoordinateReferenceSystem> getComponents() {
        return this.components;
    }

    static CompoundCRS create(CompoundCRS compoundCRS, double[] ... dArray) {
        int n;
        int n2;
        CoordinateSystem coordinateSystem;
        int n3;
        List list = compoundCRS.getComponents();
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[list.size()];
        CoordinateSystem coordinateSystem2 = compoundCRS.getCoordinateSystem();
        boolean bl = false;
        int n4 = 0;
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)list.get(i);
            n3 = n4 + coordinateReferenceSystem.getCoordinateSystem().getDimension();
            coordinateReferenceSystemArray[i] = DiscreteReferencingFactory.createDiscreteCRS(coordinateReferenceSystem, (double[][])Arrays.copyOfRange(dArray, n4, n3));
            if (!bl) {
                if (coordinateReferenceSystemArray[i] != coordinateReferenceSystem) {
                    bl = true;
                } else {
                    coordinateSystem = coordinateReferenceSystemArray[i].getCoordinateSystem();
                    n2 = coordinateSystem.getDimension();
                    for (n = 0; n < n2; ++n) {
                        if (coordinateSystem.getAxis(n).equals(coordinateSystem2.getAxis(n4 + n))) continue;
                        bl = true;
                        break;
                    }
                }
            }
            n4 = n3;
        }
        if (!bl) {
            return compoundCRS;
        }
        DiscreteCoordinateSystemAxis[] discreteCoordinateSystemAxisArray = new DiscreteCoordinateSystemAxis[coordinateSystem2.getDimension()];
        int n5 = 0;
        for (n3 = 0; n3 < coordinateReferenceSystemArray.length; ++n3) {
            coordinateSystem = coordinateReferenceSystemArray[n3].getCoordinateSystem();
            n2 = coordinateSystem.getDimension();
            for (n = 0; n < n2; ++n) {
                if (n5 < discreteCoordinateSystemAxisArray.length) {
                    discreteCoordinateSystemAxisArray[n5] = (DiscreteCoordinateSystemAxis)coordinateSystem.getAxis(n);
                }
                ++n5;
            }
        }
        if (n5 != discreteCoordinateSystemAxisArray.length) {
            throw new IllegalArgumentException(Errors.format((int)112, (Object)discreteCoordinateSystemAxisArray.length, (Object)n5));
        }
        return new DiscreteCompoundCRS(compoundCRS, new DiscreteCS(coordinateSystem2, discreteCoordinateSystemAxisArray), coordinateReferenceSystemArray);
    }

    @Override
    public synchronized MathTransform getGridToCRS() {
        if (this.gridToCRS == null) {
            this.gridToCRS = MathTransforms.linear((Matrix)DiscreteReferencingFactory.getAffineTransform(this, this.cs.axes));
        }
        return this.gridToCRS;
    }
}

