/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.referencing.cs.DiscreteCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DiscreteReferencingFactory;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

class DiscreteCS
implements CoordinateSystem,
GridGeometry,
Serializable {
    private static final long serialVersionUID = -6368259804288288946L;
    protected final CoordinateSystem cs;
    protected final DiscreteCoordinateSystemAxis<?>[] axes;
    private transient GridEnvelope extent;
    private transient MathTransform gridToCRS;

    DiscreteCS(CoordinateSystem coordinateSystem, double[] ... dArray) throws IllegalArgumentException {
        this.cs = coordinateSystem;
        int n = coordinateSystem.getDimension();
        if (n != dArray.length) {
            throw new IllegalArgumentException(Errors.format((int)113, (Object)"ordinates", (Object)dArray.length, (Object)n));
        }
        this.axes = new DiscreteCoordinateSystemAxis[n];
        for (int i = 0; i < n; ++i) {
            this.axes[i] = DiscreteReferencingFactory.createDiscreteAxis(coordinateSystem.getAxis(i), dArray[i]);
        }
    }

    DiscreteCS(CoordinateSystem coordinateSystem, DiscreteCoordinateSystemAxis<?> ... discreteCoordinateSystemAxisArray) {
        this.cs = coordinateSystem;
        this.axes = discreteCoordinateSystemAxisArray;
    }

    public final ReferenceIdentifier getName() {
        return this.cs.getName();
    }

    public final Collection<GenericName> getAlias() {
        return this.cs.getAlias();
    }

    public final Set<ReferenceIdentifier> getIdentifiers() {
        return this.cs.getIdentifiers();
    }

    public final int getDimension() {
        return this.axes.length;
    }

    public final CoordinateSystemAxis getAxis(int n) throws IndexOutOfBoundsException {
        return (CoordinateSystemAxis)this.axes[n];
    }

    public final synchronized GridEnvelope getExtent() {
        if (this.extent == null) {
            int[] nArray = new int[this.axes.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.axes[i].length();
            }
            this.extent = new GeneralGridEnvelope(new int[nArray.length], nArray, false);
        }
        return this.extent;
    }

    @Deprecated
    public final GridEnvelope getGridRange() {
        return this.getExtent();
    }

    public final synchronized MathTransform getGridToCRS() {
        if (this.gridToCRS == null) {
            this.gridToCRS = this.getGridToCRS(null);
        }
        return this.gridToCRS;
    }

    final MathTransform getGridToCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        XMatrix xMatrix = DiscreteReferencingFactory.getAffineTransform(coordinateReferenceSystem, this.axes);
        if (xMatrix == null) {
            throw new UnsupportedOperationException(Errors.format((int)140));
        }
        return MathTransforms.linear((Matrix)xMatrix);
    }

    public final InternationalString getRemarks() {
        return this.cs.getRemarks();
    }

    public final String toWKT() throws UnsupportedOperationException {
        return this.cs.toWKT();
    }

    public final String toString() {
        return this.cs.toString();
    }

    public final int hashCode() {
        return this.cs.hashCode() + 31 * Arrays.hashCode(this.axes);
    }

    public final boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DiscreteCS discreteCS = (DiscreteCS)object;
            return this.cs.equals(discreteCS.cs) && Arrays.equals(this.axes, discreteCS.axes);
        }
        return false;
    }

    static final class Time
    extends DiscreteCS
    implements TimeCS {
        private static final long serialVersionUID = -879676008647755725L;

        Time(TimeCS timeCS, double[] ... dArray) throws IllegalArgumentException {
            super((CoordinateSystem)timeCS, dArray);
        }
    }

    static final class Vertical
    extends DiscreteCS
    implements VerticalCS {
        private static final long serialVersionUID = 2486019427140923781L;

        Vertical(VerticalCS verticalCS, double[] ... dArray) throws IllegalArgumentException {
            super((CoordinateSystem)verticalCS, dArray);
        }
    }

    static final class Ellipsoidal
    extends DiscreteCS
    implements EllipsoidalCS {
        private static final long serialVersionUID = -847574453071413273L;

        Ellipsoidal(EllipsoidalCS ellipsoidalCS, double[] ... dArray) throws IllegalArgumentException {
            super((CoordinateSystem)ellipsoidalCS, dArray);
        }
    }

    static final class Cartesian
    extends DiscreteCS
    implements CartesianCS {
        private static final long serialVersionUID = -6589829160460750116L;

        Cartesian(CartesianCS cartesianCS, double[] ... dArray) throws IllegalArgumentException {
            super((CoordinateSystem)cartesianCS, dArray);
        }
    }
}

