/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.cs.DiscreteCS;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

class DiscreteCRS<T extends CoordinateReferenceSystem>
extends FormattableObject
implements CoordinateReferenceSystem,
GridGeometry,
Serializable {
    private static final long serialVersionUID = -6401567052946218355L;
    protected final T crs;
    protected final DiscreteCS cs;
    transient MathTransform gridToCRS;

    DiscreteCRS(T t, DiscreteCS discreteCS) {
        this.crs = t;
        this.cs = discreteCS;
    }

    public final ReferenceIdentifier getName() {
        return this.crs.getName();
    }

    public final Collection<GenericName> getAlias() {
        return this.crs.getAlias();
    }

    public final Set<ReferenceIdentifier> getIdentifiers() {
        return this.crs.getIdentifiers();
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public final GridEnvelope getExtent() {
        return this.cs.getExtent();
    }

    @Deprecated
    public final GridEnvelope getGridRange() {
        return this.cs.getGridRange();
    }

    public synchronized MathTransform getGridToCRS() {
        if (this.gridToCRS == null) {
            this.gridToCRS = this.cs.getGridToCRS(this);
        }
        return this.gridToCRS;
    }

    public final Extent getDomainOfValidity() {
        return this.crs.getDomainOfValidity();
    }

    public final InternationalString getScope() {
        return this.crs.getScope();
    }

    public final InternationalString getRemarks() {
        return this.crs.getRemarks();
    }

    public String formatWKT(Formatter formatter) {
        if (this.crs instanceof FormattableObject) {
            return ((FormattableObject)this.crs).formatWKT(formatter);
        }
        return super.formatWKT(formatter);
    }

    public final String toWKT() throws UnsupportedOperationException {
        return this.crs.toWKT();
    }

    public final String toString() {
        return this.crs.toString();
    }

    public final int hashCode() {
        return this.crs.hashCode() + 31 * this.cs.hashCode();
    }

    public final boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DiscreteCRS discreteCRS = (DiscreteCRS)object;
            return this.crs.equals(discreteCRS.crs) && this.cs.equals(discreteCRS.cs);
        }
        return false;
    }

    static final class Single
    extends DiscreteCRS<SingleCRS>
    implements SingleCRS {
        private static final long serialVersionUID = 1616462096697283316L;

        Single(SingleCRS singleCRS, double[] ... dArray) {
            super(singleCRS, new DiscreteCS(singleCRS.getCoordinateSystem(), dArray));
        }

        public Datum getDatum() {
            return ((SingleCRS)this.crs).getDatum();
        }
    }

    static final class Temporal
    extends DiscreteCRS<TemporalCRS>
    implements TemporalCRS {
        private static final long serialVersionUID = -4154329164568410034L;

        Temporal(TemporalCRS temporalCRS, double[] ... dArray) {
            super(temporalCRS, new DiscreteCS.Time(temporalCRS.getCoordinateSystem(), dArray));
        }

        public TimeCS getCoordinateSystem() {
            return (TimeCS)this.cs;
        }

        public TemporalDatum getDatum() {
            return ((TemporalCRS)this.crs).getDatum();
        }
    }

    static final class Vertical
    extends DiscreteCRS<VerticalCRS>
    implements VerticalCRS {
        private static final long serialVersionUID = -4037988222135517657L;

        Vertical(VerticalCRS verticalCRS, double[] ... dArray) {
            super(verticalCRS, new DiscreteCS.Vertical(verticalCRS.getCoordinateSystem(), dArray));
        }

        public VerticalCS getCoordinateSystem() {
            return (VerticalCS)this.cs;
        }

        public VerticalDatum getDatum() {
            return ((VerticalCRS)this.crs).getDatum();
        }
    }

    static final class Projected
    extends DiscreteCRS<ProjectedCRS>
    implements ProjectedCRS {
        private static final long serialVersionUID = 7468800070780104601L;

        Projected(ProjectedCRS projectedCRS, double[] ... dArray) {
            super(projectedCRS, new DiscreteCS.Cartesian(projectedCRS.getCoordinateSystem(), dArray));
        }

        public CartesianCS getCoordinateSystem() {
            return (CartesianCS)this.cs;
        }

        public GeodeticDatum getDatum() {
            return ((ProjectedCRS)this.crs).getDatum();
        }

        public GeographicCRS getBaseCRS() {
            return ((ProjectedCRS)this.crs).getBaseCRS();
        }

        public Projection getConversionFromBase() {
            return ((ProjectedCRS)this.crs).getConversionFromBase();
        }
    }

    static final class Geographic
    extends DiscreteCRS<GeographicCRS>
    implements GeographicCRS {
        private static final long serialVersionUID = -6614621727541494429L;

        Geographic(GeographicCRS geographicCRS, double[] ... dArray) {
            super(geographicCRS, new DiscreteCS.Ellipsoidal(geographicCRS.getCoordinateSystem(), dArray));
        }

        public EllipsoidalCS getCoordinateSystem() {
            return (EllipsoidalCS)this.cs;
        }

        public GeodeticDatum getDatum() {
            return ((GeographicCRS)this.crs).getDatum();
        }
    }
}

