/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.awt.image.RenderedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.util.Range;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.parameter.ImagingParameterDescription;
import org.geotoolkit.parameter.ImagingParameters;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

@Immutable
public class ImagingParameterDescriptors
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = 2127050865911951239L;
    private static final Object[] AUTHORITIES = new Object[]{"com.sun.media.jai", Citations.JAI, "org.geotoolkit", Citations.GEOTOOLKIT};
    private static NameFactory nameFactory;
    public static final Map<Class<?>, Class<?>> DEFAULT_SOURCE_TYPE_MAP;
    protected final String registryMode;
    protected final RegistryElementDescriptor operation;
    protected final ParameterListDescriptor descriptor;

    public ImagingParameterDescriptors(RegistryElementDescriptor registryElementDescriptor) {
        this(ImagingParameterDescriptors.properties(registryElementDescriptor), registryElementDescriptor, "rendered", DEFAULT_SOURCE_TYPE_MAP, null);
    }

    public ImagingParameterDescriptors(RegistryElementDescriptor registryElementDescriptor, Collection<ParameterDescriptor<?>> collection) {
        this(ImagingParameterDescriptors.properties(registryElementDescriptor), registryElementDescriptor, "rendered", DEFAULT_SOURCE_TYPE_MAP, collection);
    }

    public ImagingParameterDescriptors(Map<String, ?> map, RegistryElementDescriptor registryElementDescriptor, String string, Map<Class<?>, Class<?>> map2, Collection<ParameterDescriptor<?>> collection) {
        this(map, registryElementDescriptor.getParameterListDescriptor(string), registryElementDescriptor, string, map2, collection);
    }

    public ImagingParameterDescriptors(Map<String, ?> map, ParameterListDescriptor parameterListDescriptor) {
        this(map, parameterListDescriptor, null, null, null, null);
    }

    private ImagingParameterDescriptors(Map<String, ?> map, ParameterListDescriptor parameterListDescriptor, RegistryElementDescriptor registryElementDescriptor, String string, Map<Class<?>, Class<?>> map2, Collection<ParameterDescriptor<?>> collection) {
        super(map, 1, 1, ImagingParameterDescriptors.asDescriptors(parameterListDescriptor, registryElementDescriptor, string, map2, collection));
        this.descriptor = parameterListDescriptor;
        this.operation = registryElementDescriptor;
        this.registryMode = string;
    }

    public static Map<String, Object> properties(RegistryElementDescriptor registryElementDescriptor) {
        String string = registryElementDescriptor.getName();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (registryElementDescriptor instanceof OperationDescriptor) {
            DefaultCitation defaultCitation;
            DefaultOnlineResource defaultOnlineResource;
            Object object;
            OperationDescriptor operationDescriptor = (OperationDescriptor)registryElementDescriptor;
            ResourceBundle resourceBundle = operationDescriptor.getResourceBundle(Locale.getDefault());
            String string2 = operationDescriptor.getResourceBundle(Locale.US).getString("Vendor");
            Citation citation = null;
            if (string2 != null) {
                string2 = string2.trim();
                string = ImagingParameterDescription.trimPrefix(string, string2);
                for (int i = 0; i < AUTHORITIES.length; i += 2) {
                    if (!string2.equalsIgnoreCase((String)AUTHORITIES[i])) continue;
                    citation = (Citation)AUTHORITIES[i + 1];
                    break;
                }
            }
            ImagingParameterDescription imagingParameterDescription = new ImagingParameterDescription(operationDescriptor, "Description", null);
            if (citation != null) {
                try {
                    ResponsibleParty responsibleParty;
                    object = new URI(IOUtilities.encodeURI((String)resourceBundle.getString("DocURL")));
                    defaultOnlineResource = new DefaultOnlineResource((URI)object);
                    defaultOnlineResource.setFunction(OnLineFunction.INFORMATION);
                    defaultOnlineResource.setDescription((InternationalString)imagingParameterDescription);
                    defaultCitation = new DefaultCitation(citation);
                    Collection collection = defaultCitation.getCitedResponsibleParties();
                    DefaultResponsibleParty defaultResponsibleParty = collection.iterator();
                    if (defaultResponsibleParty.hasNext()) {
                        responsibleParty = (ResponsibleParty)defaultResponsibleParty.next();
                        defaultResponsibleParty.remove();
                    } else {
                        responsibleParty = null;
                    }
                    defaultResponsibleParty = new DefaultResponsibleParty(responsibleParty);
                    defaultResponsibleParty.setRole(Role.RESOURCE_PROVIDER);
                    defaultResponsibleParty.setContactInfo((Contact)new DefaultContact((OnlineResource)defaultOnlineResource));
                    collection.add(defaultResponsibleParty);
                    defaultCitation.freeze();
                    citation = defaultCitation;
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            object = ImagingParameterDescriptors.getNameFactory();
            defaultOnlineResource = object.createNameSpace((GenericName)object.createLocalName(null, (CharSequence)((Object)new ImagingParameterDescription(operationDescriptor, "Vendor", null))), Collections.singletonMap("separator", "."));
            defaultCitation = object.createLocalName((NameSpace)defaultOnlineResource, (CharSequence)((Object)new ImagingParameterDescription(operationDescriptor, "LocalName", "Vendor")));
            hashMap.put("alias", defaultCitation);
            hashMap.put("remarks", imagingParameterDescription);
            hashMap.put("version", resourceBundle.getString("Version"));
            hashMap.put("authority", citation);
        }
        hashMap.put("name", string);
        return hashMap;
    }

    private static ParameterDescriptor<?>[] asDescriptors(ParameterListDescriptor parameterListDescriptor, RegistryElementDescriptor registryElementDescriptor, String string, Map<Class<?>, Class<?>> map, Collection<ParameterDescriptor<?>> collection) {
        Object object6;
        Object object2;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        Object[] objectArray3;
        String[] stringArray;
        Object object3;
        if (parameterListDescriptor == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"descriptor"));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (collection != null) {
            for (ParameterDescriptor<?> parameterDescriptor : collection) {
                object3 = parameterDescriptor.getName().getCode().trim().toLowerCase();
                if (linkedHashMap.put(object3, parameterDescriptor) == null) continue;
                throw new InvalidParameterNameException(Errors.format((int)55, (Object)object3), (String)object3);
            }
        }
        int n3 = parameterListDescriptor.getNumParameters();
        object3 = new HashMap();
        if (registryElementDescriptor instanceof OperationDescriptor) {
            stringArray = (String[])registryElementDescriptor;
            objectArray3 = stringArray.getSourceNames();
            objectArray2 = stringArray.getSourceClasses(string);
            n2 = stringArray.getNumSources();
            objectArray = new ParameterDescriptor[n3 + n2];
            for (n = 0; n < n2; ++n) {
                char c;
                int n4;
                object2 = map.get(objectArray2[n]);
                if (object2 == null) {
                    object2 = objectArray2[n];
                }
                object6 = objectArray3[n];
                object3.clear();
                if (n2 == 1 && (n4 = ((String)object6).length()) != 0 && ((c = ((String)object6).charAt(n4 - 1)) == '0' || c == '1')) {
                    object3.put("alias", object6);
                    object6 = ((String)object6).substring(0, n4 - 1);
                }
                object3.put("name", object6);
                objectArray[n] = ImagingParameterDescriptors.descriptor(object3, object2, null, null, null, null);
            }
        } else {
            n2 = 0;
            objectArray = new ParameterDescriptor[n3];
        }
        stringArray = parameterListDescriptor.getParamNames();
        objectArray3 = parameterListDescriptor.getParamClasses();
        objectArray2 = parameterListDescriptor.getParamDefaults();
        for (n = 0; n < n3; ++n) {
            ImagingParameterDescription imagingParameterDescription;
            Object object4;
            EnumeratedParameter[] enumeratedParameterArray;
            Comparable comparable;
            Comparable comparable2;
            object2 = stringArray[n];
            object6 = (ParameterDescriptor)linkedHashMap.remove(((String)object2).trim().toLowerCase());
            if (object6 != null) {
                objectArray[n + n2] = object6;
                continue;
            }
            Object object5 = objectArray3[n];
            Range range = parameterListDescriptor.getParamValueRange((String)object2);
            if (range != null) {
                comparable2 = range.getMinValue();
                comparable = range.getMaxValue();
            } else {
                comparable2 = null;
                comparable = null;
            }
            if (EnumeratedParameter.class.isAssignableFrom((Class<?>)object5)) {
                try {
                    enumeratedParameterArray = parameterListDescriptor.getEnumeratedParameterValues((String)object2);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    enumeratedParameterArray = null;
                }
            } else {
                enumeratedParameterArray = null;
            }
            if ((object4 = objectArray2[n]) == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
                object4 = null;
            }
            object3.clear();
            object3.put("name", object2);
            if (registryElementDescriptor instanceof OperationDescriptor && (imagingParameterDescription = new ImagingParameterDescription((OperationDescriptor)registryElementDescriptor, n)).exists()) {
                object3.put("remarks", imagingParameterDescription);
            }
            objectArray[n + n2] = ImagingParameterDescriptors.descriptor(object3, object5, enumeratedParameterArray, object4, comparable2, comparable);
        }
        n = objectArray.length;
        objectArray = (ParameterDescriptor[])ArraysExt.resize((Object[])objectArray, (int)(n + linkedHashMap.size()));
        for (Object object6 : linkedHashMap.values()) {
            objectArray[n++] = object6;
        }
        return objectArray;
    }

    private static ParameterDescriptor<?> descriptor(Map<String, ?> map, Class<?> clazz, EnumeratedParameter[] enumeratedParameterArray, Object object, Comparable<?> comparable, Comparable<?> comparable2) {
        return new DefaultParameterDescriptor(map, clazz, (Object[])enumeratedParameterArray, object, comparable, comparable2, null, true);
    }

    private static NameFactory getNameFactory() {
        NameFactory nameFactory = ImagingParameterDescriptors.nameFactory;
        if (nameFactory == null) {
            ImagingParameterDescriptors.nameFactory = nameFactory = FactoryFinder.getNameFactory(null);
        }
        return nameFactory;
    }

    public ParameterValueGroup createValue() {
        return new ImagingParameters(this);
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImagingParameterDescriptors && super.equals(object, comparisonMode)) {
            ImagingParameterDescriptors imagingParameterDescriptors = (ImagingParameterDescriptors)((Object)object);
            return Utilities.equals((Object)this.operation, (Object)imagingParameterDescriptors.operation) && Utilities.equals((Object)this.descriptor, (Object)imagingParameterDescriptors.descriptor);
        }
        return false;
    }

    protected int computeHashCode() {
        return Utilities.hash((Object)this.descriptor, (int)super.computeHashCode());
    }

    static {
        Factories.addChangeListener((ChangeListener)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ImagingParameterDescriptors.nameFactory = null;
            }
        });
        DEFAULT_SOURCE_TYPE_MAP = Collections.singletonMap(RenderedImage.class, GridCoverage.class);
    }
}

