/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.media.jai.OperationDescriptor;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.AbstractInternationalString;
import org.geotoolkit.util.Utilities;

@Immutable
final class ImagingParameterDescription
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = -325584046563057577L;
    private static final String[] argumentKeys = new String[12];
    private final OperationDescriptor operation;
    private final String key;
    private final String prefixKey;

    public ImagingParameterDescription(OperationDescriptor operationDescriptor, int n) {
        String string;
        this.operation = operationDescriptor;
        this.prefixKey = null;
        if (n < argumentKeys.length && (string = argumentKeys[n]) != null) {
            this.key = string;
            return;
        }
        this.key = "arg" + n + "Desc";
        if (n < argumentKeys.length) {
            ImagingParameterDescription.argumentKeys[n] = this.key;
        }
    }

    public ImagingParameterDescription(OperationDescriptor operationDescriptor, String string, String string2) {
        this.operation = operationDescriptor;
        this.key = string;
        this.prefixKey = string2;
    }

    public boolean exists() {
        try {
            return !this.toString().isEmpty();
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public String toString(Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = this.operation.getResourceBundle(locale);
        String string = resourceBundle.getString(this.key);
        if (this.prefixKey != null) {
            string = ImagingParameterDescription.trimPrefix(string, resourceBundle.getString(this.prefixKey));
        }
        return string;
    }

    static String trimPrefix(String string, String string2) {
        int n;
        int n2;
        string = string.trim();
        if (string2 != null && (n2 = (string2 = string2.trim()).length()) != 0 && string.startsWith(string2) && n2 < (n = string.length()) && string.charAt(n2) == '.') {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ImagingParameterDescription imagingParameterDescription = (ImagingParameterDescription)object;
            return Utilities.equals((Object)this.key, (Object)imagingParameterDescription.key) && Utilities.equals((Object)this.prefixKey, (Object)imagingParameterDescription.prefixKey) && Utilities.equals((Object)this.operation, (Object)imagingParameterDescription.operation);
        }
        return false;
    }

    public int hashCode() {
        return 0xE0132057 ^ this.key.hashCode() ^ this.operation.hashCode();
    }
}

