/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.net.URI;
import javax.measure.unit.Unit;
import javax.media.jai.ParameterList;
import org.geotoolkit.parameter.AbstractParameterValue;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;

final class ImagingParameter<T>
extends AbstractParameterValue<T> {
    private static final long serialVersionUID = -170895429717041733L;
    private final ParameterList parameters;

    private ImagingParameter(ParameterDescriptor<T> parameterDescriptor, ParameterList parameterList) {
        super(parameterDescriptor);
        this.parameters = parameterList;
    }

    public static <T> ImagingParameter<T> create(ParameterDescriptor<T> parameterDescriptor, ParameterList parameterList) {
        return new ImagingParameter<T>(parameterDescriptor, parameterList);
    }

    private InvalidParameterTypeException invalidType(ClassCastException classCastException) {
        return new InvalidParameterTypeException(Errors.format((int)87, this.getType()), (Throwable)classCastException, ImagingParameter.getName((GeneralParameterDescriptor)this.descriptor));
    }

    private String getName() {
        return this.descriptor.getName().getCode();
    }

    private Class<T> getType() {
        return this.getDescriptor().getValueClass();
    }

    public Unit<?> getUnit() {
        return null;
    }

    public double doubleValue(Unit<?> unit) throws InvalidParameterTypeException {
        throw ImagingParameter.unitlessParameter((GeneralParameterDescriptor)this.descriptor);
    }

    public double doubleValue() throws InvalidParameterTypeException {
        String string = this.getName();
        Class<T> clazz = this.getType();
        try {
            if (clazz.equals(Float.class)) {
                this.parameters.getFloatParameter(string);
            }
            if (clazz.equals(Long.class)) {
                this.parameters.getLongParameter(string);
            }
            if (clazz.equals(Integer.class)) {
                this.parameters.getIntParameter(string);
            }
            if (clazz.equals(Short.class)) {
                this.parameters.getShortParameter(string);
            }
            if (clazz.equals(Byte.class)) {
                this.parameters.getByteParameter(string);
            }
            return this.parameters.getDoubleParameter(string);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
    }

    public int intValue() throws InvalidParameterTypeException {
        String string = this.getName();
        Class<T> clazz = this.getType();
        try {
            if (clazz.equals(Short.class)) {
                this.parameters.getShortParameter(string);
            }
            if (clazz.equals(Byte.class)) {
                this.parameters.getByteParameter(string);
            }
            return this.parameters.getIntParameter(string);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
    }

    public boolean booleanValue() throws InvalidParameterTypeException {
        String string = this.getName();
        try {
            return this.parameters.getBooleanParameter(string);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
    }

    public String stringValue() throws InvalidParameterTypeException {
        String string = this.getName();
        try {
            return ((Object)((CharSequence)this.parameters.getObjectParameter(string))).toString();
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
    }

    public double[] doubleValueList(Unit<?> unit) throws InvalidParameterTypeException {
        throw ImagingParameter.unitlessParameter((GeneralParameterDescriptor)this.descriptor);
    }

    public double[] doubleValueList() throws InvalidParameterTypeException {
        String string = this.getName();
        try {
            return (double[])this.parameters.getObjectParameter(string);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
    }

    public int[] intValueList() throws InvalidParameterTypeException {
        String string = this.getName();
        try {
            return (int[])this.parameters.getObjectParameter(string);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
    }

    public URI valueFile() throws InvalidParameterTypeException {
        String string = this.getName();
        try {
            return (URI)this.parameters.getObjectParameter(string);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
    }

    public T getValue() {
        Object object;
        String string = this.getName();
        try {
            object = this.parameters.getObjectParameter(string);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        return this.getType().cast(object);
    }

    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        throw ImagingParameter.unitlessParameter((GeneralParameterDescriptor)this.descriptor);
    }

    public void setValue(double d) throws InvalidParameterValueException {
        String string = this.getName();
        Class<T> clazz = this.getType();
        try {
            if (clazz.equals(Float.class)) {
                this.parameters.setParameter(string, (float)d);
                return;
            }
            if (clazz.equals(Long.class)) {
                this.parameters.setParameter(string, (long)d);
                return;
            }
            if (clazz.equals(Integer.class)) {
                this.parameters.setParameter(string, (int)d);
                return;
            }
            if (clazz.equals(Short.class)) {
                this.parameters.setParameter(string, (short)d);
                return;
            }
            if (clazz.equals(Byte.class)) {
                this.parameters.setParameter(string, (byte)d);
                return;
            }
            this.parameters.setParameter(string, d);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
        this.fireValueChanged();
    }

    public void setValue(int n) throws InvalidParameterValueException {
        String string = this.getName();
        Class<T> clazz = this.getType();
        try {
            if (clazz.equals(Short.class)) {
                this.parameters.setParameter(string, (short)n);
                return;
            }
            if (clazz.equals(Byte.class)) {
                this.parameters.setParameter(string, (byte)n);
                return;
            }
            this.parameters.setParameter(string, n);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
        this.fireValueChanged();
    }

    public void setValue(boolean bl) throws InvalidParameterValueException {
        String string = this.getName();
        try {
            this.parameters.setParameter(string, bl);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
        this.fireValueChanged();
    }

    public void setValue(Object object) throws InvalidParameterValueException {
        String string = this.getName();
        try {
            this.parameters.setParameter(string, object);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidType(classCastException);
        }
        this.fireValueChanged();
    }

    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        throw ImagingParameter.unitlessParameter((GeneralParameterDescriptor)this.descriptor);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ImagingParameter imagingParameter = (ImagingParameter)((Object)object);
            return Utilities.deepEquals(this.getValue(), imagingParameter.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Utilities.hash((int)Utilities.deepHashCode(this.getValue()), (int)super.hashCode()) ^ 0x19FA5DBB;
    }

    public Parameter<T> clone() {
        Parameter parameter = new Parameter(this.getDescriptor());
        parameter.setValue(this.getValue());
        return parameter;
    }
}

