/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.jai;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.OperationDescriptorImpl;
import net.jcip.annotations.Immutable;
import org.geotoolkit.image.jai.Combine;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;

@Immutable
public final class CombineDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = 617861534162611411L;

    public CombineDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "org.geotoolkit.Combine"}, {"LocalName", "org.geotoolkit.Combine"}, {"Vendor", "org.geotoolkit"}, {"Description", "Combine rendered images using a linear relation."}, {"DocURL", "http://www.geotoolkit.org/"}, {"Version", "1.0"}, {"arg0Desc", "The coefficients for linear combination as a matrix."}, {"arg1Desc", "An optional transform to apply on sample values before the linear combination."}}, new String[]{"rendered"}, 0, new String[]{"matrix", "transform"}, new Class[]{double[][].class, Combine.Transform.class}, new Object[]{NO_PARAMETER_DEFAULT, null}, null);
    }

    protected boolean validateSources(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (super.validateSources(string, parameterBlock, stringBuffer)) {
            int n = parameterBlock.getNumSources();
            while (--n >= 0) {
                Object object = parameterBlock.getSource(n);
                if (object instanceof RenderedImage) continue;
                stringBuffer.append(Errors.format((int)13, (Object)("source" + n), (Object)Classes.getClass((Object)object)));
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateParameters(string, parameterBlock, stringBuffer)) {
            return false;
        }
        double[][] dArray = (double[][])parameterBlock.getObjectParameter(0);
        int n = 1;
        int n2 = parameterBlock.getNumSources();
        while (--n2 >= 0) {
            n += ((RenderedImage)parameterBlock.getSource(n2)).getSampleModel().getNumBands();
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (dArray[n2].length == n) continue;
            stringBuffer.append(Errors.format((int)211, (Object)n2, (Object)dArray[n2].length, (Object)n));
            return false;
        }
        return true;
    }
}

