/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.jai;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import java.util.Vector;
import javax.media.jai.CRIFImpl;
import net.jcip.annotations.Immutable;
import org.geotoolkit.image.jai.Combine;
import org.geotoolkit.resources.Errors;

@Immutable
public final class CombineCRIF
extends CRIFImpl {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        Vector<RenderedImage> vector = CombineCRIF.cast(parameterBlock.getSources());
        double[][] dArray = (double[][])parameterBlock.getObjectParameter(0);
        Combine.Transform transform = (Combine.Transform)parameterBlock.getObjectParameter(1);
        return transform == null && CombineCRIF.isDyadic(vector, dArray) ? new Combine.Dyadic(vector, dArray, renderingHints) : new Combine(vector, dArray, transform, renderingHints);
    }

    private static boolean isDyadic(List<?> list, double[][] dArray) {
        if (list.size() != 2) {
            return false;
        }
        RenderedImage renderedImage = (RenderedImage)list.get(0);
        RenderedImage renderedImage2 = (RenderedImage)list.get(1);
        int n = renderedImage.getSampleModel().getNumBands();
        int n2 = renderedImage2.getSampleModel().getNumBands();
        int n3 = dArray.length;
        if (n3 != n || n3 != n2) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = dArray[i];
            int n4 = n + n2;
            while (--n4 >= 0) {
                if (n4 == i || n4 == i + n || dArray2[n4] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    static Vector<RenderedImage> cast(Vector<?> vector) {
        for (RenderedImage obj : vector) {
            if (obj instanceof RenderedImage) continue;
            throw new ClassCastException(Errors.format((int)76, obj.getClass(), RenderedImage.class));
        }
        return vector;
    }
}

