/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Locale;
import org.geotoolkit.internal.image.ColorModels;
import org.geotoolkit.internal.image.MultiBandsIndexColorModel;
import org.geotoolkit.lang.Static;

public final class ColorUtilities
extends Static {
    private static final double EPS = 1.0E-6;
    public static final IndexColorModel BINARY_COLOR_MODEL = new IndexColorModel(1, 2, new int[]{0, -1}, 0, false, -1, 0);

    private ColorUtilities() {
    }

    public static int getIntFromColor(int n, int n2, int n3, int n4) {
        return (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    public static double[] toDoubleValues(Color color, int n) {
        double[] dArray = new double[n];
        switch (n) {
            default: {
                dArray[3] = color.getAlpha();
            }
            case 3: {
                dArray[2] = color.getBlue();
            }
            case 2: {
                dArray[1] = color.getGreen();
            }
            case 1: {
                dArray[0] = color.getRed();
            }
            case 0: 
        }
        return dArray;
    }

    public static String toString(Color color) {
        int n;
        boolean bl;
        int n2 = color.getRGB();
        boolean bl2 = bl = (n2 & 0xFF000000) == -16777216;
        if (bl) {
            n2 &= 0xFFFFFF;
            n = 6;
        } else {
            n = 8;
        }
        String string = Integer.toHexString(n2).toUpperCase(Locale.US);
        n -= string.length();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#');
        while (--n >= 0) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    public static Color[] subarray(Color[] colorArray, int n, int n2) {
        if (colorArray != null) {
            if ((n = Math.max(n, 0)) >= (n2 = Math.min(n2, colorArray.length))) {
                return null;
            }
            if (n != 0 || n2 != colorArray.length) {
                return Arrays.copyOfRange(colorArray, n, n2);
            }
        }
        return colorArray;
    }

    public static void expand(Color[] colorArray, int[] nArray, int n, int n2) {
        switch (colorArray.length) {
            case 1: {
                Arrays.fill(nArray, n, n2, colorArray[0].getRGB());
            }
            case 0: {
                return;
            }
        }
        switch (n2 - n) {
            case 1: {
                nArray[n] = colorArray[0].getRGB();
            }
            case 0: {
                return;
            }
        }
        double d = (double)(colorArray.length - 1) / (double)(n2 - 1 - n);
        int n3 = colorArray.length - 2;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = n;
        while (true) {
            int n6 = colorArray[n4 + 0].getRGB();
            int n7 = colorArray[n4 + 1].getRGB();
            int n8 = n6 >>> 24 & 0xFF;
            int n9 = (n7 >>> 24 & 0xFF) - n8;
            int n10 = n6 >>> 16 & 0xFF;
            int n11 = (n7 >>> 16 & 0xFF) - n10;
            int n12 = n6 >>> 8 & 0xFF;
            int n13 = (n7 >>> 8 & 0xFF) - n12;
            int n14 = n6 & 0xFF;
            int n15 = (n7 & 0xFF) - n14;
            int n16 = n4;
            do {
                double d3 = d2 - (double)n4;
                nArray[n5] = ColorUtilities.roundByte((double)n8 + d3 * (double)n9) << 24 | ColorUtilities.roundByte((double)n10 + d3 * (double)n11) << 16 | ColorUtilities.roundByte((double)n12 + d3 * (double)n13) << 8 | ColorUtilities.roundByte((double)n14 + d3 * (double)n15);
                if (++n5 != n2) continue;
                return;
            } while ((n4 = Math.min(n3, (int)((d2 = (double)(n5 - n) * d) + 1.0E-6))) == n16);
        }
    }

    public static int roundByte(double d) {
        return (int)Math.min(Math.max(Math.round(d), 0L), 255L);
    }

    public static IndexColorModel getIndexColorModel(int[] nArray) {
        return ColorUtilities.getIndexColorModel(nArray, 1, 0, -1);
    }

    public static IndexColorModel getIndexColorModel(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        int n5 = ColorUtilities.getBitCount(n4);
        int n6 = ColorUtilities.getTransferType(n4);
        IndexColorModel indexColorModel = n == 1 ? new IndexColorModel(n5, n4, nArray, 0, true, n3, n6) : new MultiBandsIndexColorModel(n5, n4, nArray, 0, true, n3, n6, n, n2);
        return ColorModels.unique(indexColorModel);
    }

    public static int getBitCount(int n) {
        int n2 = Math.max(1, 32 - Integer.numberOfLeadingZeros(n - 1));
        assert (1 << n2 >= n) : n;
        assert (1 << n2 - 1 < n) : n;
        return n2;
    }

    public static int getTransferType(int n) {
        return n <= 256 ? 0 : 1;
    }

    public static float[] XYZtoLAB(float[] fArray) {
        float f;
        fArray[0] = (float)((double)fArray[0] / 0.9642);
        fArray[1] = (float)((double)fArray[1] / 1.0);
        fArray[2] = (float)((double)fArray[2] / 0.8249);
        for (int i = 0; i < 3; ++i) {
            f = fArray[i];
            fArray[i] = (float)(f > 0.008856452f ? Math.pow(f, 0.3333333333333333) : (903.2962962962963 * (double)f + 16.0) / 116.0);
        }
        float f2 = 116.0f * fArray[1] - 16.0f;
        f = 500.0f * (fArray[0] - fArray[1]);
        float f3 = 200.0f * (fArray[1] - fArray[2]);
        assert (!(Float.isNaN(f2) || Float.isNaN(f) || Float.isNaN(f3)));
        fArray[0] = f2;
        fArray[1] = f;
        fArray[2] = f3;
        return fArray;
    }

    public static float colorDistance(float[] fArray, float[] fArray2) {
        double d = 0.0;
        int n = Math.min(fArray.length, fArray2.length);
        while (--n >= 0) {
            double d2 = fArray[n] - fArray2[n];
            d += d2 * d2;
        }
        return (float)Math.sqrt(d);
    }

    public static int getTransparentPixel(IndexColorModel indexColorModel) {
        int n = indexColorModel.getTransparentPixel();
        if (n < 0) {
            n = 0;
            int n2 = Integer.MAX_VALUE;
            float f = Float.POSITIVE_INFINITY;
            ColorSpace colorSpace = indexColorModel.getColorSpace();
            float[] fArray = new float[3];
            float[] fArray2 = ColorUtilities.XYZtoLAB(colorSpace.toCIEXYZ(fArray));
            assert (fArray2 != fArray);
            int n3 = indexColorModel.getMapSize();
            while (--n3 >= 0) {
                int n4 = indexColorModel.getAlpha(n3);
                if (n4 > n2) continue;
                fArray[0] = (float)indexColorModel.getRed(n3) / 255.0f;
                fArray[1] = (float)indexColorModel.getGreen(n3) / 255.0f;
                fArray[2] = (float)indexColorModel.getBlue(n3) / 255.0f;
                float f2 = ColorUtilities.colorDistance(ColorUtilities.XYZtoLAB(colorSpace.toCIEXYZ(fArray)), fArray2);
                assert (f2 >= 0.0f) : n3;
                if (n4 >= n2 && !(f2 < f)) continue;
                n2 = n4;
                f = f2;
                n = n3;
            }
        }
        return n;
    }

    public static int getColorIndex(IndexColorModel indexColorModel, Color color, int n) {
        ColorSpace colorSpace = indexColorModel.getColorSpace();
        float[] fArray = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        float[] fArray2 = ColorUtilities.XYZtoLAB(colorSpace.toCIEXYZ(fArray));
        float f = Float.POSITIVE_INFINITY;
        int n2 = 0;
        assert (fArray2 != fArray);
        int n3 = indexColorModel.getMapSize();
        while (--n3 >= 0) {
            if (n3 == n) continue;
            fArray[0] = (float)indexColorModel.getRed(n3) / 255.0f;
            fArray[1] = (float)indexColorModel.getGreen(n3) / 255.0f;
            fArray[2] = (float)indexColorModel.getBlue(n3) / 255.0f;
            float f2 = ColorUtilities.colorDistance(ColorUtilities.XYZtoLAB(colorSpace.toCIEXYZ(fArray)), fArray2);
            assert (f2 >= 0.0f) : n3;
            if (!(f2 <= f)) continue;
            f = f2;
            n2 = n3;
        }
        return n2;
    }

    public static int getNumBands(ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            if (colorModel instanceof MultiBandsIndexColorModel) {
                return ((MultiBandsIndexColorModel)colorModel).numBands;
            }
            return 1;
        }
        return colorModel.getNumComponents();
    }

    public static boolean isGrayPalette(IndexColorModel indexColorModel, boolean bl) {
        if (!indexColorModel.hasAlpha()) {
            bl = false;
        }
        int n = indexColorModel.getMapSize();
        for (int i = 0; i < n; ++i) {
            int n2;
            if (bl && indexColorModel.getAlpha(i) == 0 || (n2 = indexColorModel.getGreen(i)) == indexColorModel.getRed(i) && n2 == indexColorModel.getBlue(i)) continue;
            return false;
        }
        return true;
    }
}

