/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import org.geotoolkit.internal.image.MultiBandsIndexColorModel;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.WeakHashSet;

public final class ColorModels<T extends ColorModel>
extends Static {
    private static final WeakHashSet<ColorModels> POOL = WeakHashSet.newInstance(ColorModels.class);
    private final T cm;

    private ColorModels(T t) {
        this.cm = t;
    }

    public static <T extends ColorModel> T unique(T t) {
        ColorModels colorModels = new ColorModels(t);
        colorModels = (ColorModels)((Object)POOL.unique(colorModels));
        return colorModels.cm;
    }

    public static boolean equals(ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel == colorModel2) {
            return true;
        }
        if (colorModel != null && colorModel.equals(colorModel2) && Utilities.equals(colorModel.getClass(), colorModel2.getClass()) && Utilities.equals((int)colorModel.getTransferType(), (int)colorModel2.getTransferType()) && Utilities.equals((Object)colorModel.getColorSpace(), (Object)colorModel2.getColorSpace())) {
            if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                IndexColorModel indexColorModel2 = (IndexColorModel)colorModel2;
                int n = indexColorModel.getMapSize();
                if (Utilities.equals((int)n, (int)indexColorModel2.getMapSize()) && Utilities.equals((int)indexColorModel.getTransparentPixel(), (int)indexColorModel2.getTransparentPixel()) && Utilities.equals((Object)indexColorModel.getValidPixels(), (Object)indexColorModel2.getValidPixels())) {
                    for (int i = 0; i < n; ++i) {
                        if (indexColorModel.getRGB(i) == indexColorModel2.getRGB(i)) continue;
                        return false;
                    }
                }
                if (colorModel instanceof MultiBandsIndexColorModel) {
                    MultiBandsIndexColorModel multiBandsIndexColorModel = (MultiBandsIndexColorModel)colorModel;
                    MultiBandsIndexColorModel multiBandsIndexColorModel2 = (MultiBandsIndexColorModel)colorModel2;
                    if (multiBandsIndexColorModel.numBands != multiBandsIndexColorModel2.numBands || multiBandsIndexColorModel.visibleBand != multiBandsIndexColorModel2.visibleBand) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof ColorModels && ColorModels.equals(this.cm, ((ColorModels)((Object)object)).cm);
    }

    public int hashCode() {
        int n = ((ColorModel)this.cm).hashCode() ^ this.cm.getClass().hashCode();
        if (this.cm instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            int[] nArray = new int[indexColorModel.getMapSize()];
            indexColorModel.getRGBs(nArray);
            n ^= Arrays.hashCode(nArray);
        }
        return n;
    }
}

