/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.UntiledOpImage;
import org.geotoolkit.image.jai.SampleValues;
import org.geotoolkit.internal.image.ColorUtilities;

public class SilhouetteMask
extends UntiledOpImage {
    public static final String OPERATION_NAME = "org.geotoolkit.SilhouetteMask";
    private final double[][] background;

    public SilhouetteMask(RenderedImage renderedImage, ImageLayout imageLayout, Map<?, ?> map, double[] ... dArray) {
        super(renderedImage, map, SilhouetteMask.layout(renderedImage, imageLayout));
        int n = renderedImage.getSampleModel().getNumBands();
        dArray = (double[][])dArray.clone();
        this.background = dArray;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Arrays.copyOf(dArray[i], n);
        }
    }

    private static ImageLayout layout(RenderedImage renderedImage, ImageLayout imageLayout) {
        if (imageLayout == null) {
            imageLayout = new ImageLayout();
        } else if ((imageLayout.getValidMask() & 0x300) == 0) {
            imageLayout = (ImageLayout)imageLayout.clone();
        } else {
            return imageLayout;
        }
        IndexColorModel indexColorModel = ColorUtilities.BINARY_COLOR_MODEL;
        return imageLayout.setColorModel((ColorModel)indexColorModel).setSampleModel(((ColorModel)indexColorModel).createCompatibleSampleModel(imageLayout.getWidth(renderedImage), imageLayout.getHeight(renderedImage)));
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        assert (rasterArray.length == 1);
        if (rectangle.isEmpty()) {
            return;
        }
        Raster raster = rasterArray[0];
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width + n;
        int n4 = rectangle.height + n2;
        int[] nArray = new int[writableRaster.getNumBands()];
        Arrays.fill(nArray, -1);
        int n5 = raster.getTransferType();
        HashSet<SampleValues> hashSet = new HashSet<SampleValues>();
        for (double[] dArray : this.background) {
            hashSet.add(SampleValues.getInstance(n5, dArray));
        }
        Object object = SampleValues.getInstance(n5, raster.getSampleModel().getNumBands());
        assert (raster.getBounds().contains(rectangle)) : rectangle;
        for (int i = 0; i < 4; ++i) {
            int n6 = raster.getMinX();
            int n7 = raster.getMinY();
            int n8 = raster.getWidth();
            int n9 = raster.getHeight();
            int n10 = 1;
            int n11 = 1;
            if ((i & 1) != 0) {
                n6 += n8 - 1;
                n10 = -1;
            }
            if ((i & 2) != 0) {
                n7 += n9 - 1;
                n11 = -1;
            }
            int n12 = n6;
            while (--n9 >= 0 && hashSet.contains(((SampleValues)object).getPixel(raster, n6, n7))) {
                if (n7 >= n2 && n7 < n4) {
                    n8 = rectangle.width;
                    do {
                        if (n6 < n || n6 >= n3) continue;
                        writableRaster.setPixel(n6, n7, nArray);
                        if (--n8 == 0) break;
                    } while (hashSet.contains(((SampleValues)object).getPixel(raster, n6 += n10, n7)));
                }
                n7 += n11;
                n6 = n12;
            }
        }
    }
}

