/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.apache.sis.util.ArraysExt;

abstract class SampleValues {
    SampleValues() {
    }

    public static SampleValues getInstance(int n, int n2) {
        switch (n) {
            case 5: {
                return new Double(n2);
            }
            case 4: {
                return new Float(n2);
            }
        }
        return new Integer(n2);
    }

    public static SampleValues getInstance(int n, double[] dArray) {
        switch (n) {
            case 5: {
                return new Double(dArray);
            }
            case 4: {
                return new Float(dArray);
            }
        }
        return new Integer(dArray);
    }

    public abstract SampleValues instance();

    public abstract SampleValues getPixel(Raster var1, int var2, int var3);

    public abstract void setPixel(WritableRaster var1, int var2, int var3);

    private static final class Integer
    extends SampleValues {
        final int[] samples;

        Integer(int n) {
            this.samples = new int[n];
        }

        Integer(double[] dArray) {
            this.samples = ArraysExt.copyAsInts((double[])dArray);
        }

        @Override
        public SampleValues instance() {
            return new Integer(this.samples.length);
        }

        @Override
        public SampleValues getPixel(Raster raster, int n, int n2) {
            raster.getPixel(n, n2, this.samples);
            return this;
        }

        @Override
        public void setPixel(WritableRaster writableRaster, int n, int n2) {
            writableRaster.setPixel(n, n2, this.samples);
        }

        public int hashCode() {
            return Arrays.hashCode(this.samples);
        }

        public boolean equals(Object object) {
            return object instanceof Integer && Arrays.equals(this.samples, ((Integer)object).samples);
        }

        public String toString() {
            return Arrays.toString(this.samples);
        }
    }

    private static final class Float
    extends SampleValues {
        final float[] samples;

        Float(int n) {
            this.samples = new float[n];
        }

        Float(double[] dArray) {
            this.samples = ArraysExt.copyAsFloats((double[])dArray);
        }

        @Override
        public SampleValues instance() {
            return new Float(this.samples.length);
        }

        @Override
        public SampleValues getPixel(Raster raster, int n, int n2) {
            raster.getPixel(n, n2, this.samples);
            return this;
        }

        @Override
        public void setPixel(WritableRaster writableRaster, int n, int n2) {
            writableRaster.setPixel(n, n2, this.samples);
        }

        public int hashCode() {
            return Arrays.hashCode(this.samples);
        }

        public boolean equals(Object object) {
            return object instanceof Float && Arrays.equals(this.samples, ((Float)object).samples);
        }

        public String toString() {
            return Arrays.toString(this.samples);
        }
    }

    private static final class Double
    extends SampleValues {
        final double[] samples;

        Double(int n) {
            this.samples = new double[n];
        }

        Double(double[] dArray) {
            this.samples = (double[])dArray.clone();
        }

        @Override
        public SampleValues instance() {
            return new Double(this.samples.length);
        }

        @Override
        public SampleValues getPixel(Raster raster, int n, int n2) {
            raster.getPixel(n, n2, this.samples);
            return this;
        }

        @Override
        public void setPixel(WritableRaster writableRaster, int n, int n2) {
            writableRaster.setPixel(n, n2, this.samples);
        }

        public int hashCode() {
            return Arrays.hashCode(this.samples);
        }

        public boolean equals(Object object) {
            return object instanceof Double && Arrays.equals(this.samples, ((Double)object).samples);
        }

        public String toString() {
            return Arrays.toString(this.samples);
        }
    }
}

