/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.image.renderable.RenderedImageFactory;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.registry.RIFRegistry;
import org.geotoolkit.internal.image.jai.CombineCRIF;
import org.geotoolkit.internal.image.jai.CombineDescriptor;
import org.geotoolkit.internal.image.jai.HysteresisCRIF;
import org.geotoolkit.internal.image.jai.HysteresisDescriptor;
import org.geotoolkit.internal.image.jai.NodataFilterCRIF;
import org.geotoolkit.internal.image.jai.NodataFilterDescriptor;
import org.geotoolkit.internal.image.jai.SilhouetteMaskCRIF;
import org.geotoolkit.internal.image.jai.SilhouetteMaskDescriptor;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.logging.Logging;

public final class Registry
extends Static {
    private Registry() {
    }

    public static boolean registerGeotoolkitServices(OperationRegistry operationRegistry) {
        LogRecord logRecord;
        String string = "org.geotoolkit";
        try {
            string = "org.geotoolkit.Combine";
            operationRegistry.registerDescriptor((RegistryElementDescriptor)new CombineDescriptor());
            RIFRegistry.register((OperationRegistry)operationRegistry, (String)string, (String)"org.geotoolkit", (RenderedImageFactory)((Object)new CombineCRIF()));
            string = "org.geotoolkit.Hysteresis";
            operationRegistry.registerDescriptor((RegistryElementDescriptor)new HysteresisDescriptor());
            RIFRegistry.register((OperationRegistry)operationRegistry, (String)string, (String)"org.geotoolkit", (RenderedImageFactory)((Object)new HysteresisCRIF()));
            string = "org.geotoolkit.NodataFilter";
            operationRegistry.registerDescriptor((RegistryElementDescriptor)new NodataFilterDescriptor());
            RIFRegistry.register((OperationRegistry)operationRegistry, (String)string, (String)"org.geotoolkit", (RenderedImageFactory)((Object)new NodataFilterCRIF()));
            string = "org.geotoolkit.SilhouetteMask";
            operationRegistry.registerDescriptor((RegistryElementDescriptor)new SilhouetteMaskDescriptor());
            RIFRegistry.register((OperationRegistry)operationRegistry, (String)string, (String)"org.geotoolkit", (RenderedImageFactory)((Object)new SilhouetteMaskCRIF()));
            logRecord = Loggings.format((Level)Level.CONFIG, (int)43);
            string = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logRecord = Loggings.getResources(null).getLogRecord(Level.WARNING, 12, (Object)string);
            logRecord.setThrown(illegalArgumentException);
        }
        Registry.log("registerGeotoolkitServices", logRecord);
        return string == null;
    }

    public static synchronized void setNativeAccelerationAllowed(String string, boolean bl, JAI jAI) {
        OperationRegistry operationRegistry = jAI.getOperationRegistry();
        List list = operationRegistry.getOrderedFactoryList("rendered", string, "com.sun.media.jai");
        if (list != null) {
            RenderedImageFactory renderedImageFactory = null;
            RenderedImageFactory renderedImageFactory2 = null;
            Boolean bl2 = null;
            for (RenderedImageFactory renderedImageFactory3 : list) {
                String string2 = renderedImageFactory3.getClass().getPackage().getName();
                if (string2.equals("com.sun.media.jai.mlib")) {
                    renderedImageFactory2 = renderedImageFactory3;
                    if (renderedImageFactory != null) {
                        bl2 = Boolean.FALSE;
                    }
                }
                if (!string2.equals("com.sun.media.jai.opimage")) continue;
                renderedImageFactory = renderedImageFactory3;
                if (renderedImageFactory2 == null) continue;
                bl2 = Boolean.TRUE;
            }
            if (bl2 != null && bl2 != bl) {
                RIFRegistry.unsetPreference((OperationRegistry)operationRegistry, (String)string, (String)"com.sun.media.jai", (RenderedImageFactory)(bl ? renderedImageFactory : renderedImageFactory2), (RenderedImageFactory)(bl ? renderedImageFactory2 : renderedImageFactory));
                RIFRegistry.setPreference((OperationRegistry)operationRegistry, (String)string, (String)"com.sun.media.jai", (RenderedImageFactory)(bl ? renderedImageFactory2 : renderedImageFactory), (RenderedImageFactory)(bl ? renderedImageFactory : renderedImageFactory2));
                LogRecord logRecord = Loggings.format((Level)Level.CONFIG, (int)36, (Object)string, (Object)(bl ? 1 : 0));
                Registry.log("setNativeAccelerationAllowed", logRecord);
            }
        }
    }

    public static void setNativeAccelerationAllowed(String string, boolean bl) {
        Registry.setNativeAccelerationAllowed(string, bl, JAI.getDefaultInstance());
    }

    public static synchronized <T extends ImageReaderWriterSpi> void setNativeCodecAllowed(String string, Class<T> clazz, boolean bl) {
        boolean bl2;
        Object object;
        Object object2 = null;
        ImageReaderWriterSpi imageReaderWriterSpi = null;
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator<T> iterator = iIORegistry.getServiceProviders(clazz, false);
        block0: while (iterator.hasNext()) {
            object = (ImageReaderWriterSpi)iterator.next();
            String[] stringArray = ((ImageReaderWriterSpi)object).getFormatNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                String string2 = object.getClass().getName();
                if (string2.startsWith("com.sun.media.")) {
                    imageReaderWriterSpi = object;
                    continue block0;
                }
                if (!string2.startsWith("com.sun.imageio.")) continue;
                object2 = object;
                continue block0;
            }
        }
        if (object2 != null && imageReaderWriterSpi != null && (bl2 = bl ? iIORegistry.setOrdering(clazz, imageReaderWriterSpi, object2) : iIORegistry.setOrdering(clazz, object2, imageReaderWriterSpi))) {
            object = Loggings.format((Level)Level.CONFIG, (int)37, (Object)string, (Object)(bl ? 1 : 0), (Object)(ImageWriterSpi.class.isAssignableFrom(clazz) ? 1 : 0));
            Registry.log("setNativeCodecAllowed", (LogRecord)object);
        }
    }

    public static synchronized void setDefaultCodecPreferences() {
        Registry.setNativeCodecAllowed("GIF", ImageReaderSpi.class, false);
        Registry.setNativeCodecAllowed("GIF", ImageWriterSpi.class, false);
        Registry.setNativeCodecAllowed("PNG", ImageReaderSpi.class, false);
        Registry.setNativeCodecAllowed("PNG", ImageWriterSpi.class, false);
        Registry.setNativeCodecAllowed("BMP", ImageReaderSpi.class, false);
        Registry.setNativeCodecAllowed("BMP", ImageWriterSpi.class, false);
        Registry.setNativeCodecAllowed("WBMP", ImageReaderSpi.class, false);
        Registry.setNativeCodecAllowed("WBMP", ImageWriterSpi.class, false);
        Registry.setNativeCodecAllowed("JPEG", ImageReaderSpi.class, false);
        Registry.setNativeCodecAllowed("JPEG", ImageWriterSpi.class, false);
        Registry.setNativeCodecAllowed("TIFF", ImageReaderSpi.class, true);
        Registry.setNativeCodecAllowed("TIFF", ImageWriterSpi.class, true);
    }

    private static void log(String string, LogRecord logRecord) {
        logRecord.setSourceClassName(Registry.class.getName());
        logRecord.setSourceMethodName(string);
        Logger logger = Logging.getLogger(Registry.class);
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }
}

