/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.AreaOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class NodataFilter
extends AreaOpImage {
    public static final String OPERATION_NAME = "org.geotoolkit.NodataFilter";
    private static double[] sharedDistances;
    private final double[] distances;
    private final int validityThreshold;

    public NodataFilter(RenderedImage renderedImage, ImageLayout imageLayout, Map<?, ?> map, int n, int n2) {
        super(renderedImage, imageLayout, map, false, null, n, n, n, n);
        this.validityThreshold = n2;
        if (n == 1 && sharedDistances != null) {
            this.distances = sharedDistances;
        } else {
            this.distances = new double[(this.leftPadding + this.rightPadding + 1) * (this.topPadding + this.bottomPadding + 1)];
            int n3 = 0;
            for (int i = -this.topPadding; i <= this.bottomPadding; ++i) {
                for (int j = -this.leftPadding; j <= this.rightPadding; ++j) {
                    this.distances[n3++] = Math.sqrt(j * j + i * i);
                }
            }
            assert (n3 == this.distances.length);
            if (n == 1) {
                sharedDistances = this.distances;
            }
        }
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        assert (planarImageArray.length == 1);
        PlanarImage planarImage = planarImageArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        rectangle2 = rectangle2.intersection(planarImage.getBounds());
        RandomIter randomIter = RandomIterFactory.create((RenderedImage)planarImage, (Rectangle)rectangle2);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width + n;
        int n4 = rectangle.height + n2;
        int n5 = this.leftPadding + this.rightPadding + 1;
        int n6 = planarImage.getNumBands();
        while (--n6 >= 0) {
            for (int i = n2; i < n4; ++i) {
                int n7 = Math.max(n2, i - this.topPadding);
                int n8 = Math.min(n4, i + this.bottomPadding + 1);
                int n9 = (n7 - (i - this.topPadding)) * n5;
                assert (n9 >= 0 && n9 <= this.distances.length) : n9;
                for (int j = n; j < n3; ++j) {
                    double d = randomIter.getSampleDouble(j, i, n6);
                    if (!Double.isNaN(d)) {
                        writableRaster.setSample(j, i, n6, d);
                        continue;
                    }
                    int n10 = 0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    int n11 = Math.max(n, j - this.leftPadding);
                    int n12 = Math.min(n3, j + this.rightPadding + 1);
                    int n13 = n5 - (n12 - n11);
                    int n14 = n9 + (n11 - (j - this.leftPadding));
                    for (int k = n7; k < n8; ++k) {
                        for (int i2 = n11; i2 < n12; ++i2) {
                            double d4 = randomIter.getSampleDouble(i2, k, n6);
                            if (!Double.isNaN(d4)) {
                                double d5 = this.distances[n14];
                                assert (Math.abs(d5 - Math.hypot(i2 - j, k - i)) < 1.0E-6 && d5 > 0.0) : d5;
                                d2 += d5 * d4;
                                d3 += d5;
                                ++n10;
                            }
                            ++n14;
                        }
                        n14 += n13;
                    }
                    double d6 = n10 >= this.validityThreshold ? d2 / d3 : d;
                    writableRaster.setSample(j, i, n6, d6);
                }
            }
        }
        randomIter.done();
    }
}

