/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class Hysteresis
extends UntiledOpImage {
    public static final String OPERATION_NAME = "org.geotoolkit.Hysteresis";
    protected final double low;
    protected final double high;
    protected final double padValue;

    public Hysteresis(RenderedImage renderedImage, ImageLayout imageLayout, Map<?, ?> map, double d, double d2, double d3) {
        super(renderedImage, map, imageLayout);
        this.low = d;
        this.high = d2;
        this.padValue = d3;
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        assert (rasterArray.length == 1);
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        rectangle2 = rectangle2.intersection(raster.getBounds());
        RandomIter randomIter = RandomIterFactory.create((Raster)raster, (Rectangle)rectangle2);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width + n;
        int n4 = rectangle.height + n2;
        int n5 = this.width - 1;
        int n6 = this.height - 1;
        boolean[] blArray = new boolean[rectangle.width * rectangle.height];
        boolean[] blArray2 = new boolean[rectangle.width * rectangle.height];
        int n7 = raster.getNumBands();
        while (--n7 >= 0) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = 0;
            for (n11 = n2; n11 < n4; ++n11) {
                for (n10 = n; n10 < n3; ++n10) {
                    double d = randomIter.getSampleDouble(n10, n11, n7);
                    blArray[n12] = !(d < this.high);
                    blArray2[n12] = !(d >= this.low);
                    ++n12;
                }
            }
            assert (n12 == blArray.length);
            n11 = 1;
            do {
                n10 = 0;
                if (n11 >= 0) {
                    n12 = 0;
                    n9 = blArray.length;
                } else {
                    n12 = blArray.length - 1;
                    n9 = -1;
                }
                while (n12 != n9) {
                    if (!blArray[n12] && !blArray2[n12]) {
                        int n13 = n12 / this.width;
                        int n14 = n12 % this.width;
                        if (n14 != 0 && (blArray[n8 = n12 - 1] && !blArray2[n8] || n13 != 0 && blArray[n8 = n12 - 1 - this.width] && !blArray2[n8] || n13 != n6 && blArray[n8 = n12 - 1 + this.width] && !blArray2[n8]) || n14 != n5 && (blArray[n8 = n12 + 1] && !blArray2[n8] || n13 != 0 && blArray[n8 = n12 + 1 - this.width] && !blArray2[n8] || n13 != n6 && blArray[n8 = n12 + 1 + this.width] && !blArray2[n8]) || n13 != 0 && blArray[n8 = n12 - this.width] && !blArray2[n8] || n13 != n5 && blArray[n8 = n12 + this.width] && !blArray2[n8]) {
                            blArray[n12] = true;
                            n10 = 1;
                        }
                    }
                    n12 += n11;
                }
                n11 = -n11;
            } while (n10 != 0);
            n12 = 0;
            for (n9 = n2; n9 < n4; ++n9) {
                for (n8 = n; n8 < n3; ++n8) {
                    writableRaster.setSample(n8, n9, n7, blArray[n12++] ? randomIter.getSampleDouble(n8, n9, n7) : this.padValue);
                }
            }
            assert (n12 == blArray.length);
        }
        randomIter.done();
    }
}

