/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import org.geotoolkit.image.jai.SampleValues;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.IntegerList;
import org.geotoolkit.util.collection.XCollections;

public abstract class FloodFill
extends OpImage {
    public static final String OPERATION_NAME = "org.geotoolkit.FloodFill";
    private final double[][] oldValues;
    private final double[] newValues;

    public FloodFill(RenderedImage renderedImage, ImageLayout imageLayout, Map<?, ?> map, double[][] dArray, double[] dArray2) {
        super(new Vector<RenderedImage>(Collections.singleton(renderedImage)), imageLayout, map, false);
        int n = renderedImage.getSampleModel().getNumBands();
        dArray2 = (double[])dArray2.clone();
        this.newValues = dArray2;
        dArray = (double[][])dArray.clone();
        this.oldValues = dArray;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Arrays.copyOf(dArray[i], n);
        }
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    public static void fill(WritableRenderedImage writableRenderedImage, Color[] colorArray, Color color, Point ... pointArray) {
        int n = writableRenderedImage.getSampleModel().getNumBands();
        double[][] dArrayArray = new double[colorArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = ColorUtilities.toDoubleValues(colorArray[i], n);
        }
        double[] dArray = ColorUtilities.toDoubleValues(color, n);
        FloodFill.fill(writableRenderedImage, dArrayArray, dArray, pointArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill(WritableRenderedImage writableRenderedImage, double[][] dArray, double[] dArray2, Point ... pointArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = writableRenderedImage.getSampleModel().getTransferType();
        HashSet<SampleValues> hashSet = new HashSet<SampleValues>(XCollections.hashMapCapacity((int)dArray.length));
        for (double[] n42 : dArray) {
            hashSet.add(SampleValues.getInstance(n6, n42));
        }
        SampleValues sampleValues = SampleValues.getInstance(n6, dArray2);
        hashSet.remove(sampleValues);
        if (hashSet.isEmpty()) {
            return;
        }
        int n7 = writableRenderedImage.getMinX();
        Rectangle rectangle = new Rectangle(n7, n5 = writableRenderedImage.getMinY(), n4 = writableRenderedImage.getWidth(), n3 = writableRenderedImage.getHeight());
        if (rectangle.isEmpty()) {
            return;
        }
        IntegerList integerList = new IntegerList(8, Math.max(n4, n3) - 1);
        for (Point n11 : pointArray) {
            n2 = n11.x - n7;
            n = n11.y - n5;
            if (n2 < 0 || n2 >= n4 || n < 0 || n >= n3) {
                throw new IllegalArgumentException(Errors.format((int)185, (Object)("" + n11.x + ',' + n11.y)));
            }
            integerList.addInteger(n2);
            integerList.addInteger(n);
        }
        int n8 = writableRenderedImage.getTileGridXOffset();
        int n9 = writableRenderedImage.getTileGridYOffset();
        int n10 = writableRenderedImage.getTileWidth();
        int n11 = writableRenderedImage.getTileHeight();
        n2 = writableRenderedImage.getMinTileY();
        n = writableRenderedImage.getNumXTiles() + n2 - 1;
        while (!integerList.isEmpty()) {
            int n12 = integerList.removeLast() + n5;
            int n13 = integerList.removeLast() + n7;
            int n14 = FloodFill.XToTileX((int)n13, (int)n8, (int)n10);
            int n15 = FloodFill.YToTileY((int)n12, (int)n9, (int)n11);
            Raster raster = n15 != n2 ? writableRenderedImage.getTile(n14, n15 - 1) : null;
            Raster raster2 = n15 != n ? writableRenderedImage.getTile(n14, n15 + 1) : null;
            WritableRaster writableRaster = writableRenderedImage.getWritableTile(n14, n15);
            try {
                FloodFill.fill(writableRaster, raster, raster2, rectangle, n13, n12, hashSet, sampleValues, integerList);
            }
            finally {
                writableRenderedImage.releaseWritableTile(n14, n15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fill(WritableRaster writableRaster, Raster raster, Raster raster2, Rectangle rectangle, int n, int n2, Set<SampleValues> set, SampleValues sampleValues, IntegerList integerList) {
        SampleValues sampleValues2 = sampleValues.instance();
        if (!set.contains(sampleValues2.getPixel(writableRaster, n, n2))) {
            return;
        }
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getHeight();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = n5 + n3 - 1;
        int n8 = n6 + n4 - 1;
        IntegerList integerList2 = new IntegerList(128, Math.max(n3, n4) - 1);
        while (true) {
            assert (n >= n5 && n <= n7) : n;
            assert (n2 >= n6 && n2 <= n8) : n2;
            do {
                if (--n >= n5) continue;
                if (!rectangle.contains(n, n2)) break;
                IntegerList integerList3 = integerList;
                synchronized (integerList3) {
                    integerList.addInteger(n - rectangle.x);
                    integerList.addInteger(n2 - rectangle.y);
                    break;
                }
            } while (set.contains(sampleValues2.getPixel(writableRaster, n, n2)));
            ++n;
            boolean bl = false;
            boolean bl2 = false;
            do {
                IntegerList integerList4;
                Raster raster3;
                sampleValues.setPixel(writableRaster, n, n2);
                boolean bl3 = true;
                boolean bl4 = bl;
                int n9 = n2 - 1;
                Raster raster4 = raster3 = n2 == n6 ? raster : writableRaster;
                while (true) {
                    if (raster3 != null && set.contains(sampleValues2.getPixel(raster3, n, n9)) != bl4 && (bl4 = !bl4)) {
                        if (raster3 == writableRaster) {
                            integerList2.addInteger(n - n5);
                            integerList2.addInteger(n9 - n6);
                        } else if (rectangle.contains(n, n9)) {
                            integerList4 = integerList;
                            synchronized (integerList4) {
                                integerList.addInteger(n - rectangle.x);
                                integerList.addInteger(n9 - rectangle.y);
                            }
                        }
                    }
                    if (!bl3) break;
                    bl3 = false;
                    bl = bl4;
                    bl4 = bl2;
                    n9 = n2 + 1;
                    raster3 = n2 == n8 ? raster2 : writableRaster;
                }
                bl2 = bl4;
                if (n++ != n7) continue;
                if (!rectangle.contains(n, n2)) break;
                integerList4 = integerList;
                synchronized (integerList4) {
                    integerList.addInteger(n - rectangle.x);
                    integerList.addInteger(n2 - rectangle.y);
                    break;
                }
            } while (set.contains(sampleValues2.getPixel(writableRaster, n, n2)));
            if (integerList2.isEmpty()) break;
            n2 = integerList2.removeLast() + n6;
            n = integerList2.removeLast() + n5;
        }
    }
}

