/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.jai;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import javax.vecmath.MismatchedSizeException;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.internal.image.ImageUtilities;

public class Combine
extends PointOpImage {
    public static final String OPERATION_NAME = "org.geotoolkit.Combine";
    final double[][] matrix;
    final int[][] sources;
    final int[][] bands;
    final int numSamples;
    protected final Transform transform;

    public Combine(Vector<? extends RenderedImage> vector, double[][] dArray, Transform transform, RenderingHints renderingHints) throws MismatchedSizeException {
        super(vector, ImageUtilities.createIntersection((ImageLayout)renderingHints.get(JAI.KEY_IMAGE_LAYOUT), vector), (Map)renderingHints, false);
        int n = dArray.length;
        dArray = (double[][])dArray.clone();
        this.matrix = dArray;
        this.sources = new int[n][];
        this.bands = new int[n][];
        this.transform = transform;
        int n2 = 0;
        int n3 = this.getNumSources();
        while (--n3 >= 0) {
            n2 += this.getSourceImage(n3).getNumBands();
        }
        this.numSamples = n2;
        n3 = transform == null || transform.isSeparable() ? 1 : 0;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            int n4 = dArray2.length;
            if (n4 != n2 + 1) {
                throw new MismatchedSizeException();
            }
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            int n8 = 0;
            double[] dArray3 = new double[n4];
            int[] nArray = new int[n4 - 1];
            int[] nArray2 = new int[n4 - 1];
            int n9 = nArray.length;
            for (int j = 0; j < n9; ++j) {
                if (++n6 >= n7) {
                    n6 = 0;
                    n7 = this.getSourceImage(++n5).getNumBands();
                }
                if (dArray2[j] == 0.0 && n3 != 0) continue;
                dArray3[n8] = dArray2[j];
                nArray[n8] = n5;
                nArray2[n8] = n6;
                ++n8;
            }
            dArray3[n8] = dArray2[dArray2.length - 1];
            this.matrix[i] = ArraysExt.resize((double[])dArray3, (int)(n8 + 1));
            this.sources[i] = ArraysExt.resize((int[])nArray, (int)n8);
            this.bands[i] = ArraysExt.resize((int[])nArray2, (int)n8);
        }
        if (this.getNumBands() != n) {
            throw new UnsupportedOperationException("Automatic derivation of SampleModel not yet implemented.");
        }
        this.permitInPlaceOperation();
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    public void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RectIter[] rectIterArray = new RectIter[planarImageArray.length];
        RectIter[] rectIterArray2 = new RectIter[this.numSamples];
        double[] dArray = null;
        int n = rectIterArray.length;
        for (int i = 0; i < n; ++i) {
            rectIterArray[i] = RectIterFactory.create((RenderedImage)planarImageArray[i], (Rectangle)this.mapDestRect(rectangle, i));
        }
        WritableRectIter writableRectIter = RectIterFactory.createWritable((WritableRaster)writableRaster, (Rectangle)rectangle);
        int n2 = 0;
        writableRectIter.startBands();
        boolean bl = writableRectIter.finishedBands();
        while (!bl) {
            int n3;
            double[] dArray2 = this.matrix[n2];
            int[] nArray = this.bands[n2];
            int[] nArray2 = this.sources[n2];
            int n4 = nArray2.length;
            if (n4 > this.numSamples || n4 > nArray.length || n4 >= dArray2.length) {
                throw new AssertionError(n4);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                rectIterArray2[n3] = rectIterArray[nArray2[n3]];
            }
            if (dArray == null || dArray.length != n4) {
                dArray = new double[n4];
            }
            writableRectIter.startLines();
            bl = writableRectIter.finishedLines();
            for (n3 = 0; n3 < rectIterArray.length; ++n3) {
                rectIterArray[n3].startLines();
                if (rectIterArray[n3].finishedLines() == bl) continue;
                throw new RasterFormatException("Missing lines");
            }
            while (!bl) {
                writableRectIter.startPixels();
                bl = writableRectIter.finishedPixels();
                for (n3 = 0; n3 < rectIterArray.length; ++n3) {
                    rectIterArray[n3].startPixels();
                    if (rectIterArray[n3].finishedPixels() == bl) continue;
                    throw new RasterFormatException("Missing pixels");
                }
                while (!bl) {
                    int n5;
                    for (n3 = 0; n3 < n4; ++n3) {
                        dArray[n3] = rectIterArray2[n3].getSampleDouble(nArray[n3]);
                    }
                    if (this.transform != null) {
                        this.transform.transformSamples(dArray);
                    }
                    double d = dArray2[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        d += dArray2[n5] * dArray[n5];
                    }
                    writableRectIter.setSample(d);
                    bl = writableRectIter.nextPixelDone();
                    for (n5 = 0; n5 < rectIterArray.length; ++n5) {
                        if (rectIterArray[n5].nextPixelDone() == bl) continue;
                        throw new RasterFormatException("Missing pixels");
                    }
                }
                bl = writableRectIter.nextLineDone();
                for (n3 = 0; n3 < rectIterArray.length; ++n3) {
                    if (rectIterArray[n3].nextLineDone() == bl) continue;
                    throw new RasterFormatException("Missing lines");
                }
            }
            ++n2;
            bl = writableRectIter.nextBandDone();
        }
    }

    public static class Dyadic
    extends Combine {
        private final double[] scales0;
        private final double[] scales1;
        private final double[] offsets;

        public Dyadic(Vector<? extends RenderedImage> vector, double[][] dArray, RenderingHints renderingHints) throws MismatchedSizeException {
            super(vector, dArray, null, renderingHints);
            if (this.getNumSources() != 2) {
                throw new IllegalArgumentException();
            }
            int n = this.getNumBands();
            this.scales0 = new double[n];
            this.scales1 = new double[n];
            this.offsets = new double[n];
            for (int i = 0; i < n; ++i) {
                double[] dArray2 = this.matrix[i];
                int[] nArray = this.sources[i];
                int[] nArray2 = this.bands[i];
                block5: for (int j = 0; j < nArray.length; ++j) {
                    double d = dArray2[j];
                    int n2 = nArray2[j];
                    int n3 = nArray[j];
                    if (n2 != i) {
                        throw new AssertionError(n2);
                    }
                    switch (n3) {
                        case 0: {
                            this.scales0[n2] = d;
                            continue block5;
                        }
                        case 1: {
                            this.scales1[n2] = d;
                            continue block5;
                        }
                        default: {
                            throw new AssertionError(n3);
                        }
                    }
                }
                this.offsets[i] = dArray2[nArray.length];
            }
        }

        @Override
        public void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
            RectIter rectIter = RectIterFactory.create((RenderedImage)planarImageArray[0], (Rectangle)this.mapDestRect(rectangle, 0));
            RectIter rectIter2 = RectIterFactory.create((RenderedImage)planarImageArray[1], (Rectangle)this.mapDestRect(rectangle, 1));
            WritableRectIter writableRectIter = RectIterFactory.createWritable((WritableRaster)writableRaster, (Rectangle)rectangle);
            int n = 0;
            rectIter.startBands();
            rectIter2.startBands();
            writableRectIter.startBands();
            if (!(writableRectIter.finishedBands() || rectIter.finishedBands() || rectIter2.finishedBands())) {
                double d = this.scales0[Math.min(n, this.scales0.length - 1)];
                double d2 = this.scales1[Math.min(n, this.scales1.length - 1)];
                double d3 = this.offsets[Math.min(n, this.offsets.length - 1)];
                do {
                    rectIter.startLines();
                    rectIter2.startLines();
                    writableRectIter.startLines();
                    if (!(writableRectIter.finishedLines() || rectIter.finishedLines() || rectIter2.finishedLines())) {
                        do {
                            rectIter.startPixels();
                            rectIter2.startPixels();
                            writableRectIter.startPixels();
                            if (writableRectIter.finishedPixels() || rectIter.finishedPixels() || rectIter2.finishedPixels()) continue;
                            do {
                                writableRectIter.setSample(rectIter.getSampleDouble() * d + rectIter2.getSampleDouble() * d2 + d3);
                            } while (!rectIter.nextPixelDone() && !rectIter2.nextPixelDone() && !writableRectIter.nextPixelDone());
                        } while (!rectIter.nextLineDone() && !rectIter2.nextLineDone() && !writableRectIter.nextLineDone());
                    }
                    ++n;
                } while (!rectIter.nextBandDone() && !rectIter2.nextBandDone() && !writableRectIter.nextBandDone());
            }
        }
    }

    public static interface Transform {
        public void transformSamples(double[] var1);

        public boolean isSeparable();
    }
}

