/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.imageio.ImageTypeSpecifier;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.image.io.PaletteDisposer;
import org.geotoolkit.image.io.PaletteFactory;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;

@Immutable
public abstract class Palette {
    final PaletteFactory factory;
    protected final String name;
    protected final int numBands;
    protected final int visibleBand;
    private transient SampleModel samples;
    private transient Reference<ColorModel> colors;
    private transient Reference<ImageTypeSpecifier> specifier;

    protected Palette(PaletteFactory paletteFactory, String string, int n, int n2) {
        ArgumentChecks.ensureNonNull((String)"factory", (Object)paletteFactory);
        if (string == null) {
            throw new NullArgumentException(paletteFactory.getErrorResources().getString(172, (Object)"name"));
        }
        this.ensureInsideBounds(n, 0, 255);
        this.ensureInsideBounds(n2, 0, n - 1);
        this.factory = paletteFactory;
        this.name = string.trim();
        this.numBands = n;
        this.visibleBand = n2;
    }

    final void ensureInsideBounds(int n, int n2, int n3) throws IllegalArgumentException {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException(this.factory.getErrorResources().getString(246, (Object)n, (Object)n2, (Object)n3));
        }
    }

    double getScale() {
        return 1.0;
    }

    double getOffset() {
        return 0.0;
    }

    public synchronized ColorModel getColorModel() throws FileNotFoundException, IOException {
        ColorModel colorModel;
        if (this.colors != null && (colorModel = this.colors.get()) != null) {
            return colorModel;
        }
        return this.getImageTypeSpecifier().getColorModel();
    }

    public synchronized ImageTypeSpecifier getImageTypeSpecifier() throws FileNotFoundException, IOException {
        Object object;
        if (this.specifier != null && (object = this.specifier.get()) != null) {
            return object;
        }
        if (this.samples != null && this.colors != null && (object = this.colors.get()) != null) {
            ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier((ColorModel)object, this.samples);
            this.specifier = new WeakReference<ImageTypeSpecifier>(imageTypeSpecifier);
            return imageTypeSpecifier;
        }
        object = this.createImageTypeSpecifier();
        this.samples = ((ImageTypeSpecifier)object).getSampleModel();
        this.colors = new PaletteDisposer(this, ((ImageTypeSpecifier)object).getColorModel());
        this.specifier = new WeakReference<Object>(object);
        return object;
    }

    protected abstract ImageTypeSpecifier createImageTypeSpecifier() throws FileNotFoundException, IOException;

    public RenderedImage getImage(Dimension dimension) throws IOException {
        int n;
        boolean bl;
        IndexColorModel indexColorModel = (IndexColorModel)this.getColorModel();
        WritableRaster writableRaster = indexColorModel.createCompatibleWritableRaster(dimension.width, dimension.height);
        BufferedImage bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int n4 = writableRaster.getWidth();
        int n5 = writableRaster.getHeight();
        boolean bl2 = bl = dimension.width >= dimension.height;
        if (!bl) {
            n = n2;
            n2 = n3;
            n3 = n;
            n = n4;
            n4 = n5;
            n5 = n;
        }
        n = n2 + n4;
        int n6 = n3 + n5;
        double d = this.getScale() / (double)n4;
        double d2 = this.getOffset();
        for (int i = n2; i < n; ++i) {
            double d3 = d2 + d * (double)(i - n2);
            for (int j = n3; j < n6; ++j) {
                if (bl) {
                    writableRaster.setSample(i, j, 0, d3);
                    continue;
                }
                writableRaster.setSample(j, i, 0, d3);
            }
        }
        return bufferedImage;
    }

    public RenderedImage getLegend(Dimension dimension) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        Color[] colorArray = this.factory.getColors(this.name);
        float[] fArray = new float[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            fArray[i] = (float)i / (float)(colorArray.length - 1);
        }
        float f = (float)dimension.height * 0.5f;
        graphics2D.setPaint(new LinearGradientPaint(0.0f, f, dimension.width, f, fArray, colorArray));
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setColor(Color.WHITE);
        Font font = new Font("Dialog", 1, 13);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics(font).getStringBounds(this.name, graphics2D);
        graphics2D.setFont(font);
        graphics2D.drawString(this.name, (float)((double)dimension.width - rectangle2D.getWidth()) / 2.0f, (float)((double)dimension.height + rectangle2D.getHeight()) / 2.0f);
        graphics2D.dispose();
        return bufferedImage;
    }

    public int hashCode() {
        return this.name.hashCode() + 31 * this.numBands + this.visibleBand;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Palette palette = (Palette)object;
            return this.numBands == palette.numBands && this.visibleBand == palette.visibleBand && Utilities.equals((Object)this.name, (Object)palette.name);
        }
        return false;
    }
}

