/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io;

import java.io.Serializable;
import java.util.EventListener;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.swing.event.EventListenerList;
import net.jcip.annotations.ThreadSafe;
import org.apache.sis.util.ArraysExt;

@ThreadSafe
public class IIOListeners
implements Serializable {
    private static final long serialVersionUID = 3747976429353858766L;
    private static final Class<?>[] READ = new Class[]{IIOReadProgressListener.class, IIOReadWarningListener.class, IIOReadUpdateListener.class};
    private static final Class<?>[] WRITE = new Class[]{IIOWriteProgressListener.class, IIOWriteWarningListener.class};
    private final List listeners = new List();

    public void setListeners(IIOListeners iIOListeners) {
        this.listeners.setTo(iIOListeners.listeners);
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.listeners.add(IIOReadProgressListener.class, iIOReadProgressListener);
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.listeners.remove(IIOReadProgressListener.class, iIOReadProgressListener);
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        this.listeners.add(IIOReadUpdateListener.class, iIOReadUpdateListener);
    }

    public void removeIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        this.listeners.remove(IIOReadUpdateListener.class, iIOReadUpdateListener);
    }

    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        this.listeners.add(IIOReadWarningListener.class, iIOReadWarningListener);
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        this.listeners.remove(IIOReadWarningListener.class, iIOReadWarningListener);
    }

    public void addIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        this.listeners.add(IIOWriteProgressListener.class, iIOWriteProgressListener);
    }

    public void removeIIOWriteProgressListener(IIOWriteProgressListener iIOWriteProgressListener) {
        this.listeners.remove(IIOWriteProgressListener.class, iIOWriteProgressListener);
    }

    public void addIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        this.listeners.add(IIOWriteWarningListener.class, iIOWriteWarningListener);
    }

    public void removeIIOWriteWarningListener(IIOWriteWarningListener iIOWriteWarningListener) {
        this.listeners.remove(IIOWriteWarningListener.class, iIOWriteWarningListener);
    }

    public EventListener[] getReadListeners() {
        return this.getListeners(READ);
    }

    public EventListener[] getWriteListeners() {
        return this.getListeners(WRITE);
    }

    private EventListener[] getListeners(Class<?>[] classArray) {
        int n = 0;
        Object[] objectArray = this.listeners.getListenerList();
        Object[] objectArray2 = new EventListener[objectArray.length / 2];
        block0: for (int i = 0; i < objectArray.length; i += 2) {
            Class clazz = (Class)objectArray[i];
            int n2 = classArray.length;
            while (--n2 >= 0) {
                if (!clazz.equals(classArray[i])) continue;
                EventListener eventListener = (EventListener)objectArray[i + 1];
                int n3 = n;
                while (--n3 >= 0) {
                    if (objectArray2[n3] != eventListener) continue;
                    continue block0;
                }
                objectArray2[n++] = eventListener;
                continue block0;
            }
        }
        return (EventListener[])ArraysExt.resize((Object[])objectArray2, (int)n);
    }

    public void addListenersTo(ImageReader imageReader) {
        this.manageListeners(imageReader, true);
    }

    public void addListenersTo(ImageWriter imageWriter) {
        this.manageListeners(imageWriter, true);
    }

    public void removeListenersFrom(ImageReader imageReader) {
        this.manageListeners(imageReader, false);
    }

    public void removeListenersFrom(ImageWriter imageWriter) {
        this.manageListeners(imageWriter, false);
    }

    private void manageListeners(ImageReader imageReader, boolean bl) {
        Object[] objectArray = this.listeners.getListenerList();
        int n = 0;
        while (n < objectArray.length) {
            EventListener eventListener;
            Object object = objectArray[n++];
            Object object2 = objectArray[n++];
            if (object == IIOReadProgressListener.class) {
                eventListener = (IIOReadProgressListener)object2;
                imageReader.removeIIOReadProgressListener((IIOReadProgressListener)eventListener);
                if (!bl) continue;
                imageReader.addIIOReadProgressListener((IIOReadProgressListener)eventListener);
                continue;
            }
            if (object == IIOReadUpdateListener.class) {
                eventListener = (IIOReadUpdateListener)object2;
                imageReader.removeIIOReadUpdateListener((IIOReadUpdateListener)eventListener);
                if (!bl) continue;
                imageReader.addIIOReadUpdateListener((IIOReadUpdateListener)eventListener);
                continue;
            }
            if (object != IIOReadWarningListener.class) continue;
            eventListener = (IIOReadWarningListener)object2;
            imageReader.removeIIOReadWarningListener((IIOReadWarningListener)eventListener);
            if (!bl) continue;
            imageReader.addIIOReadWarningListener((IIOReadWarningListener)eventListener);
        }
    }

    private void manageListeners(ImageWriter imageWriter, boolean bl) {
        Object[] objectArray = this.listeners.getListenerList();
        int n = 0;
        while (n < objectArray.length) {
            EventListener eventListener;
            Object object = objectArray[n++];
            Object object2 = objectArray[n++];
            if (object == IIOWriteProgressListener.class) {
                eventListener = (IIOWriteProgressListener)object2;
                imageWriter.removeIIOWriteProgressListener((IIOWriteProgressListener)eventListener);
                if (!bl) continue;
                imageWriter.addIIOWriteProgressListener((IIOWriteProgressListener)eventListener);
                continue;
            }
            if (object != IIOWriteWarningListener.class) continue;
            eventListener = (IIOWriteWarningListener)object2;
            imageWriter.removeIIOWriteWarningListener((IIOWriteWarningListener)eventListener);
            if (!bl) continue;
            imageWriter.addIIOWriteWarningListener((IIOWriteWarningListener)eventListener);
        }
    }

    private static final class List
    extends EventListenerList {
        private static final long serialVersionUID = 3398556089737845953L;

        private List() {
        }

        final void setTo(EventListenerList eventListenerList) {
            this.listenerList = eventListenerList.getListenerList();
        }
    }
}

