/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import javax.media.jai.ColorCube;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.operator.AddConstDescriptor;
import javax.media.jai.operator.AddDescriptor;
import javax.media.jai.operator.BandCombineDescriptor;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.BinarizeDescriptor;
import javax.media.jai.operator.ColorConvertDescriptor;
import javax.media.jai.operator.DivideByConstDescriptor;
import javax.media.jai.operator.DivideDescriptor;
import javax.media.jai.operator.ErrorDiffusionDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.MultiplyDescriptor;
import javax.media.jai.operator.NullDescriptor;
import javax.media.jai.operator.OrderedDitherDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import javax.media.jai.operator.SubtractConstDescriptor;
import javax.media.jai.operator.SubtractDescriptor;
import javax.media.jai.operator.XorConstDescriptor;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.image.ColorQuantization;
import org.geotoolkit.image.ImageInspector;
import org.geotoolkit.internal.image.ColorModels;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.internal.image.LookupTables;
import org.geotoolkit.resources.Errors;
import org.opengis.coverage.PaletteInterpretation;

@Deprecated
public class ImageWorker
extends ImageInspector {
    public static final Hints.Key COLOR_QUANTIZATION = new Hints.Key(ColorQuantization.class);
    public static final Hints.Key TILING_ALLOWED = new Hints.Key(Boolean.class);

    public ImageWorker(RenderedImage renderedImage) {
        super(renderedImage);
    }

    ImageWorker(ImageInspector imageInspector) {
        super(imageInspector);
    }

    public void tile() {
        RenderingHints renderingHints;
        ImageLayout imageLayout;
        if (!this.isTiled() && ((imageLayout = ImageWorker.getImageLayout(renderingHints = this.getRenderingHints())).isValid(64) || imageLayout.isValid(128))) {
            int n = this.image.getSampleModel().getDataType();
            this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)n, (RenderingHints)renderingHints);
        }
    }

    public void format(int n, boolean bl) {
        int n2 = this.image.getSampleModel().getDataType();
        if (n == n2) {
            return;
        }
        if (!bl || ImageUtilities.isFloatType(n)) {
            this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)n, (RenderingHints)this.getRenderingHints());
            if (ImageUtilities.typeForBoth(n, n2) != n2) {
                this.invalidateStatistics();
            }
        } else {
            double d = ImageUtilities.minimum(n);
            double d2 = ImageUtilities.maximum(n);
            if (d == 0.0 && ImageUtilities.isFloatType(n2)) {
                d = 1.0;
            }
            double[][] dArray = this.getExtremas();
            int n3 = dArray[0].length;
            double[] dArray2 = new double[n3];
            double[] dArray3 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                double d3;
                double d4 = dArray[0][i];
                double d5 = dArray[1][i];
                dArray2[i] = d3 = (d2 - d) / (d5 - d4);
                dArray3[i] = d - d3 * d4;
            }
            RenderingHints renderingHints = this.getRenderingHints(n);
            this.image = RescaleDescriptor.create((RenderedImage)this.image, (double[])dArray2, (double[])dArray3, (RenderingHints)renderingHints);
            this.invalidateStatistics();
        }
        assert (this.image.getSampleModel().getDataType() == n);
    }

    private void forceIndexColorModel() {
        if (this.image.getColorModel() instanceof IndexColorModel) {
            return;
        }
        this.enableTileCache(false);
        this.setColorSpaceType(PaletteInterpretation.RGB);
        if (this.image.getColorModel().hasAlpha()) {
            this.retainBands(0, -2);
        }
        this.enableTileCache(true);
        RenderingHints renderingHints = this.getRenderingHints();
        ColorQuantization colorQuantization = (ColorQuantization)((Object)renderingHints.get(COLOR_QUANTIZATION));
        if (colorQuantization == null) {
            colorQuantization = ColorQuantization.ERROR_DIFFUSION;
        }
        ColorCube colorCube = ColorCube.BYTE_496;
        switch (colorQuantization) {
            case ERROR_DIFFUSION: {
                KernelJAI kernelJAI = KernelJAI.ERROR_FILTER_FLOYD_STEINBERG;
                this.image = ErrorDiffusionDescriptor.create((RenderedImage)this.image, (LookupTableJAI)colorCube, (KernelJAI)kernelJAI, (RenderingHints)renderingHints);
                break;
            }
            case ORDERED_DITHER: {
                KernelJAI[] kernelJAIArray = KernelJAI.DITHER_MASK_443;
                this.image = OrderedDitherDescriptor.create((RenderedImage)this.image, (ColorCube)colorCube, (KernelJAI[])kernelJAIArray, (RenderingHints)renderingHints);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((int)73, (Object)"method", (Object)((Object)colorQuantization)));
            }
        }
        this.invalidateStatistics();
        assert (this.isIndexed());
    }

    public void forceBitmaskIndexColorModel(int n) {
        ColorModel colorModel = this.image.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            int n2;
            int n3;
            int n4;
            int n5;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            if (n < 0) {
                n = indexColorModel.getTransparentPixel();
            }
            if (indexColorModel.getTransparency() == 2 && indexColorModel.getTransparentPixel() == n) {
                return;
            }
            if (n < 0) {
                n5 = 256;
                n4 = indexColorModel.getMapSize();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = indexColorModel.getAlpha(n3);
                    if (n2 >= n5) continue;
                    n5 = n2;
                    n = n3;
                }
            }
            n5 = indexColorModel.getPixelSize();
            n4 = indexColorModel.getMapSize();
            n3 = Math.max(n4, (n &= (1 << n5) - 1) + 1);
            n2 = n3 > 256 ? 1 : 0;
            Object[] objectArray = n2 != 0 ? new short[n4] : (Object[])new byte[n4];
            boolean bl = false;
            for (int i = 0; i < n4; ++i) {
                int n6;
                int n7 = n6 = indexColorModel.getAlpha(i) == 0 ? n : i;
                if (n2 != 0) {
                    objectArray[i] = (short)n6;
                } else {
                    ((byte[])objectArray)[i] = (byte)n6;
                }
                bl |= n6 != i;
            }
            int[] nArray = new int[n3];
            indexColorModel.getRGBs(nArray);
            IndexColorModel indexColorModel2 = ColorModels.unique(new IndexColorModel(n5, n3, nArray, 0, false, n, ColorUtilities.getTransferType(n3)));
            if (!bl) {
                this.image = ImageUtilities.replaceColorModel(this.image, indexColorModel2);
                return;
            }
            LookupTableJAI lookupTableJAI = n2 != 0 ? new LookupTableJAI(objectArray, true) : new LookupTableJAI((byte[])objectArray);
            RenderingHints renderingHints = this.getRenderingHints();
            this.setColorModel(renderingHints, indexColorModel2);
            renderingHints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)lookupTableJAI, (RenderingHints)renderingHints);
        } else {
            Object object;
            Object object2;
            RenderedImage renderedImage = null;
            if (colorModel.hasAlpha()) {
                object2 = new ImageWorker(this);
                ((ImageInspector)object2).enableTileCache(false);
                ((ImageWorker)object2).retainBands(-1, -1);
                ((ImageWorker)object2).binarize(false);
                ((ImageWorker)object2).xor(new int[]{-1});
                renderedImage = ((ImageWorker)object2).image;
            }
            this.enableTileCache(false);
            this.forceIndexColorModel();
            this.enableTileCache(true);
            if (n < 0) {
                n = 0;
            }
            if (((IndexColorModel)(object2 = (IndexColorModel)this.image.getColorModel())).getAlpha(n) != 0) {
                object = new int[((IndexColorModel)object2).getMapSize()];
                ((IndexColorModel)object2).getRGBs((int[])object);
                object2 = new IndexColorModel(((ColorModel)object2).getPixelSize(), ((Object)object).length, (int[])object, 0, ((ColorModel)object2).hasAlpha(), n, ((ColorModel)object2).getTransferType());
            }
            object = this.getRenderingHints();
            this.setColorModel((RenderingHints)object, (ColorModel)object2);
            this.image = renderedImage != null ? JAI.create((String)"org.geotoolkit.Mask", (ParameterBlock)new ParameterBlockJAI("org.geotoolkit.Mask").addSource((Object)this.image).addSource(renderedImage).set(new double[]{n}, 0), (RenderingHints)object) : NullDescriptor.create((RenderedImage)this.image, (RenderingHints)object);
        }
        this.invalidateStatistics();
        assert (this.isIndexed());
        assert (!this.isTranslucent());
    }

    private void forceComponentColorModel() {
        ColorModel colorModel = this.image.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            return;
        }
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            RenderingHints renderingHints = this.getRenderingHints();
            Boolean bl = (Boolean)renderingHints.get(IGNORE_FULLY_TRANSPARENT_PIXELS);
            if (bl == null) {
                bl = Boolean.TRUE;
            }
            boolean bl2 = ColorUtilities.isGrayPalette(indexColorModel, bl);
            boolean bl3 = indexColorModel.hasAlpha();
            int n = bl2 ? 1 : 3;
            byte[][] byArray = new byte[bl3 ? n + 1 : n][indexColorModel.getMapSize()];
            switch (n) {
                default: {
                    indexColorModel.getBlues(byArray[2]);
                }
                case 2: {
                    indexColorModel.getGreens(byArray[1]);
                }
                case 1: {
                    indexColorModel.getReds(byArray[0]);
                }
                case 0: 
            }
            if (bl3) {
                indexColorModel.getAlphas(byArray[n]);
            }
            LookupTableJAI lookupTableJAI = new LookupTableJAI(byArray);
            this.setColorModel(renderingHints, new ComponentColorModel(ColorSpace.getInstance(bl2 ? 1003 : 1000), bl3, colorModel.isAlphaPremultiplied(), colorModel.getTransparency(), colorModel.getTransferType()));
            this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)lookupTableJAI, (RenderingHints)renderingHints);
        } else {
            int n = colorModel instanceof DirectColorModel ? 0 : this.image.getSampleModel().getTransferType();
            RenderingHints renderingHints = this.getRenderingHints(n);
            this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)n, (RenderingHints)renderingHints);
        }
        this.invalidateStatistics();
        assert (this.image.getColorModel() instanceof ComponentColorModel);
    }

    public void setColorModelType(Class<? extends ColorModel> clazz) {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        if (IndexColorModel.class.isAssignableFrom(clazz)) {
            this.forceIndexColorModel();
        } else if (ComponentColorModel.class.isAssignableFrom(clazz)) {
            this.forceComponentColorModel();
        } else {
            throw new IllegalArgumentException(Errors.format((int)226, clazz));
        }
    }

    public void setColorSpaceType(PaletteInterpretation paletteInterpretation) {
        ArgumentChecks.ensureNonNull((String)"type", (Object)paletteInterpretation);
        if (!paletteInterpretation.equals((Object)this.getColorSpaceType())) {
            ColorSpace colorSpace;
            this.forceComponentColorModel();
            if (paletteInterpretation.equals((Object)PaletteInterpretation.RGB)) {
                colorSpace = ColorSpace.getInstance(1000);
            } else if (paletteInterpretation.equals((Object)PaletteInterpretation.GRAY)) {
                colorSpace = ColorSpace.getInstance(1003);
            } else if (paletteInterpretation.equals((Object)IHS)) {
                colorSpace = IHSColorSpace.getInstance();
            } else {
                throw new UnsupportedOperationException(paletteInterpretation.toString());
            }
            int[] nArray = new int[colorSpace.getNumComponents()];
            int n = this.image.getSampleModel().getDataType();
            Arrays.fill(nArray, DataBuffer.getDataTypeSize(n));
            ColorModel colorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, n);
            RenderingHints renderingHints = this.getRenderingHints();
            colorModel = this.setColorModel(renderingHints, colorModel);
            this.image = ColorConvertDescriptor.create((RenderedImage)this.image, (ColorModel)colorModel, (RenderingHints)renderingHints);
            this.invalidateStatistics();
        }
        assert (paletteInterpretation.equals((Object)this.getColorSpaceType()));
    }

    public void intensity() {
        int n;
        Object[] objectArray;
        PaletteInterpretation paletteInterpretation = this.getColorSpaceType();
        if (paletteInterpretation != null && (paletteInterpretation.equals((Object)PaletteInterpretation.GRAY) || paletteInterpretation.equals((Object)IHS))) {
            this.retainBands(0, 0);
            this.invalidateStatistics();
            return;
        }
        this.enableTileCache(false);
        this.setColorSpaceType(PaletteInterpretation.RGB);
        this.enableTileCache(true);
        ColorModel colorModel = this.image.getColorModel();
        RenderingHints renderingHints = this.getRenderingHints();
        this.setColorModel(renderingHints, new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0));
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            objectArray = new byte[indexColorModel.getMapSize()];
            for (int i = 0; i < objectArray.length; ++i) {
                int n2 = indexColorModel.getRGB(i) & 0xFFFFFF;
                objectArray[i] = (byte)(((n2 & 0xFF) + (n2 >>> 8 & 0xFF) + (n2 >>> 16 & 0xFF)) / 3);
            }
            if (!LookupTables.isIdentity(objectArray)) {
                LookupTableJAI lookupTableJAI = new LookupTableJAI(objectArray);
                this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)lookupTableJAI, (RenderingHints)renderingHints);
                this.invalidateStatistics();
                return;
            }
        }
        if ((n = colorModel.getNumColorComponents()) == 1) {
            this.retainBands(0, 0);
            if (!PaletteInterpretation.GRAY.equals((Object)this.getColorSpaceType())) {
                this.image = NullDescriptor.create((RenderedImage)this.image, (RenderingHints)renderingHints);
            }
            return;
        }
        objectArray = new double[colorModel.getNumComponents() + 1];
        Arrays.fill((double[])objectArray, 0, n, 1.0 / (double)n);
        this.image = BandCombineDescriptor.create((RenderedImage)this.image, (double[][])new double[][]{objectArray}, (RenderingHints)renderingHints);
        this.invalidateStatistics();
        assert (this.getNumBands() == 1);
    }

    public void mergeBands(RenderedImage renderedImage, int n) {
        ArgumentChecks.ensureNonNull((String)"toAdd", (Object)renderedImage);
        int n2 = this.getNumBands();
        if (n < 0) {
            n += n2 + 1;
        }
        ArgumentChecks.ensureValidIndex((int)(n2 + 1), (int)n);
        if (n == 0) {
            this.image = BandMergeDescriptor.create((RenderedImage)renderedImage, (RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        } else if (n == n2) {
            this.image = BandMergeDescriptor.create((RenderedImage)this.image, (RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
        } else {
            this.enableTileCache(false);
            RenderedImage renderedImage2 = this.image;
            this.retainBands(0, n - 1);
            this.mergeBands(renderedImage, n);
            renderedImage = this.image;
            this.image = renderedImage2;
            this.retainBands(n, -1);
            this.enableTileCache(true);
            this.mergeBands(renderedImage, 0);
        }
        this.invalidateStatistics();
    }

    public void retainBands(int n, int n2) {
        int n3 = this.getNumBands();
        if (n < 0) {
            n += n3;
        }
        if (n2 < 0) {
            n2 += n3;
        }
        if (n < 0 || n2 < n || n2 >= n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)14, (Object)n, (Object)n2));
        }
        int n4 = n2 - n + 1;
        if (n4 != n3) {
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = n++;
            }
            this.image = BandSelectDescriptor.create((RenderedImage)this.image, (int[])nArray, (RenderingHints)this.getRenderingHints());
        }
        assert (this.getNumBands() <= n3);
    }

    public void retainBands(int[] nArray) {
        this.image = BandSelectDescriptor.create((RenderedImage)this.image, (int[])nArray, (RenderingHints)this.getRenderingHints());
    }

    public void binarize(boolean bl) {
        if (!this.isBinary()) {
            double d;
            double d2;
            if (this.getNumBands() != 1) {
                this.enableTileCache(false);
                this.intensity();
                this.enableTileCache(true);
            }
            if (bl) {
                double[][] dArray = this.getExtremas();
                d2 = dArray[0][0];
                d = dArray[1][0];
            } else {
                int n = this.image.getSampleModel().getDataType();
                if (ImageUtilities.isFloatType(n)) {
                    d2 = 0.0;
                    d = 1.0;
                } else {
                    d2 = ImageUtilities.minimum(n);
                    d = ImageUtilities.maximum(n);
                }
            }
            this.binarize((d2 + d) / 2.0);
        }
        assert (this.isBinary());
    }

    public void binarize(double d) {
        if (d <= 0.0 || d > 1.0 || !this.isBinary()) {
            if (this.getNumBands() != 1) {
                this.enableTileCache(false);
                this.intensity();
                this.enableTileCache(true);
            }
            RenderingHints renderingHints = this.getRenderingHints();
            this.image = BinarizeDescriptor.create((RenderedImage)this.image, (Double)d, (RenderingHints)renderingHints);
            this.invalidateStatistics();
        }
        assert (this.isBinary());
    }

    public void binarize(double d, double d2) {
        LookupTableJAI lookupTableJAI;
        this.enableTileCache(false);
        this.binarize(true);
        this.enableTileCache(true);
        int n = (int)d;
        int n2 = (int)d2;
        if ((double)n == d && (double)n2 == d2) {
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            lookupTableJAI = n3 >= 0 ? (n4 <= 255 ? new LookupTableJAI(new byte[]{(byte)n, (byte)n2}) : (n4 <= 65535 ? new LookupTableJAI(new short[]{(short)n, (short)n2}, true) : new LookupTableJAI(new int[]{n, n2}))) : (n3 >= Short.MIN_VALUE && n4 <= Short.MAX_VALUE ? new LookupTableJAI(new short[]{(short)n, (short)n2}, false) : new LookupTableJAI(new int[]{n, n2}));
        } else {
            float f = (float)d;
            float f2 = (float)d2;
            lookupTableJAI = Double.doubleToRawLongBits(f) == Double.doubleToRawLongBits(d) && Double.doubleToRawLongBits(f2) == Double.doubleToRawLongBits(d2) ? new LookupTableJAI(new float[]{f, f2}) : new LookupTableJAI(new double[]{d, d2});
        }
        RenderingHints renderingHints = this.getRenderingHints();
        this.setColorModel(renderingHints, new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, lookupTableJAI.getDataType()));
        this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)lookupTableJAI, (RenderingHints)renderingHints);
        this.invalidateStatistics();
    }

    public void maskBackground(double[][] dArray, double[] dArray2) {
        ArgumentChecks.ensureNonNull((String)"background", (Object)dArray);
        switch (dArray.length) {
            case 0: {
                return;
            }
            case 1: {
                if (!Arrays.equals(dArray[0], dArray2)) break;
                return;
            }
        }
        Object object = JAI.create((String)"org.geotoolkit.SilhouetteMask", (ParameterBlock)new ParameterBlockJAI("org.geotoolkit.SilhouetteMask").addSource((Object)this.image).set(dArray, 0), (RenderingHints)this.getRenderingHints());
        if (dArray2 == null) {
            ColorModel colorModel = this.image.getColorModel();
            if (colorModel instanceof IndexColorModel) {
                int n;
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                switch (indexColorModel.getTransparency()) {
                    case 1: {
                        double[] dArray3;
                        if (dArray.length != 0 && (dArray3 = dArray[0]).length != 0) {
                            n = (int)dArray3[0];
                            break;
                        }
                    }
                    default: {
                        n = indexColorModel.getTransparentPixel();
                    }
                }
                this.forceBitmaskIndexColorModel(n);
                dArray2 = new double[]{this.getTransparentPixel()};
            } else {
                if (!colorModel.hasAlpha()) {
                    int n = this.image.getSampleModel().getDataType();
                    double d = ImageUtilities.isFloatType(n) ? 1.0 : ImageUtilities.maximum(n);
                    ImageWorker imageWorker = new ImageWorker(this);
                    imageWorker.setImage((RenderedImage)object);
                    imageWorker.enableTileCache(false);
                    imageWorker.binarize(d, 0.0);
                    object = imageWorker.image;
                    this.mergeBands((RenderedImage)object, -1);
                    return;
                }
                dArray2 = new double[colorModel.getNumComponents()];
            }
        }
        this.mask((RenderedImage)object, dArray2);
    }

    public void mask(RenderedImage renderedImage, double[] dArray) {
        ArgumentChecks.ensureNonNull((String)"mask", (Object)renderedImage);
        this.image = JAI.create((String)"org.geotoolkit.Mask", (ParameterBlock)new ParameterBlockJAI("org.geotoolkit.Mask").addSource((Object)this.image).addSource(renderedImage).set(dArray, 0), (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void add(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull((String)"toAdd", (Object)renderedImage);
        this.image = AddDescriptor.create((RenderedImage)this.image, (RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void add(double[] dArray) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)dArray);
        this.image = AddConstDescriptor.create((RenderedImage)this.image, (double[])dArray, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void subtract(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull((String)"toSubtract", (Object)renderedImage);
        this.image = SubtractDescriptor.create((RenderedImage)this.image, (RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void subtract(double[] dArray) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)dArray);
        this.image = SubtractConstDescriptor.create((RenderedImage)this.image, (double[])dArray, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void multiply(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull((String)"toMultiply", (Object)renderedImage);
        this.image = MultiplyDescriptor.create((RenderedImage)this.image, (RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void multiply(double[] dArray) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)dArray);
        this.image = MultiplyConstDescriptor.create((RenderedImage)this.image, (double[])dArray, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void divide(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull((String)"toDivide", (Object)renderedImage);
        this.image = DivideDescriptor.create((RenderedImage)this.image, (RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void divideBy(double[] dArray) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)dArray);
        this.image = DivideByConstDescriptor.create((RenderedImage)this.image, (double[])dArray, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void invert() {
        this.image = InvertDescriptor.create((RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }

    public void xor(int[] nArray) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)nArray);
        this.image = XorConstDescriptor.create((RenderedImage)this.image, (int[])nArray, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
    }
}

