/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image;

import java.awt.Dimension;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.geotoolkit.util.converter.Classes;

public class ImageDimension
extends Dimension {
    private static final long serialVersionUID = -4349573462196081362L;
    public int numBands;
    private final int dataType;

    public ImageDimension(RenderedImage renderedImage) {
        super(renderedImage.getWidth(), renderedImage.getHeight());
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBands = sampleModel.getNumBands();
        this.dataType = sampleModel.getDataType();
    }

    public ImageDimension(Raster raster) {
        super(raster.getWidth(), raster.getHeight());
        this.numBands = raster.getNumBands();
        this.dataType = raster.getDataBuffer().getDataType();
    }

    public long getNumSampleValues() {
        return (long)this.width * (long)this.height * (long)this.numBands;
    }

    public long getMemoryUsage() {
        return this.getNumSampleValues() * (long)(DataBuffer.getDataTypeSize(this.dataType) / 8);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof ImageDimension) {
            ImageDimension imageDimension = (ImageDimension)object;
            return this.numBands == imageDimension.numBands && this.dataType == imageDimension.dataType;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.numBands;
    }

    @Override
    public String toString() {
        return Classes.getShortClassName((Object)this) + "[width=" + this.width + ", height=" + this.height + ", numBands=" + this.numBands + ']';
    }
}

