/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.collection.WeakValueHashMap;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

public final class DeferredPlanarImage
extends PlanarImage
implements WritableRenderedImage,
TileObserver,
TileComputationListener,
Disposable {
    private static final Logger LOGGER = Logging.getLogger(DeferredPlanarImage.class);
    private static final int BOX_THICKNESS = 2;
    private static Map<Entry, DataBuffer> buffers;
    private static final long DELAY = 500L;
    private final int delay;
    private final PlanarImage image = this.getSourceImage(0);
    private TileObserver[] observers;
    private transient TileRequest[] requests;
    private transient boolean[] waitings;
    private transient Raster[] pendings;

    public DeferredPlanarImage(RenderedImage renderedImage) {
        super(new ImageLayout(renderedImage), DeferredPlanarImage.toVector(renderedImage), null);
        this.image.addTileComputationListener((TileComputationListener)this);
        if (this.image instanceof WritableRenderedImage) {
            ((WritableRenderedImage)this.image).addTileObserver(this);
        }
        this.delay = (int)Math.min(500L * (long)this.tileWidth * (long)this.tileHeight / 1000000L, 500L);
    }

    private static Vector<RenderedImage> toVector(RenderedImage renderedImage) {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(renderedImage);
        return vector;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    private int getTileIndice(int n, int n2) {
        assert (n >= this.getMinTileX() && n <= this.getMaxTileX()) : n;
        assert (n2 >= this.getMinTileY() && n2 <= this.getMaxTileY()) : n2;
        return (n2 - this.getMinTileY()) * this.getNumXTiles() + (n - this.getMinTileX());
    }

    @Override
    public synchronized Raster getTile(int n, int n2) {
        Raster raster;
        Serializable serializable;
        int n3;
        TileRequest tileRequest;
        if (this.requests == null) {
            this.requests = new TileRequest[this.getNumXTiles() * this.getNumYTiles()];
        }
        if ((tileRequest = this.requests[n3 = this.getTileIndice(n, n2)]) == null) {
            this.requests[n3] = tileRequest = this.image.queueTiles(new Point[]{new Point(n, n2)});
        }
        switch (tileRequest.getTileStatus(n, n2)) {
            default: {
                LOGGER.warning("Unknow tile status");
            }
            case 2: 
            case 3: 
            case 4: {
                return this.image.getTile(n, n2);
            }
            case 0: 
            case 1: 
        }
        if (this.pendings != null && this.pendings[n3] != null) {
            return this.pendings[n3];
        }
        if (this.delay != 0) {
            if (this.waitings == null) {
                this.waitings = new boolean[this.requests.length];
            }
            this.waitings[n3] = true;
            try {
                this.wait(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waitings[n3] = false;
            switch (tileRequest.getTileStatus(n, n2)) {
                default: {
                    return this.image.getTile(n, n2);
                }
                case 0: 
                case 1: 
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            serializable = Loggings.format((Level)Level.FINER, (int)21, (Object)n, (Object)n2);
            ((LogRecord)serializable).setSourceClassName(DeferredPlanarImage.class.getName());
            ((LogRecord)serializable).setSourceMethodName("getTile");
            ((LogRecord)serializable).setLoggerName(LOGGER.getName());
            LOGGER.log((LogRecord)serializable);
        }
        if (this.pendings == null) {
            this.pendings = new Raster[this.requests.length];
        }
        serializable = new Point(this.tileXToX(n), this.tileYToY(n2));
        DataBuffer dataBuffer = DeferredPlanarImage.getDefaultDataBuffer(this.sampleModel, this.colorModel);
        this.pendings[n3] = raster = Raster.createRaster(this.sampleModel, dataBuffer, (Point)serializable);
        this.fireTileUpdate(n, n2, true);
        return raster;
    }

    private static synchronized DataBuffer getDefaultDataBuffer(SampleModel sampleModel, ColorModel colorModel) {
        int n;
        DataBuffer dataBuffer;
        Object object;
        int n2 = 0;
        int n3 = 0;
        if (colorModel instanceof IndexColorModel) {
            object = (IndexColorModel)colorModel;
            n2 = ColorUtilities.getTransparentPixel((IndexColorModel)object);
            n3 = Math.min(sampleModel.getWidth(), sampleModel.getHeight()) >= 64 ? ColorUtilities.getColorIndex((IndexColorModel)object, Color.DARK_GRAY, n2) : n2;
        }
        object = new Entry(sampleModel, n2, n3);
        if (buffers == null) {
            buffers = new WeakValueHashMap();
        }
        if ((dataBuffer = buffers.get(object)) != null) {
            return dataBuffer;
        }
        dataBuffer = sampleModel.createDataBuffer();
        if (n2 > 0) {
            n = dataBuffer.getNumBanks();
            while (--n >= 0) {
                DeferredPlanarImage.fill(dataBuffer, n, n2);
            }
        }
        if (n3 != n2 && sampleModel.getNumBands() == 1) {
            n = sampleModel.getWidth();
            int n4 = 2;
            int n5 = (n + 1) * n4;
            switch (dataBuffer.getDataType()) {
                case 0: {
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData(0);
                    Arrays.fill(byArray, 0, n5, (byte)n3);
                    Arrays.fill(byArray, byArray.length - n5, byArray.length, (byte)n3);
                    n4 *= 2;
                    while ((n5 += n) < byArray.length) {
                        Arrays.fill(byArray, n5 - n4, n5, (byte)n3);
                    }
                    break;
                }
            }
        }
        buffers.put((Entry)object, dataBuffer);
        return dataBuffer;
    }

    private static void fill(DataBuffer dataBuffer, int n, int n2) {
        switch (dataBuffer.getDataType()) {
            case 0: {
                Arrays.fill(((DataBufferByte)dataBuffer).getData(n), (byte)n2);
                break;
            }
            case 2: {
                Arrays.fill(((DataBufferShort)dataBuffer).getData(n), (short)n2);
                break;
            }
            case 1: {
                Arrays.fill(((DataBufferUShort)dataBuffer).getData(n), (short)n2);
                break;
            }
            case 3: {
                Arrays.fill(((DataBufferInt)dataBuffer).getData(n), n2);
                break;
            }
            case 4: {
                Arrays.fill(((DataBufferFloat)dataBuffer).getData(n), (float)n2);
                break;
            }
            case 5: {
                Arrays.fill(((DataBufferDouble)dataBuffer).getData(n), (double)n2);
                break;
            }
            default: {
                throw new RasterFormatException(String.valueOf(dataBuffer));
            }
        }
    }

    private void fireTileUpdate(int n, int n2, boolean bl) {
        TileObserver[] tileObserverArray = this.observers;
        if (tileObserverArray != null) {
            int n3 = tileObserverArray.length;
            for (int i = 0; i < n3; ++i) {
                try {
                    tileObserverArray[i].tileUpdate(this, n, n2, bl);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    String string = runtimeException.getLocalizedMessage();
                    if (string == null) {
                        string = Classes.getShortClassName((Object)runtimeException);
                    }
                    LogRecord logRecord = new LogRecord(Level.WARNING, string);
                    logRecord.setSourceClassName(tileObserverArray[i].getClass().getCanonicalName());
                    logRecord.setSourceMethodName("tileUpdate");
                    logRecord.setThrown(runtimeException);
                    logRecord.setLoggerName(LOGGER.getName());
                    LOGGER.log(logRecord);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tileComputed(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Raster raster) {
        DeferredPlanarImage deferredPlanarImage = this;
        synchronized (deferredPlanarImage) {
            int n3 = this.getTileIndice(n, n2);
            if (this.waitings != null && this.waitings[n3]) {
                this.notify();
            }
            if (this.pendings == null || this.pendings[n3] == null) {
                return;
            }
            this.pendings[n3] = null;
        }
        this.fireTileUpdate(n, n2, false);
    }

    public void tileCancelled(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2) {
    }

    public void tileComputationFailure(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Throwable throwable) {
        LogRecord logRecord = new LogRecord(Level.WARNING, throwable.getLocalizedMessage());
        logRecord.setSourceClassName(DeferredPlanarImage.class.getName());
        logRecord.setSourceMethodName("getTile");
        logRecord.setThrown(throwable);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    @Override
    public void tileUpdate(WritableRenderedImage writableRenderedImage, int n, int n2, boolean bl) {
        this.fireTileUpdate(n, n2, bl);
    }

    @Override
    public synchronized void addTileObserver(TileObserver tileObserver) {
        if (tileObserver != null) {
            this.observers = this.observers == null ? new TileObserver[]{tileObserver} : (TileObserver[])ArraysExt.append((Object[])this.observers, (Object)tileObserver);
        }
    }

    @Override
    public synchronized void removeTileObserver(TileObserver tileObserver) {
        if (this.observers != null) {
            int n = this.observers.length;
            while (--n >= 0) {
                if (this.observers[n] != tileObserver) continue;
                this.observers = (TileObserver[])ArraysExt.remove((Object[])this.observers, (int)n, (int)1);
                break;
            }
        }
    }

    @Override
    public WritableRaster getWritableTile(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseWritableTile(int n, int n2) {
        throw new IllegalStateException();
    }

    @Override
    public synchronized boolean hasTileWriters() {
        Raster[] rasterArray = this.pendings;
        if (rasterArray != null) {
            int n = rasterArray.length;
            for (int i = 0; i < n; ++i) {
                if (rasterArray[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isTileWritable(int n, int n2) {
        Raster[] rasterArray = this.pendings;
        return rasterArray != null && rasterArray[this.getTileIndice(n, n2)] != null;
    }

    @Override
    public synchronized Point[] getWritableTileIndices() {
        Raster[] rasterArray = this.pendings;
        Point[] pointArray = null;
        if (rasterArray != null) {
            int n = 0;
            int n2 = this.getMinTileX();
            int n3 = this.getMinTileY();
            int n4 = this.getNumXTiles();
            int n5 = rasterArray.length;
            for (int i = 0; i < n5; ++i) {
                if (rasterArray[i] == null) continue;
                if (pointArray == null) {
                    pointArray = new Point[n5 - i];
                }
                int n6 = i % n4 + n2;
                int n7 = i / n4 + n3;
                assert (this.getTileIndice(n6, n7) == i) : i;
                pointArray[n++] = new Point(n6, n7);
            }
            if (pointArray != null) {
                pointArray = (Point[])ArraysExt.resize(pointArray, (int)n);
            }
        }
        return pointArray;
    }

    @Override
    public void setData(Raster raster) {
        throw new UnsupportedOperationException();
    }

    public synchronized void dispose() {
        if (this.image instanceof WritableRenderedImage) {
            ((WritableRenderedImage)this.image).removeTileObserver(this);
        }
        this.image.removeTileComputationListener((TileComputationListener)this);
        this.requests = null;
        this.waitings = null;
        this.pendings = null;
        super.dispose();
        this.image.dispose();
    }

    private static final class Entry {
        public final SampleModel model;
        public final int fill;
        public final int box;

        public Entry(SampleModel sampleModel, int n, int n2) {
            this.model = sampleModel;
            this.fill = n;
            this.box = n2;
        }

        public int hashCode() {
            return this.model.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return this.model.equals(entry.model) && this.fill == entry.fill && this.box == entry.box;
            }
            return false;
        }
    }
}

